/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.parser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilderUtil;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesBinders;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParser;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicJavaParserUtil;
import org.jetbrains.kotlin.com.intellij.lang.java.parser.BasicReferenceParser;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;

@ApiStatus.Experimental
public class BasicPrattExpressionParser {
    private final Map<IElementType, ParserData> ourInfixParsers;
    private static final TokenSet THIS_OR_SUPER = TokenSet.create(JavaTokenType.THIS_KEYWORD, JavaTokenType.SUPER_KEYWORD);
    private static final TokenSet ID_OR_SUPER = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.SUPER_KEYWORD);
    private static final TokenSet ARGS_LIST_CONTINUE = TokenSet.create(JavaTokenType.IDENTIFIER, TokenType.BAD_CHARACTER, JavaTokenType.COMMA, JavaTokenType.INTEGER_LITERAL, JavaTokenType.STRING_LITERAL);
    private static final TokenSet ARGS_LIST_END = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.RBRACE, JavaTokenType.RBRACKET);
    private final TokenSet TYPE_START;
    private static final TokenSet POSTFIX_OPS = TokenSet.create(JavaTokenType.PLUSPLUS, JavaTokenType.MINUSMINUS);
    private static final TokenSet PREF_ARITHMETIC_OPS = TokenSet.orSet(POSTFIX_OPS, TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS));
    private static final TokenSet PREFIX_OPS = TokenSet.orSet(PREF_ARITHMETIC_OPS, TokenSet.create(JavaTokenType.TILDE, JavaTokenType.EXCL));
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder;

    public BasicPrattExpressionParser(@NotNull BasicJavaParser parser) {
        if (parser == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(0);
        }
        this.TYPE_START = TokenSet.orSet(BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET, TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.AT));
        this.myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;
        this.myParser = parser;
        this.myJavaElementTypeContainer = parser.getJavaElementTypeFactory().getContainer();
        this.ourInfixParsers = new HashMap<IElementType, ParserData>();
        AssignmentParser assignmentParser = new AssignmentParser();
        PolyExprParser polyExprParser = new PolyExprParser();
        InstanceofParser instanceofParser = new InstanceofParser();
        ConditionalExprParser conditionalExprParser = new ConditionalExprParser();
        for (IElementType type : Arrays.asList(JavaTokenType.EQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.PERCEQ, JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ, JavaTokenType.GTGTGTEQ, JavaTokenType.ANDEQ, JavaTokenType.OREQ, JavaTokenType.XOREQ)) {
            this.ourInfixParsers.put(type, new ParserData(13, assignmentParser));
        }
        for (IElementType type : Arrays.asList(JavaTokenType.PLUS, JavaTokenType.MINUS)) {
            this.ourInfixParsers.put(type, new ParserData(3, polyExprParser));
        }
        for (IElementType type : Arrays.asList(JavaTokenType.DIV, JavaTokenType.ASTERISK, JavaTokenType.PERC)) {
            this.ourInfixParsers.put(type, new ParserData(2, polyExprParser));
        }
        for (IElementType type : Arrays.asList(JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT)) {
            this.ourInfixParsers.put(type, new ParserData(4, polyExprParser));
        }
        for (IElementType type : Arrays.asList(JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE)) {
            this.ourInfixParsers.put(type, new ParserData(5, polyExprParser));
        }
        this.ourInfixParsers.put(JavaTokenType.INSTANCEOF_KEYWORD, new ParserData(5, instanceofParser));
        for (IElementType type : Arrays.asList(JavaTokenType.EQEQ, JavaTokenType.NE)) {
            this.ourInfixParsers.put(type, new ParserData(6, polyExprParser));
        }
        this.ourInfixParsers.put(JavaTokenType.OR, new ParserData(9, polyExprParser));
        this.ourInfixParsers.put(JavaTokenType.AND, new ParserData(7, polyExprParser));
        this.ourInfixParsers.put(JavaTokenType.XOR, new ParserData(8, polyExprParser));
        this.ourInfixParsers.put(JavaTokenType.ANDAND, new ParserData(10, polyExprParser));
        this.ourInfixParsers.put(JavaTokenType.OROR, new ParserData(11, polyExprParser));
        this.ourInfixParsers.put(JavaTokenType.QUEST, new ParserData(12, conditionalExprParser));
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder) {
        if (builder == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(1);
        }
        return this.tryParseWithPrecedenceAtMost(builder, 13, 0);
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder, int mode) {
        if (builder == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(2);
        }
        return this.tryParseWithPrecedenceAtMost(builder, 13, mode);
    }

    @Nullable
    public PsiBuilder.Marker tryParseWithPrecedenceAtMost(@NotNull PsiBuilder builder, int maxPrecedence, int mode) {
        int opPrecedence;
        ParserData data;
        IElementType type;
        PsiBuilder.Marker lhs;
        if (builder == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(3);
        }
        if ((lhs = this.parseUnary(builder, mode)) == null) {
            return null;
        }
        while ((type = BasicPrattExpressionParser.getBinOpToken(builder)) != null && (data = this.ourInfixParsers.get(type)) != null && maxPrecedence >= (opPrecedence = data.myPrecedence)) {
            PsiBuilder.Marker beforeLhs = lhs.precede();
            data.myParser.parse(this, builder, beforeLhs, type, opPrecedence, mode);
            lhs = beforeLhs;
        }
        return lhs;
    }

    @Nullable
    private PsiBuilder.Marker parseUnary(PsiBuilder builder, int mode) {
        IElementType tokenType = builder.getTokenType();
        if (PREFIX_OPS.contains(tokenType)) {
            PsiBuilder.Marker unary = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker operand = this.parseUnary(builder, mode);
            if (operand == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            unary.done(this.myJavaElementTypeContainer.PREFIX_EXPRESSION);
            return unary;
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker typeCast = builder.mark();
            builder.advanceLexer();
            BasicReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 101);
            if (typeInfo == null || !PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder, mode);
            }
            if (PREF_ARITHMETIC_OPS.contains(builder.getTokenType()) && !typeInfo.isPrimitive) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder, mode);
            }
            PsiBuilder.Marker expr = this.parseUnary(builder, mode);
            if (expr == null) {
                if (!typeInfo.isParameterized) {
                    typeCast.rollbackTo();
                    return this.parsePostfix(builder, mode);
                }
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            typeCast.done(this.myJavaElementTypeContainer.TYPE_CAST_EXPRESSION);
            return typeCast;
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.myParser.getStatementParser().parseExprInParenthWithBlock(builder, this.myJavaElementTypeContainer.SWITCH_EXPRESSION, true);
        }
        return this.parsePostfix(builder, mode);
    }

    @Nullable
    private PsiBuilder.Marker parsePostfix(PsiBuilder builder, int mode) {
        PsiBuilder.Marker operand = this.parsePrimary(builder, null, -1, mode);
        if (operand == null) {
            return null;
        }
        while (POSTFIX_OPS.contains(builder.getTokenType())) {
            PsiBuilder.Marker postfix = operand.precede();
            builder.advanceLexer();
            postfix.done(this.myJavaElementTypeContainer.POSTFIX_EXPRESSION);
            operand = postfix;
        }
        return operand;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimary(PsiBuilder builder, @Nullable BreakPoint breakPoint, int breakOffset, int mode) {
        IElementType tokenType;
        PsiBuilder.Marker startMarker = builder.mark();
        PsiBuilder.Marker expr = this.parsePrimaryExpressionStart(builder, mode);
        if (expr == null) {
            startMarker.drop();
            return null;
        }
        while (true) {
            if ((tokenType = builder.getTokenType()) == JavaTokenType.DOT) {
                PsiBuilder.Marker refExpr;
                int offset;
                PsiBuilder.Marker copy;
                PsiBuilder.Marker dotPos = builder.mark();
                int dotOffset = builder.getCurrentOffset();
                builder.advanceLexer();
                IElementType dotTokenType = builder.getTokenType();
                if (dotTokenType == JavaTokenType.AT) {
                    this.myParser.getDeclarationParser().parseAnnotations(builder);
                    dotTokenType = builder.getTokenType();
                }
                if (dotTokenType == JavaTokenType.CLASS_KEYWORD && BasicJavaParserUtil.exprType(expr) == this.myJavaElementTypeContainer.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P1 && builder.getCurrentOffset() == breakOffset) {
                        BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        PsiBuilderUtil.drop(startMarker, dotPos);
                        return expr;
                    }
                    copy = startMarker.precede();
                    offset = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder);
                    if (classObjAccess == null || builder.getCurrentOffset() < offset) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P1, offset, mode);
                    }
                    startMarker = copy;
                    expr = classObjAccess;
                    continue;
                }
                if (dotTokenType == JavaTokenType.NEW_KEYWORD) {
                    dotPos.drop();
                    expr = this.parseNew(builder, expr);
                    continue;
                }
                if (dotTokenType == JavaTokenType.SUPER_KEYWORD && builder.lookAhead(1) == JavaTokenType.LPARENTH) {
                    dotPos.drop();
                    refExpr = expr.precede();
                    builder.mark().done(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
                    builder.advanceLexer();
                    refExpr.done(this.myJavaElementTypeContainer.REFERENCE_EXPRESSION);
                    expr = refExpr;
                    continue;
                }
                if (THIS_OR_SUPER.contains(dotTokenType) && BasicJavaParserUtil.exprType(expr) == this.myJavaElementTypeContainer.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P2 && builder.getCurrentOffset() == breakOffset) {
                        dotPos.rollbackTo();
                        startMarker.drop();
                        return expr;
                    }
                    copy = startMarker.precede();
                    offset = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
                    if (ref == null || builder.getTokenType() != JavaTokenType.DOT || builder.getCurrentOffset() != dotOffset) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset, mode);
                    }
                    builder.advanceLexer();
                    if (builder.getTokenType() != dotTokenType) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset, mode);
                    }
                    builder.advanceLexer();
                    startMarker = copy;
                    expr = ref.precede();
                    expr.done(dotTokenType == JavaTokenType.THIS_KEYWORD ? this.myJavaElementTypeContainer.THIS_EXPRESSION : this.myJavaElementTypeContainer.SUPER_EXPRESSION);
                    continue;
                }
                refExpr = expr.precede();
                this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
                if (!PsiBuilderUtil.expect(builder, ID_OR_SUPER)) {
                    dotPos.rollbackTo();
                    builder.advanceLexer();
                    this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    refExpr.done(this.myJavaElementTypeContainer.REFERENCE_EXPRESSION);
                    startMarker.drop();
                    return refExpr;
                }
                dotPos.drop();
                refExpr.done(this.myJavaElementTypeContainer.REFERENCE_EXPRESSION);
                expr = refExpr;
                continue;
            }
            if (tokenType == JavaTokenType.LPARENTH) {
                if (BasicJavaParserUtil.exprType(expr) != this.myJavaElementTypeContainer.REFERENCE_EXPRESSION) {
                    startMarker.drop();
                    return expr;
                }
                PsiBuilder.Marker callExpr = expr.precede();
                this.parseArgumentList(builder);
                callExpr.done(this.myJavaElementTypeContainer.METHOD_CALL_EXPRESSION);
                expr = callExpr;
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) break;
            if (breakPoint == BreakPoint.P4) {
                startMarker.drop();
                return expr;
            }
            builder.advanceLexer();
            if (builder.getTokenType() == JavaTokenType.RBRACKET && BasicJavaParserUtil.exprType(expr) == this.myJavaElementTypeContainer.REFERENCE_EXPRESSION) {
                int pos = builder.getCurrentOffset();
                PsiBuilder.Marker copy = startMarker.precede();
                startMarker.rollbackTo();
                PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder);
                if (classObjAccess == null || builder.getCurrentOffset() <= pos) {
                    copy.rollbackTo();
                    return this.parsePrimary(builder, BreakPoint.P4, -1, mode);
                }
                startMarker = copy;
                expr = classObjAccess;
                continue;
            }
            PsiBuilder.Marker arrayAccess = expr.precede();
            PsiBuilder.Marker index = this.parse(builder, mode);
            if (index == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                arrayAccess.done(this.myJavaElementTypeContainer.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            if (builder.getTokenType() != JavaTokenType.RBRACKET) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbracket", new Object[0]));
                arrayAccess.done(this.myJavaElementTypeContainer.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            builder.advanceLexer();
            arrayAccess.done(this.myJavaElementTypeContainer.ARRAY_ACCESS_EXPRESSION);
            expr = arrayAccess;
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder, startMarker);
        }
        startMarker.drop();
        return expr;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimaryExpressionStart(PsiBuilder builder, int mode) {
        IElementType tokenType = builder.getTokenType();
        if (BasicElementTypes.BASIC_ALL_LITERALS.contains(tokenType)) {
            PsiBuilder.Marker literal = builder.mark();
            builder.advanceLexer();
            literal.done(this.myJavaElementTypeContainer.LITERAL_EXPRESSION);
            return literal;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseArrayInitializer(builder);
        }
        if (tokenType == JavaTokenType.NEW_KEYWORD) {
            return this.parseNew(builder, null);
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker lambda;
            if (!BitUtil.isSet(mode, 1) && (lambda = this.parseLambdaAfterParenth(builder)) != null) {
                return lambda;
            }
            PsiBuilder.Marker parenth = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker inner = this.parse(builder, mode);
            if (inner == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH) && inner != null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            }
            parenth.done(this.myJavaElementTypeContainer.PARENTH_EXPRESSION);
            return parenth;
        }
        if (this.TYPE_START.contains(tokenType)) {
            PsiBuilder.Marker mark = builder.mark();
            BasicReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 0);
            if (typeInfo != null) {
                PsiBuilder.Marker result2;
                boolean optionalClassKeyword;
                boolean bl = optionalClassKeyword = typeInfo.isPrimitive || typeInfo.isArray;
                if ((optionalClassKeyword || !typeInfo.hasErrors && typeInfo.isParameterized) && (result2 = this.parseClassAccessOrMethodReference(builder, mark, optionalClassKeyword)) != null) {
                    return result2;
                }
            }
            mark.rollbackTo();
        }
        PsiBuilder.Marker annotation = null;
        if (tokenType == JavaTokenType.AT) {
            annotation = this.myParser.getDeclarationParser().parseAnnotations(builder);
            tokenType = builder.getTokenType();
        }
        if (tokenType == JavaTokenType.VAR_KEYWORD) {
            tokenType = JavaTokenType.IDENTIFIER;
            builder.remapCurrentToken(tokenType);
        }
        if (tokenType == JavaTokenType.IDENTIFIER) {
            PsiBuilder.Marker refExpr;
            if (!BitUtil.isSet(mode, 1) && builder.lookAhead(1) == JavaTokenType.ARROW) {
                return this.parseLambdaExpression(builder, false);
            }
            if (annotation != null) {
                PsiBuilder.Marker refParam = annotation.precede();
                refParam.doneBefore(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST, annotation);
                refExpr = refParam.precede();
            } else {
                refExpr = builder.mark();
                builder.mark().done(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            refExpr.done(this.myJavaElementTypeContainer.REFERENCE_EXPRESSION);
            return refExpr;
        }
        if (annotation != null) {
            annotation.rollbackTo();
            tokenType = builder.getTokenType();
        }
        PsiBuilder.Marker expr = null;
        if (tokenType == JavaTokenType.LT) {
            expr = builder.mark();
            if (!this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false)) {
                expr.rollbackTo();
                return null;
            }
            tokenType = builder.getTokenType();
            if (!THIS_OR_SUPER.contains(tokenType)) {
                expr.rollbackTo();
                return null;
            }
        }
        if (THIS_OR_SUPER.contains(tokenType)) {
            if (expr == null) {
                expr = builder.mark();
                builder.mark().done(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            expr.done(builder.getTokenType() == JavaTokenType.LPARENTH ? this.myJavaElementTypeContainer.REFERENCE_EXPRESSION : (tokenType == JavaTokenType.THIS_KEYWORD ? this.myJavaElementTypeContainer.THIS_EXPRESSION : this.myJavaElementTypeContainer.SUPER_EXPRESSION));
            return expr;
        }
        return null;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        boolean primitive = BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET.contains(builder.getTokenType());
        if (this.myParser.getReferenceParser().parseType(builder, 0) == null) {
            expr.drop();
            return null;
        }
        PsiBuilder.Marker result2 = this.parseClassAccessOrMethodReference(builder, expr, primitive);
        if (result2 == null) {
            expr.rollbackTo();
        }
        return result2;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.DOT) {
            return this.parseClassObjectAccess(builder, expr, optionalClassKeyword);
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder, expr);
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker parseMethodReference(PsiBuilder builder, PsiBuilder.Marker start) {
        builder.advanceLexer();
        this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER) && !PsiBuilderUtil.expect(builder, JavaTokenType.NEW_KEYWORD)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
        }
        start.done(this.myJavaElementTypeContainer.METHOD_REF_EXPRESSION);
        PsiBuilder.Marker marker = start;
        if (marker == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(4);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseNew(PsiBuilder builder, @Nullable PsiBuilder.Marker start) {
        int dimCount;
        PsiBuilder.Marker anno;
        PsiBuilder.Marker newExpr;
        block19: {
            PsiBuilder.Marker refOrType;
            newExpr = start != null ? start.precede() : builder.mark();
            builder.advanceLexer();
            this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, true);
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                PsiBuilderUtil.rollbackTo(anno);
                refOrType = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, true, true);
                if (refOrType == null) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
                    PsiBuilder.Marker marker = newExpr;
                    if (marker == null) {
                        BasicPrattExpressionParser.$$$reportNull$$$0(5);
                    }
                    return marker;
                }
            } else if (BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
                refOrType = null;
                builder.advanceLexer();
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    BasicPrattExpressionParser.$$$reportNull$$$0(6);
                }
                return marker;
            }
            if (refOrType != null && builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.parseArgumentList(builder);
                if (builder.getTokenType() == JavaTokenType.LBRACE) {
                    PsiBuilder.Marker classElement = refOrType.precede();
                    this.myParser.getDeclarationParser().parseClassBodyWithBraces(builder, false, false);
                    classElement.done(this.myJavaElementTypeContainer.ANONYMOUS_CLASS);
                }
                newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    BasicPrattExpressionParser.$$$reportNull$$$0(7);
                }
                return marker;
            }
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (builder.getTokenType() != JavaTokenType.LBRACKET) {
                PsiBuilderUtil.rollbackTo(anno);
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message(refOrType == null ? "expected.lbracket" : "expected.lparen.or.lbracket", new Object[0]));
                newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    BasicPrattExpressionParser.$$$reportNull$$$0(8);
                }
                return marker;
            }
            int bracketCount = 0;
            dimCount = 0;
            do {
                PsiBuilder.Marker dimExpr;
                anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
                if (builder.getTokenType() != JavaTokenType.LBRACKET) break block19;
                builder.advanceLexer();
                if (bracketCount == dimCount && (dimExpr = this.parse(builder, 0)) != null) {
                    ++dimCount;
                }
                ++bracketCount;
            } while (BasicJavaParserUtil.expectOrError(builder, JavaTokenType.RBRACKET, "expected.rbracket"));
            newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
            PsiBuilder.Marker marker = newExpr;
            if (marker == null) {
                BasicPrattExpressionParser.$$$reportNull$$$0(9);
            }
            return marker;
        }
        PsiBuilderUtil.rollbackTo(anno);
        if (dimCount == 0) {
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                this.parseArrayInitializer(builder);
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.array.initializer", new Object[0]));
            }
        }
        newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
        PsiBuilder.Marker marker = newExpr;
        if (marker == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(10);
        }
        return marker;
    }

    @NotNull
    private PsiBuilder.Marker parseArrayInitializer(PsiBuilder builder) {
        PsiBuilder.Marker marker = this.parseArrayInitializer(builder, this.myJavaElementTypeContainer.ARRAY_INITIALIZER_EXPRESSION, this::parse, "expected.expression");
        if (marker == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(11);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseArrayInitializer(@NotNull PsiBuilder builder, @NotNull IElementType type, @NotNull Function<? super PsiBuilder, PsiBuilder.Marker> elementParser, @NotNull @PropertyKey(resourceBundle="messages.JavaPsiBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaPsiBundle") String missingElementKey) {
        if (builder == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(12);
        }
        if (type == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(13);
        }
        if (elementParser == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(14);
        }
        if (missingElementKey == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(15);
        }
        PsiBuilder.Marker arrayInit = builder.mark();
        builder.advanceLexer();
        boolean first = true;
        while (true) {
            if (builder.getTokenType() == JavaTokenType.RBRACE) {
                builder.advanceLexer();
                break;
            }
            if (builder.getTokenType() == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbrace", new Object[0]));
                break;
            }
            if (elementParser.apply(builder) == null) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    if (first && builder.lookAhead(1) == JavaTokenType.RBRACE) {
                        PsiBuilderUtil.advance(builder, 2);
                        break;
                    }
                    builder.error(JavaPsiBundle.message(missingElementKey, new Object[0]));
                } else if (builder.getTokenType() != JavaTokenType.RBRACE) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbrace", new Object[0]));
                    break;
                }
            }
            first = false;
            IElementType tokenType = builder.getTokenType();
            if (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA) || tokenType == JavaTokenType.RBRACE) continue;
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma", new Object[0]));
        }
        arrayInit.done(type);
        PsiBuilder.Marker marker = arrayInit;
        if (marker == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(16);
        }
        return marker;
    }

    @NotNull
    public PsiBuilder.Marker parseArgumentList(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        builder.advanceLexer();
        boolean first = true;
        while (true) {
            IElementType tokenType = builder.getTokenType();
            if (first && (ARGS_LIST_END.contains(tokenType) || builder.eof()) || !first && !ARGS_LIST_CONTINUE.contains(tokenType)) break;
            boolean hasError = false;
            if (!first) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    builder.advanceLexer();
                } else {
                    hasError = true;
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]));
                    this.emptyExpression(builder);
                }
            }
            first = false;
            PsiBuilder.Marker arg = this.parse(builder, 0);
            if (arg != null) continue;
            if (!hasError) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                this.emptyExpression(builder);
            }
            if (!ARGS_LIST_CONTINUE.contains(builder.getTokenType())) break;
            if (builder.getTokenType() == JavaTokenType.COMMA || builder.eof()) continue;
            builder.advanceLexer();
        }
        boolean closed = true;
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
            if (first) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]));
            }
            closed = false;
        }
        list.done(this.myJavaElementTypeContainer.EXPRESSION_LIST);
        if (!closed) {
            list.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        PsiBuilder.Marker marker = list;
        if (marker == null) {
            BasicPrattExpressionParser.$$$reportNull$$$0(17);
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaAfterParenth(PsiBuilder builder) {
        boolean isTyped;
        boolean isLambda;
        IElementType nextToken1 = builder.lookAhead(1);
        IElementType nextToken2 = builder.lookAhead(2);
        if (nextToken1 == JavaTokenType.RPARENTH && nextToken2 == JavaTokenType.ARROW) {
            isLambda = true;
            isTyped = false;
        } else if (nextToken1 == JavaTokenType.AT || BasicElementTypes.BASIC_MODIFIER_BIT_SET.contains(nextToken1) || BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET.contains(nextToken1)) {
            isLambda = true;
            isTyped = true;
        } else if (nextToken1 == JavaTokenType.IDENTIFIER) {
            if (nextToken2 == JavaTokenType.COMMA || nextToken2 == JavaTokenType.RPARENTH && builder.lookAhead(3) == JavaTokenType.ARROW) {
                isLambda = true;
                isTyped = false;
            } else if (nextToken2 == JavaTokenType.ARROW) {
                isLambda = false;
                isTyped = false;
            } else {
                IElementType t2;
                boolean lambda = false;
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                BasicReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 7);
                if (typeInfo != null && ((t2 = builder.getTokenType()) == JavaTokenType.IDENTIFIER || t2 == JavaTokenType.THIS_KEYWORD || t2 == JavaTokenType.RPARENTH && builder.lookAhead(1) == JavaTokenType.ARROW)) {
                    lambda = true;
                }
                marker.rollbackTo();
                isLambda = lambda;
                isTyped = true;
            }
        } else {
            isLambda = false;
            isTyped = false;
        }
        return isLambda ? this.parseLambdaExpression(builder, isTyped) : null;
    }

    private PsiBuilder.Marker parseLambdaExpression(PsiBuilder builder, boolean typed) {
        PsiBuilder.Marker start = builder.mark();
        this.myParser.getDeclarationParser().parseLambdaParameterList(builder, typed);
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.ARROW)) {
            start.rollbackTo();
            return null;
        }
        PsiBuilder.Marker body = builder.getTokenType() == JavaTokenType.LBRACE ? this.myParser.getStatementParser().parseCodeBlock(builder) : this.parse(builder, 0);
        if (body == null) {
            builder.error(JavaPsiBundle.message("expected.lbrace", new Object[0]));
        }
        start.done(this.myJavaElementTypeContainer.LAMBDA_EXPRESSION);
        return start;
    }

    private static IElementType getBinOpToken(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.GT) {
            return tokenType;
        }
        if (builder.rawLookup(1) == JavaTokenType.GT) {
            tokenType = builder.rawLookup(2) == JavaTokenType.GT ? (builder.rawLookup(3) == JavaTokenType.EQ ? JavaTokenType.GTGTGTEQ : JavaTokenType.GTGTGT) : (builder.rawLookup(2) == JavaTokenType.EQ ? JavaTokenType.GTGTEQ : JavaTokenType.GTGT);
        } else if (builder.rawLookup(1) == JavaTokenType.EQ) {
            tokenType = JavaTokenType.GE;
        }
        return tokenType;
    }

    private static void advanceBinOpToken(PsiBuilder builder, IElementType type) {
        PsiBuilder.Marker gtToken = builder.mark();
        if (type == JavaTokenType.GTGTGTEQ) {
            PsiBuilderUtil.advance(builder, 4);
        } else if (type == JavaTokenType.GTGTGT || type == JavaTokenType.GTGTEQ) {
            PsiBuilderUtil.advance(builder, 3);
        } else if (type == JavaTokenType.GTGT || type == JavaTokenType.GE) {
            PsiBuilderUtil.advance(builder, 2);
        } else {
            gtToken.drop();
            builder.advanceLexer();
            return;
        }
        gtToken.collapse(type);
    }

    @Nullable
    private PsiBuilder.Marker parseClassObjectAccess(PsiBuilder builder, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == JavaTokenType.CLASS_KEYWORD) {
            mark.drop();
            builder.advanceLexer();
        } else {
            if (!optionalClassKeyword) {
                return null;
            }
            mark.rollbackTo();
            builder.error(JavaPsiBundle.message("class.literal.expected", new Object[0]));
        }
        expr.done(this.myJavaElementTypeContainer.CLASS_OBJECT_ACCESS_EXPRESSION);
        return expr;
    }

    private void emptyExpression(PsiBuilder builder) {
        BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.EMPTY_STATEMENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicPrattExpressionParser";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementParser";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingElementKey";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/parser/BasicPrattExpressionParser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethodReference";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNew";
                break;
            }
            case 11: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArrayInitializer";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "parseArgumentList";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryParseWithPrecedenceAtMost";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseArrayInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class AssignmentParser
    implements InfixParser {
        private AssignmentParser() {
        }

        @Override
        public void parse(BasicPrattExpressionParser parser, PsiBuilder builder, PsiBuilder.Marker beforeLhs, IElementType binOpType, int currentPrecedence, int mode) {
            BasicPrattExpressionParser.advanceBinOpToken(builder, binOpType);
            PsiBuilder.Marker right = parser.tryParseWithPrecedenceAtMost(builder, 13, mode);
            if (right == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            BasicJavaParserUtil.done(beforeLhs, ((BasicPrattExpressionParser)BasicPrattExpressionParser.this).myJavaElementTypeContainer.ASSIGNMENT_EXPRESSION, BasicPrattExpressionParser.this.myWhiteSpaceAndCommentSetHolder);
        }
    }

    private final class PolyExprParser
    implements InfixParser {
        private PolyExprParser() {
        }

        @Override
        public void parse(BasicPrattExpressionParser parser, PsiBuilder builder, PsiBuilder.Marker beforeLhs, IElementType binOpType, int currentPrecedence, int mode) {
            IElementType nextToken;
            PsiBuilder.Marker rhs;
            int operandCount = 1;
            do {
                BasicPrattExpressionParser.advanceBinOpToken(builder, binOpType);
                rhs = parser.tryParseWithPrecedenceAtMost(builder, currentPrecedence - 1, mode);
                nextToken = BasicPrattExpressionParser.getBinOpToken(builder);
                if (rhs == null) continue;
                ++operandCount;
            } while (rhs != null && nextToken == binOpType);
            if (rhs == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            BasicJavaParserUtil.done(beforeLhs, operandCount > 2 ? ((BasicPrattExpressionParser)BasicPrattExpressionParser.this).myJavaElementTypeContainer.POLYADIC_EXPRESSION : ((BasicPrattExpressionParser)BasicPrattExpressionParser.this).myJavaElementTypeContainer.BINARY_EXPRESSION, BasicPrattExpressionParser.this.myWhiteSpaceAndCommentSetHolder);
        }
    }

    private final class InstanceofParser
    implements InfixParser {
        private InstanceofParser() {
        }

        @Override
        public void parse(BasicPrattExpressionParser parser, PsiBuilder builder, PsiBuilder.Marker beforeLhs, IElementType binOpType, int currentPrecedence, int mode) {
            builder.advanceLexer();
            BasicJavaParser javaParser = parser.myParser;
            if (!javaParser.getPatternParser().isPattern(builder)) {
                PsiBuilder.Marker type = javaParser.getReferenceParser().parseType(builder, 5);
                if (type == null) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
                }
            } else {
                javaParser.getPatternParser().parsePrimaryPattern(builder, false);
            }
            beforeLhs.done(((BasicPrattExpressionParser)BasicPrattExpressionParser.this).myJavaElementTypeContainer.INSTANCE_OF_EXPRESSION);
        }
    }

    private final class ConditionalExprParser
    implements InfixParser {
        private ConditionalExprParser() {
        }

        @Override
        public void parse(BasicPrattExpressionParser parser, PsiBuilder builder, PsiBuilder.Marker beforeLhs, IElementType binOpType, int currentPrecedence, int mode) {
            builder.advanceLexer();
            PsiBuilder.Marker truePart = parser.parse(builder, mode);
            if (truePart == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                beforeLhs.done(((BasicPrattExpressionParser)BasicPrattExpressionParser.this).myJavaElementTypeContainer.CONDITIONAL_EXPRESSION);
                return;
            }
            if (builder.getTokenType() != JavaTokenType.COLON) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.colon", new Object[0]));
                beforeLhs.done(((BasicPrattExpressionParser)BasicPrattExpressionParser.this).myJavaElementTypeContainer.CONDITIONAL_EXPRESSION);
                return;
            }
            builder.advanceLexer();
            PsiBuilder.Marker falsePart = parser.tryParseWithPrecedenceAtMost(builder, 12, mode);
            if (falsePart == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            beforeLhs.done(((BasicPrattExpressionParser)BasicPrattExpressionParser.this).myJavaElementTypeContainer.CONDITIONAL_EXPRESSION);
        }
    }

    private static final class ParserData {
        private final int myPrecedence;
        private final InfixParser myParser;

        private ParserData(int precedence, InfixParser parser) {
            this.myPrecedence = precedence;
            this.myParser = parser;
        }
    }

    private static interface InfixParser {
        public void parse(BasicPrattExpressionParser var1, PsiBuilder var2, PsiBuilder.Marker var3, IElementType var4, int var5, int var6);
    }

    private static enum BreakPoint {
        P1,
        P2,
        P4;

    }
}

