/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.problems.internal.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.FileLocation;
import org.gradle.api.problems.LineInFileLocation;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemLocation;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.PluginIdLocation;
import org.gradle.api.problems.internal.StackTraceLocation;
import org.gradle.api.problems.internal.TaskLocation;
import org.gradle.internal.cc.impl.problems.JsonSource;
import org.gradle.internal.cc.impl.problems.JsonWriter;
import org.gradle.internal.configuration.problems.DecoratedFailure;
import org.gradle.internal.configuration.problems.DecoratedReportProblemKt;
import org.gradle.internal.configuration.problems.FailureDecorator;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.problems.internal.impl.DefaultProblemsReportCreatorKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u000b*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\u00020\u000b*\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u000b*\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0002J\u0016\u0010\u0016\u001a\u00020\u000b*\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0016\u0010\u0019\u001a\u00020\u000b*\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J(\u0010\u001c\u001a\u00020\u000b*\u00020\r2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0014\u0010!\u001a\u00020\u000b*\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\u00020\u000b*\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00130\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gradle/problems/internal/impl/JsonProblemWriter;", "Lorg/gradle/internal/cc/impl/problems/JsonSource;", "problem", "Lorg/gradle/api/problems/internal/InternalProblem;", "failureDecorator", "Lorg/gradle/internal/configuration/problems/FailureDecorator;", "failureFactory", "Lorg/gradle/internal/problems/failure/FailureFactory;", "<init>", "(Lorg/gradle/api/problems/internal/InternalProblem;Lorg/gradle/internal/configuration/problems/FailureDecorator;Lorg/gradle/internal/problems/failure/FailureFactory;)V", "writeToJson", "", "jsonWriter", "Lorg/gradle/internal/cc/impl/problems/JsonWriter;", "writeSeverity", "severity", "Lorg/gradle/api/problems/Severity;", "writeContextualLabel", "contextualLabel", "", "writeDetails", "details", "writeDocumentationLink", "docLink", "Lorg/gradle/api/problems/DocLink;", "writeException", "exception", "", "writeLocations", "originLocations", "", "Lorg/gradle/api/problems/ProblemLocation;", "contextualLocations", "writeFileLocation", "location", "Lorg/gradle/api/problems/FileLocation;", "writeSolutions", "solutions", "problems"})
@SourceDebugExtension(value={"SMAP\nDefaultProblemsReportCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultProblemsReportCreator.kt\norg/gradle/problems/internal/impl/JsonProblemWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1642#2,10:225\n1915#2:235\n1916#2:237\n1652#2:238\n777#2:239\n873#2,2:240\n1#3:236\n*S KotlinDebug\n*F\n+ 1 DefaultProblemsReportCreator.kt\norg/gradle/problems/internal/impl/JsonProblemWriter\n*L\n181#1:225,10\n181#1:235\n181#1:237\n181#1:238\n182#1:239\n182#1:240,2\n181#1:236\n*E\n"})
public final class JsonProblemWriter
implements JsonSource {
    @NotNull
    private final InternalProblem problem;
    @NotNull
    private final FailureDecorator failureDecorator;
    @NotNull
    private final FailureFactory failureFactory;

    public JsonProblemWriter(@NotNull InternalProblem problem, @NotNull FailureDecorator failureDecorator, @NotNull FailureFactory failureFactory) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)failureDecorator, (String)"failureDecorator");
        Intrinsics.checkNotNullParameter((Object)failureFactory, (String)"failureFactory");
        this.problem = problem;
        this.failureDecorator = failureDecorator;
        this.failureFactory = failureFactory;
    }

    public void writeToJson(@NotNull JsonWriter jsonWriter) {
        Intrinsics.checkNotNullParameter((Object)jsonWriter, (String)"jsonWriter");
        JsonWriter $this$writeToJson_u24lambda_u240 = jsonWriter;
        boolean bl = false;
        $this$writeToJson_u24lambda_u240.jsonObject(() -> JsonProblemWriter.writeToJson$lambda$0$0($this$writeToJson_u24lambda_u240, this));
    }

    private final void writeSeverity(JsonWriter $this$writeSeverity, Severity severity) {
        String string = severity.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        $this$writeSeverity.property("severity", string2);
    }

    private final void writeContextualLabel(JsonWriter $this$writeContextualLabel, String contextualLabel) {
        if (contextualLabel != null) {
            $this$writeContextualLabel.property("contextualLabel", contextualLabel);
        }
    }

    private final void writeDetails(JsonWriter $this$writeDetails, String details) {
        if (details != null) {
            $this$writeDetails.property("problemDetails", details);
        }
    }

    private final void writeDocumentationLink(JsonWriter $this$writeDocumentationLink, DocLink docLink) {
        if (docLink != null) {
            String string = docLink.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            $this$writeDocumentationLink.property("documentationLink", string);
        }
    }

    private final void writeException(JsonWriter $this$writeException, Throwable exception) {
        if (exception != null) {
            Failure failure = this.failureFactory.create(exception);
            Intrinsics.checkNotNullExpressionValue((Object)failure, (String)"create(...)");
            DecoratedReportProblemKt.writeError((JsonWriter)$this$writeException, (DecoratedFailure)this.failureDecorator.decorate(failure));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeLocations(JsonWriter $this$writeLocations, List<? extends ProblemLocation> originLocations, List<? extends ProblemLocation> contextualLocations) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable iterable = CollectionsKt.plus((Collection)originLocations, (Iterable)contextualLocations);
        boolean $i$f$mapNotNull = false;
        void var7_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProblemLocation it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ProblemLocation location = (ProblemLocation)element$iv$iv;
            boolean bl2 = false;
            if ((location instanceof StackTraceLocation ? (ProblemLocation)((StackTraceLocation)location).getFileLocation() : location) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProblemLocation it = (ProblemLocation)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof FileLocation || it instanceof PluginIdLocation || it instanceof TaskLocation)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List locations = (List)destination$iv$iv;
        if (!((Collection)locations).isEmpty()) {
            $this$writeLocations.property("locations", () -> JsonProblemWriter.writeLocations$lambda$2($this$writeLocations, locations, this));
        }
    }

    private final void writeFileLocation(JsonWriter $this$writeFileLocation, FileLocation location) {
        String string = location.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        $this$writeFileLocation.property("path", string);
        if (location instanceof LineInFileLocation) {
            if (((LineInFileLocation)location).getLine() >= 0) {
                $this$writeFileLocation.property("line", ((LineInFileLocation)location).getLine());
            }
            if (((LineInFileLocation)location).getColumn() >= 0) {
                $this$writeFileLocation.property("column", ((LineInFileLocation)location).getColumn());
            }
            if (((LineInFileLocation)location).getLength() >= 0) {
                $this$writeFileLocation.property("length", ((LineInFileLocation)location).getLength());
            }
        }
    }

    private final void writeSolutions(JsonWriter $this$writeSolutions, List<String> solutions) {
        if (!((Collection)solutions).isEmpty()) {
            $this$writeSolutions.property("solutions", () -> JsonProblemWriter.writeSolutions$lambda$0($this$writeSolutions, solutions));
        }
    }

    private static final Unit writeToJson$lambda$0$0(JsonWriter $this_with, JsonProblemWriter this$0) {
        ProblemId problemId = this$0.problem.getDefinition().getId();
        Intrinsics.checkNotNullExpressionValue((Object)problemId, (String)"getId(...)");
        DefaultProblemsReportCreatorKt.access$writeProblemId($this_with, problemId);
        Severity severity = this$0.problem.getDefinition().getSeverity();
        Intrinsics.checkNotNullExpressionValue((Object)severity, (String)"getSeverity(...)");
        this$0.writeSeverity($this_with, severity);
        this$0.writeContextualLabel($this_with, this$0.problem.getContextualLabel());
        this$0.writeDetails($this_with, this$0.problem.getDetails());
        this$0.writeDocumentationLink($this_with, this$0.problem.getDefinition().getDocumentationLink());
        this$0.writeException($this_with, this$0.problem.getException());
        List list = this$0.problem.getOriginLocations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOriginLocations(...)");
        List list2 = this$0.problem.getContextualLocations();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContextualLocations(...)");
        this$0.writeLocations($this_with, list, list2);
        List list3 = this$0.problem.getSolutions();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getSolutions(...)");
        this$0.writeSolutions($this_with, list3);
        return Unit.INSTANCE;
    }

    private static final Unit writeLocations$lambda$2$0(JsonProblemWriter this$0, JsonWriter $this_writeLocations, ProblemLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        ProblemLocation problemLocation = location;
        if (problemLocation instanceof FileLocation) {
            this$0.writeFileLocation($this_writeLocations, (FileLocation)location);
        } else if (problemLocation instanceof PluginIdLocation) {
            String string = ((PluginIdLocation)location).getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPluginId(...)");
            $this_writeLocations.property("pluginId", string);
        } else if (problemLocation instanceof TaskLocation) {
            String string = ((TaskLocation)location).getBuildTreePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBuildTreePath(...)");
            $this_writeLocations.property("taskPath", string);
        }
        return Unit.INSTANCE;
    }

    private static final Unit writeLocations$lambda$2(JsonWriter $this_writeLocations, List $locations, JsonProblemWriter this$0) {
        $this_writeLocations.jsonObjectList((Iterable)$locations, arg_0 -> JsonProblemWriter.writeLocations$lambda$2$0(this$0, $this_writeLocations, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit writeSolutions$lambda$0(JsonWriter $this_writeSolutions, List $solutions) {
        $this_writeSolutions.jsonList($solutions);
        return Unit.INSTANCE;
    }
}

