/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.NamedDomainObjectSet;
import org.gradle.api.Namer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.MutationGuard;
import org.gradle.api.internal.MutationGuards;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.SortedSetElementSource;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;

public class DefaultNamedDomainObjectSet<T>
extends DefaultNamedDomainObjectCollection<T>
implements NamedDomainObjectSet<T> {
    private final MutationGuard parentMutationGuard;

    public DefaultNamedDomainObjectSet(Class<? extends T> type, Instantiator instantiator, Namer<? super T> namer, CollectionCallbackActionDecorator decorator) {
        super(type, new SortedSetElementSource(new Namer.Comparator(namer)), instantiator, namer, decorator);
        this.parentMutationGuard = MutationGuards.identity();
    }

    public DefaultNamedDomainObjectSet(Class<? extends T> type, Instantiator instantiator, CollectionCallbackActionDecorator decorator) {
        this(type, instantiator, Named.Namer.forType(type), decorator);
    }

    public DefaultNamedDomainObjectSet(DefaultNamedDomainObjectSet<? super T> collection, CollectionFilter<T> filter, Instantiator instantiator, Namer<? super T> namer) {
        this(collection, filter, instantiator, namer, MutationGuards.identity());
    }

    public DefaultNamedDomainObjectSet(DefaultNamedDomainObjectSet<? super T> objects, Spec<String> nameFilter, CollectionFilter<T> elementFilter, Instantiator instantiator, Namer<? super T> namer) {
        this(objects, nameFilter, elementFilter, instantiator, namer, MutationGuards.identity());
    }

    public DefaultNamedDomainObjectSet(DefaultNamedDomainObjectSet<? super T> collection, CollectionFilter<T> filter, Instantiator instantiator, Namer<? super T> namer, MutationGuard parentMutationGuard) {
        this(collection, (Spec<String>)Specs.satisfyAll(), filter, instantiator, namer, parentMutationGuard);
    }

    public DefaultNamedDomainObjectSet(DefaultNamedDomainObjectSet<? super T> collection, Spec<String> nameFilter, CollectionFilter<T> elementFilter, Instantiator instantiator, Namer<? super T> namer, MutationGuard parentMutationGuard) {
        super(collection, nameFilter, elementFilter, instantiator, namer);
        this.parentMutationGuard = parentMutationGuard;
    }

    @Override
    protected <S extends T> DefaultNamedDomainObjectSet<S> filtered(CollectionFilter<S> elementFilter) {
        return (DefaultNamedDomainObjectSet)Cast.uncheckedNonnullCast((Object)this.getInstantiator().newInstance(DefaultNamedDomainObjectSet.class, new Object[]{this, elementFilter, this.getInstantiator(), this.getNamer()}));
    }

    @Override
    protected <S extends T> DefaultNamedDomainObjectSet<S> filtered(Spec<String> nameFilter, CollectionFilter<S> elementFilter) {
        return (DefaultNamedDomainObjectSet)Cast.uncheckedNonnullCast((Object)this.getInstantiator().newInstance(DefaultNamedDomainObjectSet.class, new Object[]{this, nameFilter, elementFilter, this.getInstantiator(), this.getNamer()}));
    }

    @Override
    public String getDisplayName() {
        return this.getTypeDisplayName() + " set";
    }

    @Override
    public <S extends T> NamedDomainObjectSet<S> withType(Class<S> type) {
        return this.filtered((CollectionFilter)this.createFilter(type));
    }

    @Override
    public NamedDomainObjectSet<T> named(Spec<String> nameFilter) {
        Spec spec = this.convertNameToElementFilter(nameFilter);
        return this.filtered((Spec)nameFilter, this.createFilter(spec));
    }

    @Override
    public NamedDomainObjectSet<T> matching(Spec<? super T> spec) {
        return this.filtered(this.createFilter(spec));
    }

    @Override
    public NamedDomainObjectSet<T> matching(Closure spec) {
        return this.matching((Spec<? super T>)Specs.convertClosureToSpec((Closure)spec));
    }

    @Override
    @Deprecated
    public Set<T> findAll(Closure cl) {
        return this.findAll(cl, new LinkedHashSet());
    }

    @Override
    protected <I extends T> Action<? super I> wrapLazyAction(Action<? super I> action) {
        return this.parentMutationGuard.wrapLazyAction(super.wrapLazyAction(action));
    }
}

