/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.internal.cache.MonitoredCleanupAction;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.util.internal.DefaultGradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaemonLogCleanupAction
implements MonitoredCleanupAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaemonLogCleanupAction.class);
    static final long DEFAULT_RETENTION_DAYS = 14L;
    private final File daemonBaseDir;
    private final Deleter deleter;
    private final Supplier<Long> timeInMillis;

    public DaemonLogCleanupAction(File daemonBaseDir, Deleter deleter, Supplier<Long> timeInMillis) {
        this.daemonBaseDir = daemonBaseDir;
        this.deleter = deleter;
        this.timeInMillis = timeInMillis;
    }

    public String getDisplayName() {
        return "Deleting old daemon log files in " + this.daemonBaseDir;
    }

    public boolean execute(CleanupProgressMonitor progressMonitor) {
        Timer timer = Time.startTimer();
        this.performCleanup(progressMonitor);
        LOGGER.debug("Processed daemon logs at {} for cleanup in {}", (Object)this.daemonBaseDir, (Object)timer.getElapsed());
        return true;
    }

    private void performCleanup(CleanupProgressMonitor progressMonitor) {
        long maxAge = this.timeInMillis.get();
        File[] daemonLogDirectories = this.daemonBaseDir.listFiles(file -> file.isDirectory() && DefaultGradleVersion.VERSION_PATTERN.matcher(file.getName()).matches());
        if (daemonLogDirectories == null) {
            LOGGER.debug("Daemon log root directory not found: {}", (Object)this.daemonBaseDir.getAbsolutePath());
            return;
        }
        for (File daemonLogDirectory : daemonLogDirectories) {
            this.cleanupLogsInDirectory(daemonLogDirectory, maxAge, progressMonitor);
        }
    }

    private void cleanupLogsInDirectory(File daemonLogDirectory, long maxAge, CleanupProgressMonitor progressMonitor) {
        File[] logFiles = daemonLogDirectory.listFiles(f -> f.isFile() && f.getName().endsWith(".out.log") && f.getName().startsWith("daemon-"));
        if (logFiles == null) {
            LOGGER.debug("Version specific daemon log directory not found: {}", (Object)daemonLogDirectory.getAbsolutePath());
            return;
        }
        for (File logFile : logFiles) {
            if (logFile.lastModified() < maxAge) {
                try {
                    LOGGER.debug("Deleting old daemon log file: {}", (Object)logFile);
                    this.deleter.delete(logFile);
                    progressMonitor.incrementDeleted();
                }
                catch (IOException e) {
                    LOGGER.warn("Could not delete old daemon log file: {}", (Object)logFile.getAbsolutePath(), (Object)e);
                    progressMonitor.incrementSkipped();
                }
                continue;
            }
            progressMonitor.incrementSkipped();
        }
    }
}

