/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.Definition;
import org.gradle.api.internal.plugins.ProjectFeatureApplyAction;
import org.gradle.api.internal.plugins.ProjectFeatureBindingDeclaration;
import org.gradle.api.internal.plugins.TargetTypeInformation;
import org.gradle.plugin.software.internal.ModelDefault;
import org.gradle.plugin.software.internal.ProjectFeatureImplementation;
import org.jspecify.annotations.Nullable;

public class DefaultProjectFeatureImplementation<T extends Definition<V>, V extends BuildModel>
implements ProjectFeatureImplementation<T, V> {
    private final String featureName;
    private final Class<T> definitionPublicType;
    private final Class<? extends T> definitionImplementationType;
    private final ProjectFeatureBindingDeclaration.Safety definitionSafety;
    private final TargetTypeInformation<?> targetDefinitionType;
    private final Class<V> buildModelType;
    private final Class<? extends V> buildModelImplementationType;
    private final Class<? extends Plugin<Project>> pluginClass;
    private final Class<? extends Plugin<Settings>> registeringPluginClass;
    private final List<ModelDefault<?>> defaults = new ArrayList();
    private final @Nullable String registeringPluginId;
    private final ProjectFeatureApplyAction<T, V, ?> bindingTransform;

    public DefaultProjectFeatureImplementation(String featureName, Class<T> definitionPublicType, Class<? extends T> definitionImplementationType, ProjectFeatureBindingDeclaration.Safety definitionSafety, TargetTypeInformation<?> targetDefinitionType, Class<V> buildModelType, Class<? extends V> buildModelImplementationType, Class<? extends Plugin<Project>> pluginClass, Class<? extends Plugin<Settings>> registeringPluginClass, @Nullable String registeringPluginId, ProjectFeatureApplyAction<T, V, ?> bindingTransform) {
        this.featureName = featureName;
        this.definitionPublicType = definitionPublicType;
        this.definitionImplementationType = definitionImplementationType;
        this.definitionSafety = definitionSafety;
        this.targetDefinitionType = targetDefinitionType;
        this.buildModelType = buildModelType;
        this.buildModelImplementationType = buildModelImplementationType;
        this.pluginClass = pluginClass;
        this.registeringPluginClass = registeringPluginClass;
        this.registeringPluginId = registeringPluginId;
        this.bindingTransform = bindingTransform;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public Class<T> getDefinitionPublicType() {
        return this.definitionPublicType;
    }

    public Class<? extends T> getDefinitionImplementationType() {
        return this.definitionImplementationType;
    }

    public ProjectFeatureBindingDeclaration.Safety getDefinitionSafety() {
        return this.definitionSafety;
    }

    public Class<V> getBuildModelType() {
        return this.buildModelType;
    }

    public Class<? extends V> getBuildModelImplementationType() {
        return this.buildModelImplementationType;
    }

    public TargetTypeInformation<?> getTargetDefinitionType() {
        return this.targetDefinitionType;
    }

    public Class<? extends Plugin<Project>> getPluginClass() {
        return this.pluginClass;
    }

    public Class<? extends Plugin<Settings>> getRegisteringPluginClass() {
        return this.registeringPluginClass;
    }

    public @Nullable String getRegisteringPluginId() {
        return this.registeringPluginId;
    }

    public ProjectFeatureApplyAction<T, V, ?> getBindingTransform() {
        return this.bindingTransform;
    }

    public void addModelDefault(ModelDefault<?> modelDefault) {
        this.defaults.add(modelDefault);
    }

    public <M extends ModelDefault.Visitor<?>> void visitModelDefaults(Class<? extends ModelDefault<M>> type, M visitor) {
        this.defaults.stream().filter(type::isInstance).map(type::cast).forEach(modelDefault -> modelDefault.visit(visitor));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectFeatureImplementation that = (DefaultProjectFeatureImplementation)o;
        return Objects.equals(this.featureName, that.featureName) && Objects.equals(this.definitionPublicType, that.definitionPublicType) && Objects.equals(this.pluginClass, that.pluginClass);
    }

    public int hashCode() {
        return Objects.hash(this.featureName, this.definitionPublicType, this.pluginClass);
    }
}

