/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.toolchain;

import java.net.URI;
import java.util.Collection;
import java.util.Optional;
import org.gradle.authentication.Authentication;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.resource.ExternalResourceFactory;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.local.FileResourceConnector;
import org.gradle.internal.resource.local.FileResourceListener;
import org.gradle.internal.resource.transfer.DefaultExternalResourceRepository;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transport.http.DefaultHttpSettings;
import org.gradle.internal.resource.transport.http.DefaultSslContextFactory;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.gradle.internal.time.Clock;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainHttpRedirectVerifierFactory;
import org.gradle.launcher.daemon.toolchain.ToolchainDownloadProgressListener;
import org.gradle.launcher.daemon.toolchain.ToolchainExternalResourceAccessor;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;

public class DaemonToolchainExternalResourceFactory
implements ExternalResourceFactory {
    private final FileSystem fileSystem;
    private final JavaToolchainHttpRedirectVerifierFactory httpRedirectVerifierFactory;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final HttpClientHelper.Factory httpClientHelperFactory;
    private final BuildOperationIdFactory operationIdFactory;
    private final Optional<InternalBuildProgressListener> buildProgressListener;
    private final Clock clock;

    public DaemonToolchainExternalResourceFactory(FileSystem fileSystem, JavaToolchainHttpRedirectVerifierFactory httpRedirectVerifierFactory, HttpClientHelper.Factory httpClientHelperFactory, ProgressLoggerFactory progressLoggerFactory, Clock clock, BuildOperationIdFactory operationIdFactory, Optional<InternalBuildProgressListener> buildProgressListener) {
        this.fileSystem = fileSystem;
        this.httpRedirectVerifierFactory = httpRedirectVerifierFactory;
        this.progressLoggerFactory = progressLoggerFactory;
        this.httpClientHelperFactory = httpClientHelperFactory;
        this.clock = clock;
        this.operationIdFactory = operationIdFactory;
        this.buildProgressListener = buildProgressListener;
    }

    public ExternalResourceRepository createExternalResource(URI source, Collection<Authentication> authentications) {
        if ("file".equals(source.getScheme())) {
            return new FileResourceConnector(this.fileSystem, FileResourceListener.NO_OP);
        }
        HttpClientHelper httpClientHelper = this.httpClientHelperFactory.create(DefaultHttpSettings.builder().withAuthenticationSettings(authentications).withSslContextFactory((SslContextFactory)new DefaultSslContextFactory()).withRedirectVerifier(this.httpRedirectVerifierFactory.createVerifier(source)).build());
        ToolchainDownloadProgressListener toolchainDownloadProgressListener = new ToolchainDownloadProgressListener(this.progressLoggerFactory, this.buildProgressListener, this.operationIdFactory);
        ToolchainExternalResourceAccessor toolchainExternalResourceAccessor = new ToolchainExternalResourceAccessor(httpClientHelper, this.clock, toolchainDownloadProgressListener);
        return new DefaultExternalResourceRepository("jdk toolchains", (ExternalResourceAccessor)toolchainExternalResourceAccessor, null, null);
    }
}

