/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.SubstitutionResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformDependencyMetadata;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.LenientPlatformGraphResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.RootNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.VirtualPlatformState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.strict.StrictVersionConstraints;
import org.gradle.api.internal.capabilities.ImmutableCapability;
import org.gradle.api.internal.capabilities.ShadowedCapability;
import org.gradle.internal.Try;
import org.gradle.internal.collect.PersistentSet;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.VirtualComponentIdentifier;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphSpecificResolveState;
import org.gradle.internal.component.model.DelegatingDependencyMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantIdentifier;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeState
implements DependencyGraphNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeState.class);
    private final long nodeId;
    private final ComponentState component;
    private final List<EdgeState> incomingEdges = new ArrayList<EdgeState>();
    private final List<EdgeState> outgoingEdges = new ArrayList<EdgeState>();
    private final VariantGraphResolveState variantState;
    private final VariantGraphResolveMetadata metadata;
    private final ResolveState resolveState;
    private final ModuleExclusions moduleExclusions;
    private final boolean isTransitive;
    private final boolean selectedByVariantAwareResolution;
    private final boolean dependenciesMayChange;
    @Nullable ExcludeSpec previousTraversalExclusions;
    private boolean queued;
    private @Nullable NodeState replacement;
    private int transitiveEdgeCount;
    private @Nullable Set<ModuleIdentifier> upcomingNoLongerPendingConstraints;
    private boolean virtualPlatformNeedsRefresh;
    private @Nullable Set<EdgeState> edgesToRecompute;
    private @Nullable Multimap<ModuleIdentifier, EdgeState> potentiallyActivatedConstraints;
    private @Nullable List<EdgeState> cachedEdges;
    private @Nullable List<EdgeState> cachedFilteredEdges;
    private @Nullable ExcludeSpec cachedNodeExclusions;
    private int previousIncomingEdgeCount;
    private long previousIncomingHash;
    private long incomingHash;
    private @Nullable ExcludeSpec cachedModuleResolutionFilter;
    private boolean visitedDependencies = false;
    private @Nullable StrictVersionConstraints previousAncestorsStrictVersions;
    @VisibleForTesting
    StrictVersionConstraints ancestorsStrictVersions = StrictVersionConstraints.EMPTY;
    @VisibleForTesting
    @Nullable StrictVersionConstraints ownStrictVersions;
    private @Nullable StrictVersionConstraints cachedEndorsedStrictVersions;
    private boolean findingExternalVariants;

    public NodeState(long nodeId, ComponentState component, ResolveState resolveState, VariantGraphResolveState variant, boolean selectedByVariantAwareResolution) {
        this.nodeId = nodeId;
        this.component = component;
        this.resolveState = resolveState;
        this.variantState = variant;
        this.metadata = variant.getMetadata();
        this.isTransitive = this.metadata.isTransitive() || this.metadata.isExternalVariant();
        this.selectedByVariantAwareResolution = selectedByVariantAwareResolution;
        this.moduleExclusions = resolveState.getModuleExclusions();
        this.dependenciesMayChange = component.getModule().isVirtualPlatform();
    }

    boolean enqueue() {
        if (this.queued) {
            return false;
        }
        this.queued = true;
        return true;
    }

    NodeState dequeue() {
        this.queued = false;
        return this;
    }

    @Override
    public ComponentState getComponent() {
        return this.component;
    }

    @Override
    public long getNodeId() {
        return this.nodeId;
    }

    @Override
    public VariantIdentifier getId() {
        return this.variantState.getMetadata().getId();
    }

    @Override
    public ComponentGraphResolveState getComponentResolveState() {
        return this.getComponent().getResolveState();
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    @Override
    public ComponentState getOwner() {
        return this.component;
    }

    public List<EdgeState> getIncomingEdges() {
        return this.incomingEdges;
    }

    public List<EdgeState> getOutgoingEdges() {
        return this.outgoingEdges;
    }

    @Override
    public VariantGraphResolveMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public VariantGraphResolveState getResolveState() {
        return this.variantState;
    }

    @Override
    public Set<? extends LocalFileDependencyMetadata> getOutgoingFileEdges() {
        if (this.variantState instanceof LocalVariantGraphResolveState) {
            return ((LocalVariantGraphResolveState)this.variantState).getFiles();
        }
        return Collections.emptySet();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return String.format("'%s' (%s)", this.component.getComponentId().getDisplayName(), this.metadata.getDisplayName());
    }

    public boolean isTransitive() {
        return this.isTransitive;
    }

    void visitOutgoingDependenciesAndCollectEdges(Collection<EdgeState> discoveredEdges) {
        ExcludeSpec resolutionFilter = this.computeModuleResolutionFilter(this.incomingEdges);
        StrictVersionConstraints ancestorsStrictVersions = this.ancestorsStrictVersions;
        this.doVisitDependencies(resolutionFilter, ancestorsStrictVersions, discoveredEdges);
        assert (this.previousTraversalExclusions == null == (this.previousAncestorsStrictVersions == null));
        this.previousTraversalExclusions = resolutionFilter;
        this.previousAncestorsStrictVersions = ancestorsStrictVersions;
    }

    private void doVisitDependencies(ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges) {
        if (this.transitiveEdgeCount == 0 && !this.isRoot() && this.canIgnoreExternalVariant()) {
            assert (!this.incomingEdges.isEmpty());
            this.removeOutgoingEdges();
            if (this.ownStrictVersions == null) {
                this.collectOwnStrictVersions(resolutionFilter);
            }
            this.visitOwners(resolutionFilter, ancestorsStrictVersions, discoveredEdges);
            return;
        }
        boolean sameExcludes = resolutionFilter.equals(this.previousTraversalExclusions);
        if (this.visitedDependencies && !this.virtualPlatformNeedsRefresh && (sameExcludes || this.computeFilteredEdges(resolutionFilter).equals(this.cachedFilteredEdges))) {
            if (!sameExcludes) {
                for (EdgeState outgoingEdge : this.outgoingEdges) {
                    outgoingEdge.updateTransitiveExcludesAndRequeueTargetNodes(resolutionFilter);
                }
            }
            if (!ancestorsStrictVersions.equals(this.previousAncestorsStrictVersions)) {
                for (EdgeState outgoingEdge : this.outgoingEdges) {
                    outgoingEdge.recomputeSelectorAndRequeueTargetNodes(ancestorsStrictVersions, discoveredEdges);
                }
            }
            this.visitNewAndInvalidatedDependencies(resolutionFilter, ancestorsStrictVersions, discoveredEdges);
            return;
        }
        assert (!this.visitedDependencies || this.previousTraversalExclusions != null);
        this.removeOutgoingEdges();
        this.visitDependencies(resolutionFilter, ancestorsStrictVersions, discoveredEdges);
        this.visitOwners(resolutionFilter, ancestorsStrictVersions, discoveredEdges);
    }

    private void visitNewAndInvalidatedDependencies(ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges) {
        if (this.upcomingNoLongerPendingConstraints != null && this.potentiallyActivatedConstraints != null) {
            for (ModuleIdentifier moduleId : this.upcomingNoLongerPendingConstraints) {
                Collection edges = this.potentiallyActivatedConstraints.get((Object)moduleId);
                if (edges.isEmpty()) continue;
                ModuleResolveState module = this.resolveState.getModule(moduleId);
                if (module.isPending()) {
                    module.getPendingDependencies().registerConstraintProvider(this);
                    continue;
                }
                for (EdgeState edge : edges) {
                    this.doLinkOutgoingEdge(edge, discoveredEdges, resolutionFilter, ancestorsStrictVersions, module, false);
                }
            }
            this.upcomingNoLongerPendingConstraints = null;
        }
        if (this.edgesToRecompute != null) {
            discoveredEdges.addAll(this.edgesToRecompute);
            this.edgesToRecompute = null;
        }
    }

    private boolean canIgnoreExternalVariant() {
        if (!this.metadata.isExternalVariant()) {
            return true;
        }
        for (EdgeState incomingEdge : this.incomingEdges) {
            if (incomingEdge.isArtifactOnlyEdge()) continue;
            return false;
        }
        return true;
    }

    private void cleanupConstraints() {
        if (this.upcomingNoLongerPendingConstraints != null) {
            for (ModuleIdentifier identifier : this.upcomingNoLongerPendingConstraints) {
                ModuleResolveState module = this.resolveState.getModule(identifier);
                for (EdgeState unattachedEdge : module.getUnattachedEdges()) {
                    if (unattachedEdge.getSelector().isResolved()) continue;
                    NodeState from = unattachedEdge.getFrom();
                    from.prepareToRecomputeEdge(unattachedEdge);
                }
            }
            this.upcomingNoLongerPendingConstraints = null;
        }
        if (this.cachedFilteredEdges != null && !this.cachedFilteredEdges.isEmpty()) {
            for (EdgeState edge : this.cachedFilteredEdges) {
                ModuleResolveState targetModule;
                if (!edge.getDependencyMetadata().isConstraint() || !(targetModule = this.resolveState.getModule(edge.getDependencyState().getModuleIdentifier(this.resolveState.getComponentSelectorConverter()))).isPending()) continue;
                targetModule.unregisterConstraintProvider(this);
            }
        }
    }

    void prepareToRecomputeEdge(EdgeState edgeToRecompute) {
        if (this.edgesToRecompute == null) {
            this.edgesToRecompute = new LinkedHashSet<EdgeState>();
        }
        this.edgesToRecompute.add(edgeToRecompute);
        this.resolveState.onMoreSelected(this);
    }

    private void visitDependencies(ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges) {
        this.potentiallyActivatedConstraints = null;
        this.upcomingNoLongerPendingConstraints = null;
        PersistentSet<ModuleIdentifier> strictVersionsSet = PersistentSet.of();
        for (EdgeState edge : this.edges(resolutionFilter)) {
            this.registerOutgoingEdge(resolutionFilter, ancestorsStrictVersions, discoveredEdges, edge);
            strictVersionsSet = NodeState.maybeCollectStrictVersions(strictVersionsSet, edge.getDependencyMetadata().getSelector());
        }
        this.storeOwnStrictVersions(strictVersionsSet);
        this.visitedDependencies = true;
    }

    private void registerOutgoingEdge(ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges, EdgeState dependencyEdge) {
        boolean constraint = dependencyEdge.getDependencyMetadata().isConstraint();
        ModuleIdentifier moduleId = dependencyEdge.getDependencyState().getModuleIdentifier(this.resolveState.getComponentSelectorConverter());
        ModuleResolveState module = this.resolveState.getModule(moduleId);
        boolean deferSelection = false;
        if (constraint) {
            this.registerActivatingConstraint(dependencyEdge, moduleId);
        } else {
            deferSelection = module.getPendingDependencies().addIncomingHardEdge();
        }
        if (constraint && module.isPending()) {
            module.registerConstraintProvider(this);
        } else {
            this.doLinkOutgoingEdge(dependencyEdge, discoveredEdges, resolutionFilter, ancestorsStrictVersions, module, deferSelection);
        }
    }

    private void registerActivatingConstraint(EdgeState edge, ModuleIdentifier targetModuleId) {
        if (this.potentiallyActivatedConstraints == null) {
            this.potentiallyActivatedConstraints = LinkedHashMultimap.create();
        }
        this.potentiallyActivatedConstraints.put((Object)targetModuleId, (Object)edge);
    }

    private List<EdgeState> edges() {
        if (this.dependenciesMayChange || this.cachedEdges == null) {
            List<? extends DependencyMetadata> dependencies = this.getAllDependencies();
            if (this.transitiveEdgeCount == 0 && this.metadata.isExternalVariant()) {
                assert (dependencies.size() == 1);
                dependencies = Collections.singletonList(NodeState.makeNonTransitive(dependencies.get(0)));
            }
            this.cachedEdges = this.cacheEdges(dependencies);
        }
        return this.cachedEdges;
    }

    protected List<? extends DependencyMetadata> getAllDependencies() {
        return this.variantState.getDependencies();
    }

    private static DependencyMetadata makeNonTransitive(DependencyMetadata dependencyMetadata) {
        return new NonTransitiveVariantDependencyMetadata(dependencyMetadata);
    }

    private List<EdgeState> edges(ExcludeSpec spec) {
        if (this.dependenciesMayChange || this.cachedFilteredEdges == null) {
            this.cachedFilteredEdges = this.computeFilteredEdges(spec);
        }
        return this.cachedFilteredEdges;
    }

    private List<EdgeState> computeFilteredEdges(ExcludeSpec spec) {
        List<EdgeState> from = this.edges();
        if (from.isEmpty()) {
            return from;
        }
        ArrayList<EdgeState> tmp = new ArrayList<EdgeState>(from.size());
        for (EdgeState edge : from) {
            if (this.isExcluded(spec, edge)) continue;
            tmp.add(edge);
        }
        return tmp;
    }

    private List<EdgeState> cacheEdges(List<? extends DependencyMetadata> dependencies) {
        if (dependencies.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EdgeState> result = new ArrayList<EdgeState>(dependencies.size());
        for (DependencyMetadata dependencyMetadata : dependencies) {
            result.add(this.createEdge(dependencyMetadata));
        }
        return result;
    }

    private EdgeState createEdge(DependencyMetadata dependency) {
        Try<SubstitutionResult> trySubstitution = this.resolveState.getDependencySubstitutionApplicator().applySubstitutions(dependency.getSelector(), (ImmutableList<IvyArtifactName>)ImmutableList.copyOf(dependency.getArtifacts()));
        if (!trySubstitution.isSuccessful()) {
            ModuleVersionResolveException resolveFailure = new ModuleVersionResolveException(dependency.getSelector(), (Throwable)trySubstitution.getFailure().get());
            return new EdgeState(this, dependency, dependency.getSelector(), (ImmutableList<ComponentSelectionDescriptorInternal>)ImmutableList.of(), resolveFailure, this.resolveState);
        }
        SubstitutionResult substitution = (SubstitutionResult)trySubstitution.get();
        DependencyMetadata updatedMetadata = NodeState.metadataWithSubstitution(dependency, substitution);
        return new EdgeState(this, updatedMetadata, dependency.getSelector(), substitution.getRuleDescriptors(), null, this.resolveState);
    }

    private static DependencyMetadata metadataWithSubstitution(DependencyMetadata dependency, SubstitutionResult substitution) {
        ComponentSelector target = substitution.getTarget();
        ImmutableList<IvyArtifactName> artifacts = substitution.getArtifacts();
        if (target == null && artifacts == null) {
            return dependency;
        }
        ComponentSelector actualTarget = target != null ? target : dependency.getSelector();
        return artifacts == null ? dependency.withTarget(actualTarget) : dependency.withTargetAndArtifacts(actualTarget, (List<IvyArtifactName>)artifacts);
    }

    private void doLinkOutgoingEdge(EdgeState dependencyEdge, Collection<EdgeState> discoveredEdges, ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, ModuleResolveState module, boolean deferSelection) {
        dependencyEdge.updateTransitiveExcludes(resolutionFilter);
        dependencyEdge.computeSelector(ancestorsStrictVersions, deferSelection);
        module.addUnattachedEdge(dependencyEdge);
        discoveredEdges.add(dependencyEdge);
        this.outgoingEdges.add(dependencyEdge);
    }

    private void visitOwners(ExcludeSpec resolutionFilter, StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges) {
        List<? extends VirtualComponentIdentifier> owners = this.component.getMetadata().getPlatformOwners();
        if (!owners.isEmpty()) {
            for (VirtualComponentIdentifier virtualComponentIdentifier : owners) {
                if (!(virtualComponentIdentifier instanceof ModuleComponentIdentifier)) continue;
                ModuleComponentIdentifier platformId = (ModuleComponentIdentifier)virtualComponentIdentifier;
                this.resolvePlatform(platformId);
                boolean forced = this.hasStrongOpinion();
                ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(platformId.getModuleIdentifier(), platformId.getVersion());
                LenientPlatformDependencyMetadata dependencyMetadata = new LenientPlatformDependencyMetadata(this.resolveState, this, selector, platformId, (ComponentIdentifier)platformId, forced, true, false);
                EdgeState virtualPlatformEdge = this.createEdge(dependencyMetadata);
                this.registerOutgoingEdge(resolutionFilter, ancestorsStrictVersions, discoveredEdges, virtualPlatformEdge);
            }
        }
    }

    private void resolvePlatform(ModuleComponentIdentifier componentId) {
        ModuleVersionIdentifier toModuleVersionId = DefaultModuleVersionIdentifier.newId(componentId.getModuleIdentifier(), componentId.getVersion());
        ComponentState componentState = this.resolveState.getModule(componentId.getModuleIdentifier()).getVersion(toModuleVersionId, (ComponentIdentifier)componentId);
        ComponentGraphResolveState resolvedComponent = componentState.getResolveStateOrNull();
        VirtualPlatformState virtualPlatformState = null;
        if (resolvedComponent == null || resolvedComponent instanceof LenientPlatformGraphResolveState) {
            virtualPlatformState = componentState.getModule().getPlatformState();
            virtualPlatformState.participatingModule(this.component.getModule());
        }
        if (resolvedComponent == null) {
            LenientPlatformGraphResolveState newLenientPlatform = LenientPlatformGraphResolveState.of(this.resolveState.getIdGenerator(), componentId, toModuleVersionId, virtualPlatformState, this, this.resolveState);
            componentState.setState(newLenientPlatform, ComponentGraphSpecificResolveState.EMPTY_STATE);
            componentState.getModule().maybeCreateVirtualMetadata(this.resolveState);
        }
    }

    private boolean hasStrongOpinion() {
        for (EdgeState edgeState : this.incomingEdges) {
            if (!edgeState.getSelector().hasStrongOpinion()) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(ExcludeSpec excludeSpec, EdgeState edgeState) {
        DependencyMetadata dependency = edgeState.getDependencyMetadata();
        if (!this.resolveState.getEdgeFilter().isSatisfiedBy((Object)dependency)) {
            LOGGER.debug("{} is filtered.", (Object)dependency);
            return true;
        }
        if (excludeSpec == this.moduleExclusions.nothing()) {
            return false;
        }
        ModuleIdentifier targetModuleId = edgeState.getDependencyState().getModuleIdentifier(this.resolveState.getComponentSelectorConverter());
        if (excludeSpec.excludes(targetModuleId)) {
            LOGGER.debug("{} is excluded from {} by {}.", new Object[]{targetModuleId, this, excludeSpec});
            return true;
        }
        return false;
    }

    void addIncomingEdge(EdgeState dependencyEdge) {
        if (!this.incomingEdges.contains(dependencyEdge)) {
            this.cachedModuleResolutionFilter = null;
            this.incomingEdges.add(dependencyEdge);
            this.incomingHash += (long)dependencyEdge.hashCode();
            if (dependencyEdge.isTransitive()) {
                ++this.transitiveEdgeCount;
            }
            this.requeueChildrenOfEndorsingParent(dependencyEdge);
            if (this.incomingEdges.size() == 1) {
                this.updateAncestorsStrictVersions(this.getStrictVersionsForEdge(dependencyEdge));
            } else {
                this.updateAncestorsStrictVersions(this.ancestorsStrictVersions.intersect(this.getStrictVersionsForEdge(dependencyEdge)));
            }
            this.resolveState.onMoreSelected(this);
        }
    }

    void removeIncomingEdge(EdgeState dependencyEdge) {
        if (this.incomingEdges.remove(dependencyEdge)) {
            this.cachedModuleResolutionFilter = null;
            this.incomingHash -= (long)dependencyEdge.hashCode();
            if (dependencyEdge.isTransitive()) {
                --this.transitiveEdgeCount;
            }
            this.requeueChildrenOfEndorsingParent(dependencyEdge);
            this.recomputeAncestorsStrictVersions();
            this.resolveState.onFewerSelected(this);
        }
    }

    List<EdgeState> removeAllIncomingEdges() {
        if (this.incomingEdges.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList removedEdges = ImmutableList.copyOf(this.incomingEdges);
        this.incomingEdges.clear();
        this.cachedModuleResolutionFilter = null;
        this.incomingHash = 0L;
        this.transitiveEdgeCount = 0;
        for (EdgeState incomingEdge : removedEdges) {
            this.requeueChildrenOfEndorsingParent(incomingEdge);
        }
        this.updateAncestorsStrictVersions(StrictVersionConstraints.EMPTY);
        this.resolveState.onFewerSelected(this);
        return removedEdges;
    }

    private void requeueChildrenOfEndorsingParent(EdgeState incomingEdge) {
        if (incomingEdge.getDependencyMetadata().isEndorsingStrictVersions()) {
            NodeState sourceNode = incomingEdge.getFrom();
            sourceNode.invalidateEndorsedStrictVersions();
            for (EdgeState edge : sourceNode.getOutgoingEdges()) {
                for (NodeState node : edge.getTargetNodes()) {
                    if (node == this) continue;
                    this.resolveState.onMoreSelected(node);
                }
            }
        }
    }

    void clearTransitiveExclusionsAndEnqueue() {
        this.cachedModuleResolutionFilter = null;
        this.resolveState.onMoreSelected(this);
    }

    @Override
    public boolean isSelected() {
        return !this.incomingEdges.isEmpty();
    }

    public void replaceWith(@Nullable NodeState replacement) {
        assert (replacement == null || replacement.getComponent() == this.getComponent());
        this.replacement = replacement;
    }

    public @Nullable NodeState getReplacement() {
        return this.replacement;
    }

    boolean shouldIncludedInGraphResult() {
        return this.isSelected() && !this.component.getModule().isVirtualPlatform();
    }

    private ExcludeSpec computeModuleResolutionFilter(List<EdgeState> incomingEdges) {
        NodeState from;
        if (this.metadata.isExternalVariant()) {
            return this.moduleExclusions.excludeAny((PersistentSet<ExcludeSpec>)((PersistentSet)incomingEdges.stream().map(EdgeState::getTransitiveExclusions).filter(Objects::nonNull).collect(PersistentSet.toPersistentSet())));
        }
        if (incomingEdges.size() == 1 && (from = incomingEdges.get(0).getFrom()).getMetadata().isExternalVariant()) {
            return this.computeModuleResolutionFilter((List<EdgeState>)from.getIncomingEdges());
        }
        ExcludeSpec nodeExclusions = this.computeNodeExclusions();
        if (incomingEdges.isEmpty()) {
            return nodeExclusions;
        }
        return this.computeExclusionFilter(incomingEdges, nodeExclusions);
    }

    private ExcludeSpec computeNodeExclusions() {
        if (this.cachedNodeExclusions == null) {
            this.cachedNodeExclusions = this.moduleExclusions.excludeAny(this.variantState.getExcludes());
        }
        return this.cachedNodeExclusions;
    }

    private ExcludeSpec computeExclusionFilter(List<EdgeState> incomingEdges, ExcludeSpec nodeExclusions) {
        int incomingEdgeCount = incomingEdges.size();
        if (this.sameIncomingEdgesAsPreviousPass(incomingEdgeCount)) {
            return this.cachedModuleResolutionFilter;
        }
        if (incomingEdgeCount == 1) {
            return this.computeExclusionFilterSingleIncomingEdge(incomingEdges.get(0), nodeExclusions);
        }
        return this.computeModuleExclusionsManyEdges(incomingEdges, nodeExclusions, incomingEdgeCount);
    }

    private ExcludeSpec computeModuleExclusionsManyEdges(List<EdgeState> incomingEdges, ExcludeSpec nodeExclusions, int incomingEdgeCount) {
        ExcludeSpec nothing = this.moduleExclusions.nothing();
        ExcludeSpec edgeExclusions = null;
        PersistentSet excludedByBoth = PersistentSet.of();
        PersistentSet<ExcludeSpec> excludedByEither = PersistentSet.of();
        for (EdgeState dependencyEdge : incomingEdges) {
            if (dependencyEdge.isTransitive()) {
                if (edgeExclusions == nothing) continue;
                ExcludeSpec exclusions = dependencyEdge.getExclusions();
                if (edgeExclusions == null || exclusions == nothing) {
                    edgeExclusions = exclusions;
                } else if (edgeExclusions != exclusions) {
                    excludedByBoth = excludedByBoth.plus((Object)exclusions);
                }
                if (edgeExclusions != nothing) continue;
                excludedByBoth = PersistentSet.of();
                continue;
            }
            if (!dependencyEdge.isConstraint()) continue;
            excludedByEither = NodeState.collectEdgeConstraint(nodeExclusions, excludedByEither, dependencyEdge, nothing);
        }
        edgeExclusions = this.intersectEdgeExclusions(edgeExclusions, (PersistentSet<ExcludeSpec>)excludedByBoth);
        nodeExclusions = this.joinNodeExclusions(nodeExclusions, excludedByEither);
        return this.joinEdgeAndNodeExclusionsThenCacheResult(nodeExclusions, edgeExclusions, incomingEdgeCount);
    }

    private ExcludeSpec computeExclusionFilterSingleIncomingEdge(EdgeState dependencyEdge, ExcludeSpec nodeExclusions) {
        ExcludeSpec exclusions = null;
        if (dependencyEdge.isTransitive()) {
            exclusions = dependencyEdge.getExclusions();
        } else if (dependencyEdge.isConstraint()) {
            exclusions = dependencyEdge.getEdgeExclusions();
        }
        if (exclusions == null) {
            exclusions = this.moduleExclusions.nothing();
        }
        return this.joinEdgeAndNodeExclusionsThenCacheResult(nodeExclusions, exclusions, 1);
    }

    private ExcludeSpec joinEdgeAndNodeExclusionsThenCacheResult(ExcludeSpec nodeExclusions, ExcludeSpec edgeExclusions, int incomingEdgeCount) {
        ExcludeSpec result = this.moduleExclusions.excludeAny(edgeExclusions, nodeExclusions);
        this.previousIncomingEdgeCount = incomingEdgeCount;
        this.previousIncomingHash = this.incomingHash;
        this.cachedModuleResolutionFilter = result;
        return result;
    }

    private static PersistentSet<ExcludeSpec> collectEdgeConstraint(ExcludeSpec nodeExclusions, PersistentSet<ExcludeSpec> excludedByEither, EdgeState dependencyEdge, ExcludeSpec nothing) {
        ExcludeSpec constraintExclusions = dependencyEdge.getEdgeExclusions();
        if (constraintExclusions != nothing && constraintExclusions != nodeExclusions) {
            return excludedByEither.plus((Object)constraintExclusions);
        }
        return excludedByEither;
    }

    private @Nullable ExcludeSpec joinNodeExclusions(@Nullable ExcludeSpec nodeExclusions, PersistentSet<ExcludeSpec> excludedByEither) {
        if (excludedByEither.isNotEmpty() && nodeExclusions != null) {
            return this.moduleExclusions.excludeAny((PersistentSet<ExcludeSpec>)excludedByEither.plus((Object)nodeExclusions));
        }
        return nodeExclusions;
    }

    private @Nullable ExcludeSpec intersectEdgeExclusions(@Nullable ExcludeSpec edgeExclusions, PersistentSet<ExcludeSpec> excludedByBoth) {
        if (edgeExclusions == this.moduleExclusions.nothing()) {
            return edgeExclusions;
        }
        if (excludedByBoth.isNotEmpty()) {
            return this.moduleExclusions.excludeAll(edgeExclusions != null ? excludedByBoth.plus((Object)edgeExclusions) : excludedByBoth);
        }
        return edgeExclusions;
    }

    @VisibleForTesting
    void collectOwnStrictVersions(ExcludeSpec moduleResolutionFilter) {
        List<EdgeState> edges = this.edges(moduleResolutionFilter);
        PersistentSet<ModuleIdentifier> constraintsSet = PersistentSet.of();
        for (EdgeState edge : edges) {
            constraintsSet = NodeState.maybeCollectStrictVersions(constraintsSet, edge.getDependencyMetadata().getSelector());
        }
        this.storeOwnStrictVersions(constraintsSet);
    }

    private static PersistentSet<ModuleIdentifier> maybeCollectStrictVersions(PersistentSet<ModuleIdentifier> constraintsSet, ComponentSelector selector) {
        ModuleComponentSelector mcs;
        if (selector instanceof ModuleComponentSelector && !StringUtils.isEmpty((CharSequence)(mcs = (ModuleComponentSelector)selector).getVersionConstraint().getStrictVersion())) {
            constraintsSet = constraintsSet.plus((Object)mcs.getModuleIdentifier());
        }
        return constraintsSet;
    }

    private void storeOwnStrictVersions(PersistentSet<ModuleIdentifier> constraintsSet) {
        StrictVersionConstraints newStrictVersions = StrictVersionConstraints.of(constraintsSet);
        StrictVersionConstraints existingOwnStrictVersions = this.ownStrictVersions;
        this.ownStrictVersions = newStrictVersions;
        if (existingOwnStrictVersions == null) {
            return;
        }
        if (!newStrictVersions.equals(existingOwnStrictVersions)) {
            for (EdgeState incomingEdge : this.incomingEdges) {
                if (!incomingEdge.getDependencyMetadata().isEndorsingStrictVersions()) continue;
                incomingEdge.getFrom().invalidateEndorsedStrictVersions();
                this.recomputeAncestorsStrictVersions();
            }
            for (EdgeState outgoingEdge : this.outgoingEdges) {
                for (NodeState targetNode : outgoingEdge.getTargetNodes()) {
                    targetNode.recomputeAncestorsStrictVersions();
                }
            }
        }
    }

    @VisibleForTesting
    void recomputeAncestorsStrictVersions() {
        this.updateAncestorsStrictVersions(this.collectAncestorsStrictVersions());
    }

    private void updateAncestorsStrictVersions(StrictVersionConstraints newAncestorsStrictVersions) {
        if (newAncestorsStrictVersions.equals(this.ancestorsStrictVersions)) {
            return;
        }
        this.ancestorsStrictVersions = newAncestorsStrictVersions;
        for (EdgeState outgoingEdge : this.outgoingEdges) {
            for (NodeState targetNode : outgoingEdge.getTargetNodes()) {
                targetNode.recomputeAncestorsStrictVersions();
            }
        }
    }

    private StrictVersionConstraints collectAncestorsStrictVersions() {
        if (this.incomingEdges.isEmpty()) {
            return StrictVersionConstraints.EMPTY;
        }
        if (this.incomingEdges.size() == 1) {
            EdgeState dependencyEdge = this.incomingEdges.get(0);
            if (dependencyEdge.getFrom().isSelected()) {
                return this.getStrictVersionsForEdge(dependencyEdge);
            }
            return StrictVersionConstraints.EMPTY;
        }
        StrictVersionConstraints ancestorsStrictVersions = null;
        for (EdgeState dependencyEdge : this.incomingEdges) {
            if (!dependencyEdge.getFrom().isSelected()) continue;
            StrictVersionConstraints allEdgeStrictVersions = this.getStrictVersionsForEdge(dependencyEdge);
            if ((ancestorsStrictVersions = ancestorsStrictVersions == null ? allEdgeStrictVersions : ancestorsStrictVersions.intersect(allEdgeStrictVersions)) != StrictVersionConstraints.EMPTY) continue;
            break;
        }
        return ancestorsStrictVersions != null ? ancestorsStrictVersions : StrictVersionConstraints.EMPTY;
    }

    private StrictVersionConstraints getStrictVersionsForEdge(EdgeState dependencyEdge) {
        NodeState from = dependencyEdge.getFrom();
        StrictVersionConstraints parentStrongStrictVersions = from.getStrongStrictVersions();
        StrictVersionConstraints parentEndorsedStrictVersions = from.getEndorsedStrictVersions();
        StrictVersionConstraints filteredEndorsedStrictVersions = dependencyEdge.getDependencyMetadata().isEndorsingStrictVersions() ? parentEndorsedStrictVersions.minus(this.ownStrictVersions) : parentEndorsedStrictVersions;
        return parentStrongStrictVersions.union(filteredEndorsedStrictVersions);
    }

    private StrictVersionConstraints getStrongStrictVersions() {
        assert (this.ownStrictVersions != null);
        return this.ownStrictVersions.union(this.ancestorsStrictVersions);
    }

    private void invalidateEndorsedStrictVersions() {
        this.cachedEndorsedStrictVersions = null;
        for (EdgeState outgoingEdge : this.outgoingEdges) {
            for (NodeState targetNode : outgoingEdge.getTargetNodes()) {
                targetNode.recomputeAncestorsStrictVersions();
            }
        }
    }

    private StrictVersionConstraints getEndorsedStrictVersions() {
        if (this.cachedEndorsedStrictVersions == null) {
            this.cachedEndorsedStrictVersions = this.computeEndorsedStrictVersions();
        }
        return this.cachedEndorsedStrictVersions;
    }

    private StrictVersionConstraints computeEndorsedStrictVersions() {
        StrictVersionConstraints endorsedStrictVersions = StrictVersionConstraints.EMPTY;
        for (EdgeState edgeState : this.outgoingEdges) {
            if (!edgeState.getDependencyMetadata().isEndorsingStrictVersions()) continue;
            for (NodeState endorsedNode : edgeState.getTargetNodes()) {
                if (endorsedNode.ownStrictVersions == null) {
                    endorsedNode.collectOwnStrictVersions(endorsedNode.computeModuleResolutionFilter(endorsedNode.incomingEdges));
                }
                endorsedStrictVersions = endorsedStrictVersions.union(endorsedNode.ownStrictVersions);
            }
        }
        return endorsedStrictVersions;
    }

    private boolean sameIncomingEdgesAsPreviousPass(int incomingEdgeCount) {
        return this.cachedModuleResolutionFilter != null && this.previousIncomingHash == this.incomingHash && this.previousIncomingEdgeCount == incomingEdgeCount;
    }

    boolean isDisconnected() {
        return this.previousTraversalExclusions == null && !this.visitedDependencies;
    }

    public void removeOutgoingEdges() {
        if (this.previousTraversalExclusions == null) {
            return;
        }
        if (!this.outgoingEdges.isEmpty()) {
            for (EdgeState outgoingEdge : this.outgoingEdges) {
                this.disconnectOutgoingEdge(outgoingEdge);
            }
            this.outgoingEdges.clear();
        }
        this.cleanupConstraints();
        this.previousTraversalExclusions = null;
        this.previousAncestorsStrictVersions = null;
        this.visitedDependencies = false;
        this.cachedFilteredEdges = null;
        this.edgesToRecompute = null;
        this.virtualPlatformNeedsRefresh = false;
    }

    private void disconnectOutgoingEdge(EdgeState outgoingEdge) {
        outgoingEdge.detachFromTargetNodes();
        outgoingEdge.getSelector().getTargetModule().disconnectIncomingEdge(this, outgoingEdge);
    }

    public void restart(ComponentState selected) {
        if (this.component == selected && this.replacement == null) {
            this.resolveState.onMoreSelected(this);
        } else {
            this.restartIncomingEdges();
        }
    }

    private void restartIncomingEdges() {
        if (this.incomingEdges.size() == 1) {
            EdgeState singleEdge = this.incomingEdges.get(0);
            singleEdge.retarget();
        } else if (this.incomingEdges.size() > 1) {
            for (EdgeState edge : new ArrayList<EdgeState>(this.incomingEdges)) {
                edge.retarget();
            }
        }
        assert (this.incomingEdges.isEmpty());
    }

    public void deselect() {
        this.removeOutgoingEdges();
    }

    void prepareForConstraintNoLongerPending(ModuleIdentifier moduleIdentifier) {
        if (this.upcomingNoLongerPendingConstraints == null) {
            this.upcomingNoLongerPendingConstraints = new LinkedHashSet<ModuleIdentifier>();
        }
        this.upcomingNoLongerPendingConstraints.add(moduleIdentifier);
        this.resolveState.onFewerSelected(this);
    }

    void markForVirtualPlatformRefresh() {
        assert (this.component.getModule().isVirtualPlatform());
        this.virtualPlatformNeedsRefresh = true;
        this.resolveState.onFewerSelected(this);
    }

    void removeOutgoingEdge(EdgeState edge) {
        this.outgoingEdges.remove(edge);
        edge.clearSelector();
    }

    public @Nullable ImmutableCapability findCapability(String group, String name) {
        ImmutableCapabilities capabilities = this.metadata.getCapabilities();
        if (capabilities.isEmpty()) {
            if (this.component.getId().getGroup().equals(group) && this.component.getId().getName().equals(name)) {
                return this.component.getImplicitCapability();
            }
        } else {
            for (ImmutableCapability capability : capabilities) {
                if (!capability.getGroup().equals(group) || !capability.getName().equals(name)) continue;
                return capability;
            }
        }
        return null;
    }

    public boolean isAttachedToVirtualPlatform() {
        for (EdgeState incomingEdge : this.incomingEdges) {
            if (!(incomingEdge.getDependencyMetadata() instanceof LenientPlatformDependencyMetadata)) continue;
            return true;
        }
        return false;
    }

    boolean hasShadowedCapability() {
        for (Capability capability : this.metadata.getCapabilities().asSet()) {
            if (!(capability instanceof ShadowedCapability)) continue;
            return true;
        }
        return false;
    }

    boolean isSelectedByVariantAwareResolution() {
        return this.selectedByVariantAwareResolution && this.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable ResolvedGraphVariant getExternalVariant() {
        if (this.canIgnoreExternalVariant()) {
            return null;
        }
        if (this.findingExternalVariants) {
            LOGGER.warn("Detecting cycle in external variants for :\n" + this.computePathToRoot());
            this.findingExternalVariants = false;
            return null;
        }
        this.findingExternalVariants = true;
        assert (this.outgoingEdges.size() <= 1);
        try {
            Iterator<EdgeState> iterator = this.outgoingEdges.iterator();
            if (iterator.hasNext()) {
                EdgeState outgoingEdge = iterator.next();
                NodeState nodeState = outgoingEdge.getSelectedNode();
                return nodeState;
            }
            iterator = null;
            return iterator;
        }
        finally {
            this.findingExternalVariants = false;
        }
    }

    private String computePathToRoot() {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(this.getDisplayName());
        NodeState from = this;
        int depth = 0;
        do {
            if ((from = this.getFromNode(from)) == null) continue;
            formatter.startChildren();
            formatter.node(this.getDisplayName());
            ++depth;
        } while (from != null && !(from instanceof RootNode));
        for (int i = 0; i < depth; ++i) {
            formatter.endChildren();
        }
        formatter.node("Dependency resolution has ignored the cycle to produce a result. It is recommended to resolve the cycle by upgrading one or more dependencies.");
        return formatter.toString();
    }

    private @Nullable NodeState getFromNode(NodeState from) {
        Collection incomingEdges = from.getIncomingEdges();
        if (incomingEdges.isEmpty()) {
            return null;
        }
        return ((EdgeState)incomingEdges.get(0)).getFrom();
    }

    public Set<NodeState> getReachableNodes() {
        HashSet<NodeState> visited = new HashSet<NodeState>();
        this.dependsTransitivelyOn(visited);
        return visited;
    }

    private void dependsTransitivelyOn(Set<NodeState> visited) {
        for (EdgeState outgoingEdge : this.getOutgoingEdges()) {
            if (outgoingEdge.getTargetComponent() == null) continue;
            for (NodeState nodeState : outgoingEdge.getTargetComponent().getNodes()) {
                if (!visited.add(nodeState)) continue;
                nodeState.dependsTransitivelyOn(visited);
            }
        }
    }

    private static class NonTransitiveVariantDependencyMetadata
    extends DelegatingDependencyMetadata {
        private final DependencyMetadata dependencyMetadata;

        public NonTransitiveVariantDependencyMetadata(DependencyMetadata dependencyMetadata) {
            super(dependencyMetadata);
            this.dependencyMetadata = dependencyMetadata;
        }

        @Override
        public DependencyMetadata withTarget(ComponentSelector target) {
            return NodeState.makeNonTransitive(this.dependencyMetadata.withTarget(target));
        }

        @Override
        public DependencyMetadata withTargetAndArtifacts(ComponentSelector target, List<IvyArtifactName> artifacts) {
            return NodeState.makeNonTransitive(this.dependencyMetadata.withTargetAndArtifacts(target, artifacts));
        }

        @Override
        public boolean isTransitive() {
            return false;
        }

        @Override
        public DependencyMetadata withReason(String reason) {
            return NodeState.makeNonTransitive(this.dependencyMetadata.withReason(reason));
        }

        public String toString() {
            return "Non transitive dependency for external variant " + this.dependencyMetadata;
        }
    }
}

