/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.artifacts.component.ComponentSelectorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleSelectors;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.strict.StrictVersionConstraints;
import org.gradle.api.internal.attributes.AttributeMergingException;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.Describables;
import org.gradle.internal.Factory;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.jspecify.annotations.Nullable;

class EdgeState
implements DependencyGraphEdge {
    private final DependencyState dependencyState;
    private final DependencyMetadata dependencyMetadata;
    private final NodeState from;
    private final ResolveState resolveState;
    private final List<NodeState> targetNodes = new LinkedList<NodeState>();
    private final boolean isTransitive;
    private final boolean isConstraint;
    private @Nullable SelectorState selector;
    private ModuleVersionResolveException targetNodeSelectionFailure;
    private @Nullable ExcludeSpec transitiveExclusions;
    private ExcludeSpec cachedEdgeExclusions;
    private ExcludeSpec cachedExclusions;
    private @Nullable NodeState resolvedVariant;
    private boolean unattached;

    public EdgeState(NodeState from, DependencyMetadata metadata, ComponentSelector requested, ImmutableList<ComponentSelectionDescriptorInternal> ruleDescriptors, @Nullable ModuleVersionResolveException resolveFailure, ResolveState resolveState) {
        this.from = from;
        this.dependencyMetadata = metadata;
        this.resolveState = resolveState;
        this.isTransitive = from.isTransitive() && this.dependencyMetadata.isTransitive();
        this.isConstraint = this.dependencyMetadata.isConstraint();
        this.dependencyState = new DependencyState(metadata, requested, ruleDescriptors, resolveFailure);
    }

    boolean computeSelector(StrictVersionConstraints ancestorsStrictVersions, boolean deferSelection) {
        boolean ignoreVersion = !this.dependencyState.isForced() && ancestorsStrictVersions.contains(this.dependencyState.getModuleIdentifier(this.resolveState.getComponentSelectorConverter()));
        SelectorState newSelector = this.resolveState.computeSelectorFor(this.dependencyState, ignoreVersion);
        if (this.selector != newSelector) {
            this.clearSelector();
            newSelector.use(deferSelection);
            this.selector = newSelector;
            return true;
        }
        return false;
    }

    public void clearSelector() {
        if (this.selector != null) {
            this.selector.release();
            this.selector = null;
        }
    }

    public String toString() {
        return String.format("%s -> %s", this.from.toString(), this.dependencyMetadata);
    }

    @Override
    public NodeState getFrom() {
        return this.from;
    }

    @Override
    public DependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    @Nullable ComponentState getTargetComponent() {
        if (this.selector == null || !this.selector.isResolved() || this.selector.getFailure() != null) {
            return null;
        }
        return this.getSelectedComponent();
    }

    SelectorState getSelector() {
        assert (this.selector != null) : "No selector for " + this;
        return this.selector;
    }

    @Override
    public boolean isTransitive() {
        return this.isTransitive;
    }

    void attachToTargetNodes() {
        ComponentState targetComponent = this.getTargetComponent();
        if (targetComponent == null || !this.isUsed()) {
            return;
        }
        assert (!targetComponent.getModule().isPending());
        this.calculateTargetNodes(targetComponent);
        if (!this.targetNodes.isEmpty()) {
            for (NodeState targetNode : this.targetNodes) {
                targetNode.addIncomingEdge(this);
            }
            this.selector.getTargetModule().removeUnattachedEdge(this);
        }
    }

    void detachFromTargetNodes() {
        if (!this.targetNodes.isEmpty()) {
            for (NodeState targetNode : this.targetNodes) {
                targetNode.removeIncomingEdge(this);
            }
            this.targetNodes.clear();
        }
        this.targetNodeSelectionFailure = null;
    }

    void failWith(Throwable err) {
        this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.selector.getSelector(), err);
    }

    public void retarget() {
        this.detachFromTargetNodes();
        if (this.isUsed()) {
            this.attachToTargetNodes();
            if (this.targetNodes.isEmpty()) {
                this.selector.getTargetModule().addUnattachedEdge(this);
            }
        }
    }

    @Override
    public ImmutableAttributes getAttributes() {
        ModuleResolveState module = this.selector.getTargetModule();
        ComponentSelectorInternal componentSelector = (ComponentSelectorInternal)this.dependencyMetadata.getSelector();
        return this.resolveState.getAttributesFactory().safeConcat(module.getMergedConstraintAttributes(), componentSelector.getAttributes());
    }

    private void calculateTargetNodes(ComponentState targetComponent) {
        GraphVariantSelectionResult targetVariants;
        ComponentGraphResolveState targetComponentState = targetComponent.getResolveStateOrNull();
        this.targetNodes.clear();
        this.targetNodeSelectionFailure = null;
        if (targetComponentState == null) {
            targetComponent.getModule().getPlatformState().addOrphanEdge(this);
            return;
        }
        if (this.isConstraint) {
            List<NodeState> nodes = targetComponent.getNodes();
            for (NodeState nodeState : nodes) {
                if (!nodeState.isSelected() || nodeState.isRoot()) continue;
                this.targetNodes.add(nodeState);
            }
            if (this.targetNodes.isEmpty()) {
                List<EdgeState> unattachedEdges = targetComponent.getModule().getUnattachedEdges();
                if (!unattachedEdges.isEmpty()) {
                    for (EdgeState otherEdge : unattachedEdges) {
                        if (otherEdge.isConstraint()) continue;
                        otherEdge.attachToTargetNodes();
                        if (otherEdge.targetNodeSelectionFailure == null) break;
                        this.targetNodeSelectionFailure = otherEdge.targetNodeSelectionFailure;
                        return;
                    }
                }
                for (NodeState node : nodes) {
                    if (!node.isSelected() || node.isRoot()) continue;
                    this.targetNodes.add(node);
                }
            }
            return;
        }
        try {
            targetVariants = this.selectTargetVariants(targetComponentState);
        }
        catch (AttributeMergingException mergeError) {
            this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.getRequested(), (Factory<String>)((Factory)() -> {
                Attribute attribute = mergeError.getAttribute();
                Object constraintValue = mergeError.getLeftValue();
                Object dependencyValue = mergeError.getRightValue();
                return "Inconsistency between attributes of a constraint and a dependency, on attribute '" + attribute + "' : dependency requires '" + dependencyValue + "' while constraint required '" + constraintValue + "'";
            }));
            return;
        }
        catch (Exception t) {
            this.targetNodeSelectionFailure = new ModuleVersionResolveException(this.getRequested(), (Throwable)t);
            return;
        }
        for (VariantGraphResolveState variantGraphResolveState : targetVariants.getVariants()) {
            NodeState targetNodeState = this.resolveState.getNode(targetComponent, variantGraphResolveState, targetVariants.isSelectedByVariantAwareResolution());
            while (targetNodeState.getReplacement() != null) {
                targetNodeState = targetNodeState.getReplacement();
            }
            this.targetNodes.add(targetNodeState);
        }
    }

    private GraphVariantSelectionResult selectTargetVariants(ComponentGraphResolveState targetComponentState) {
        ImmutableAttributesSchema consumerSchema;
        ImmutableAttributes attributes;
        GraphVariantSelector variantSelector = this.resolveState.getVariantSelector();
        List<? extends VariantGraphResolveState> overrideVariants = this.dependencyMetadata.overrideVariantSelection(variantSelector, attributes = this.resolveState.getAttributesFactory().concat(this.resolveState.getConsumerAttributes(), this.getAttributes()), targetComponentState, consumerSchema = this.resolveState.getConsumerSchema());
        if (overrideVariants != null) {
            return new GraphVariantSelectionResult(overrideVariants, false);
        }
        if (!targetComponentState.getCandidatesForGraphVariantSelection().getVariantsForAttributeMatching().isEmpty()) {
            Set capabilitySelectors = this.dependencyMetadata.getSelector().getCapabilitySelectors();
            VariantGraphResolveState selected = variantSelector.selectByAttributeMatching(attributes, capabilitySelectors, targetComponentState, consumerSchema, this.dependencyMetadata.getArtifacts());
            return new GraphVariantSelectionResult(Collections.singletonList(selected), true);
        }
        List<? extends VariantGraphResolveState> legacyVariants = this.dependencyMetadata.selectLegacyVariants(variantSelector, attributes, targetComponentState, consumerSchema);
        return new GraphVariantSelectionResult(legacyVariants, false);
    }

    @Override
    public boolean isFromLock() {
        return this.dependencyState.isFromLock();
    }

    @Override
    public ExcludeSpec getExclusions() {
        if (this.cachedExclusions == null) {
            this.computeExclusions();
        }
        return this.cachedExclusions;
    }

    private void computeExclusions() {
        List<ExcludeMetadata> excludes = this.dependencyMetadata.getExcludes();
        if (excludes.isEmpty()) {
            this.cachedExclusions = this.transitiveExclusions;
        } else {
            this.computeExclusionsWhenExcludesPresent(excludes);
        }
    }

    private void computeExclusionsWhenExcludesPresent(List<ExcludeMetadata> excludes) {
        ModuleExclusions moduleExclusions = this.resolveState.getModuleExclusions();
        ExcludeSpec edgeExclusions = moduleExclusions.excludeAny(excludes);
        this.cachedExclusions = moduleExclusions.excludeAny(edgeExclusions, this.transitiveExclusions);
    }

    ExcludeSpec getEdgeExclusions() {
        if (this.cachedEdgeExclusions == null) {
            List<ExcludeMetadata> excludes = this.dependencyMetadata.getExcludes();
            ModuleExclusions moduleExclusions = this.resolveState.getModuleExclusions();
            if (excludes.isEmpty()) {
                return moduleExclusions.nothing();
            }
            this.cachedEdgeExclusions = moduleExclusions.excludeAny(excludes);
        }
        return this.cachedEdgeExclusions;
    }

    @Override
    public boolean contributesArtifacts() {
        return !this.isConstraint;
    }

    @Override
    public ComponentSelector getRequested() {
        return this.resolveState.desugarSelector(this.dependencyState.getRequested());
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        if (this.targetNodeSelectionFailure != null) {
            return this.targetNodeSelectionFailure;
        }
        ModuleVersionResolveException selectorFailure = this.selector.getFailure();
        if (selectorFailure != null) {
            return selectorFailure;
        }
        ComponentState selectedComponent = this.getSelectedComponent();
        if (selectedComponent == null) {
            ModuleSelectors<SelectorState> selectors = this.selector.getTargetModule().getSelectors();
            for (SelectorState state : selectors) {
                selectorFailure = state.getFailure();
                if (selectorFailure == null) continue;
                return selectorFailure;
            }
            throw new IllegalStateException("Expected to find a selector with a failure but none was found");
        }
        return selectedComponent.getMetadataResolveFailure();
    }

    @Override
    public Long getSelected() {
        return this.getSelectedComponent().getResultId();
    }

    @Override
    public boolean isTargetVirtualPlatform() {
        ComponentState selectedComponent = this.getSelectedComponent();
        return selectedComponent != null && selectedComponent.getModule().isVirtualPlatform();
    }

    @Override
    public @Nullable Long getSelectedVariant() {
        NodeState node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        assert (node.getComponent() == this.getSelectedComponent());
        return node.getNodeId();
    }

    public Collection<NodeState> getTargetNodes() {
        return this.targetNodes;
    }

    public @Nullable NodeState getSelectedNode() {
        ComponentState targetComponent;
        if (this.resolvedVariant != null) {
            return this.resolvedVariant;
        }
        List<NodeState> targetNodes = this.targetNodes;
        if (targetNodes.isEmpty() && (targetComponent = this.getTargetComponent()) != null) {
            targetNodes = targetComponent.getNodes();
        }
        assert (!targetNodes.isEmpty());
        for (NodeState targetNode : targetNodes) {
            if (!targetNode.isSelected()) continue;
            this.resolvedVariant = targetNode;
            return this.resolvedVariant;
        }
        return null;
    }

    @Override
    public ComponentSelectionReasonInternal getReason() {
        ImmutableSet.Builder dependencyReasons = ImmutableSet.builderWithExpectedSize((int)4);
        this.visitSelectionReasons(arg_0 -> ((ImmutableSet.Builder)dependencyReasons).add(arg_0));
        return ComponentSelectionReasons.of((ImmutableSet<ComponentSelectionDescriptorInternal>)dependencyReasons.build());
    }

    @Override
    public void visitSelectionReasons(Consumer<ComponentSelectionDescriptorInternal> visitor) {
        visitor.accept(this.getMainReason());
        ImmutableList<ComponentSelectionDescriptorInternal> ruleDescriptors = this.dependencyState.getRuleDescriptors();
        if (!ruleDescriptors.isEmpty()) {
            ruleDescriptors.forEach(visitor);
        }
        if (this.dependencyState.isForced()) {
            visitor.accept(ComponentSelectionReasons.FORCED);
        }
    }

    private ComponentSelectionDescriptorInternal getMainReason() {
        if (this.selector != null && this.selector.isVersionProvidedByAncestor()) {
            return this.withDependencyReason(ComponentSelectionReasons.BY_ANCESTOR);
        }
        if (this.dependencyState.getDependency().isConstraint()) {
            return this.withSelectorReason(this.withDependencyReason(ComponentSelectionReasons.CONSTRAINT));
        }
        return this.withSelectorReason(this.withDependencyReason(ComponentSelectionReasons.REQUESTED));
    }

    private ComponentSelectionDescriptorInternal withDependencyReason(ComponentSelectionDescriptorInternal dependencyDescriptor) {
        String reason = this.dependencyState.getDependency().getReason();
        if (reason != null) {
            dependencyDescriptor = dependencyDescriptor.withDescription((Describable)Describables.of((Object)reason));
        }
        return dependencyDescriptor;
    }

    private ComponentSelectionDescriptorInternal withSelectorReason(ComponentSelectionDescriptorInternal descriptor) {
        return this.selector == null ? descriptor : this.selector.maybeEnhanceReason(descriptor);
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    private @Nullable ComponentState getSelectedComponent() {
        return this.selector.getTargetModule().getSelected();
    }

    DependencyState getDependencyState() {
        return this.dependencyState;
    }

    public void updateTransitiveExcludes(ExcludeSpec newResolutionFilter) {
        if (this.isConstraint) {
            return;
        }
        this.transitiveExclusions = newResolutionFilter;
        this.cachedExclusions = null;
    }

    public void updateTransitiveExcludesAndRequeueTargetNodes(ExcludeSpec newResolutionFilter) {
        this.updateTransitiveExcludes(newResolutionFilter);
        for (NodeState targetNode : this.targetNodes) {
            targetNode.clearTransitiveExclusionsAndEnqueue();
        }
    }

    void recomputeSelectorAndRequeueTargetNodes(StrictVersionConstraints ancestorsStrictVersions, Collection<EdgeState> discoveredEdges) {
        if (this.computeSelector(ancestorsStrictVersions, false)) {
            discoveredEdges.add(this);
        }
        for (NodeState targetNode : this.targetNodes) {
            this.resolveState.onMoreSelected(targetNode);
        }
    }

    @Nullable ExcludeSpec getTransitiveExclusions() {
        return this.transitiveExclusions;
    }

    public void markUnattached() {
        this.unattached = true;
    }

    public void markAttached() {
        this.unattached = false;
    }

    public boolean isUnattached() {
        return this.unattached;
    }

    boolean isUsed() {
        return this.selector != null;
    }

    public boolean isArtifactOnlyEdge() {
        return !this.isTransitive && !this.dependencyMetadata.getArtifacts().isEmpty();
    }

    public static class GraphVariantSelectionResult {
        private final List<? extends VariantGraphResolveState> variants;
        private final boolean selectedByVariantAwareResolution;

        public GraphVariantSelectionResult(List<? extends VariantGraphResolveState> variants, boolean selectedByVariantAwareResolution) {
            this.variants = variants;
            this.selectedByVariantAwareResolution = selectedByVariantAwareResolution;
        }

        public List<? extends VariantGraphResolveState> getVariants() {
            return this.variants;
        }

        public boolean isSelectedByVariantAwareResolution() {
            return this.selectedByVariantAwareResolution;
        }
    }
}

