/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.UncheckedException;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class TextUtil {
    private static final Pattern WHITESPACE = Pattern.compile("\\s*");
    private static final Pattern LINE_SEPARATORS = Pattern.compile("\r\n|\r|\n");
    private static final Pattern NON_UNIX_LINE_SEPARATORS = Pattern.compile("\r\n|\r");
    private static final Pattern WORD_SEPARATOR = Pattern.compile("\\W+");
    private static final Pattern UPPER_CASE = Pattern.compile("(?=\\p{Upper})");

    public static String getWindowsLineSeparator() {
        return "\r\n";
    }

    public static String getUnixLineSeparator() {
        return "\n";
    }

    public static String getPlatformLineSeparator() {
        return SystemProperties.getInstance().getLineSeparator();
    }

    public static @Nullable String convertLineSeparators(@Nullable String str, String sep) {
        return str == null ? null : TextUtil.replaceLineSeparatorsOf(str, sep);
    }

    public static String convertLineSeparatorsToUnix(String str) {
        return TextUtil.replaceAll(NON_UNIX_LINE_SEPARATORS, str, "\n");
    }

    public static String replaceLineSeparatorsOf(String string, String bySeparator) {
        if (TextUtil.isMultiLeLine(string)) {
            return TextUtil.replaceAll(LINE_SEPARATORS, string, bySeparator);
        }
        return string;
    }

    private static boolean isMultiLeLine(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }

    private static String replaceAll(Pattern pattern, CharSequence inString, String byString) {
        return pattern.matcher(inString).replaceAll(byString);
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String toPlatformLineSeparators(@Nullable String str) {
        return str == null ? null : TextUtil.replaceLineSeparatorsOf(str, TextUtil.getPlatformLineSeparator());
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String normaliseLineSeparators(@Nullable String str) {
        return str == null ? null : TextUtil.convertLineSeparatorsToUnix(str);
    }

    public static String normaliseFileSeparators(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static boolean isBlank(@Nullable String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String capitalize(@Nullable String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return Character.toTitleCase(str.charAt(0)) + str.substring(1);
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String escapeString(@Nullable Object obj) {
        return obj == null ? null : TextUtil.escapeJavaStyleString(obj.toString(), false, false);
    }

    @Contract(value="null, _, _ -> null; !null, _, _ -> !null")
    private static @Nullable String escapeJavaStyleString(@Nullable String str, boolean escapeSingleQuotes, boolean escapeForwardSlash) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length() * 2);
            TextUtil.escapeJavaStyleString(writer, str, escapeSingleQuotes, escapeForwardSlash);
            return writer.toString();
        }
        catch (IOException ioe) {
            throw UncheckedException.throwAsUncheckedException((Throwable)ioe);
        }
    }

    private static void escapeJavaStyleString(Writer out, String str, boolean escapeSingleQuote, boolean escapeForwardSlash) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                out.write("\\u" + TextUtil.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                out.write("\\u0" + TextUtil.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                out.write("\\u00" + TextUtil.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.write(92);
                        out.write(98);
                        break;
                    }
                    case '\n': {
                        out.write(92);
                        out.write(110);
                        break;
                    }
                    case '\t': {
                        out.write(92);
                        out.write(116);
                        break;
                    }
                    case '\f': {
                        out.write(92);
                        out.write(102);
                        break;
                    }
                    case '\r': {
                        out.write(92);
                        out.write(114);
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.write("\\u00" + TextUtil.hex(ch));
                            break;
                        }
                        out.write("\\u000" + TextUtil.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    if (escapeSingleQuote) {
                        out.write(92);
                    }
                    out.write(39);
                    continue block13;
                }
                case '\"': {
                    out.write(92);
                    out.write(34);
                    continue block13;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block13;
                }
                case '/': {
                    if (escapeForwardSlash) {
                        out.write(92);
                    }
                    out.write(47);
                    continue block13;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public static boolean containsWhitespace(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String indent(String text, String indent) {
        StringBuilder builder = new StringBuilder();
        String[] lines = text.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!WHITESPACE.matcher(line).matches()) {
                builder.append(indent);
            }
            builder.append(line);
            if (i >= lines.length - 1) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    public static String shorterOf(String s1, String s2) {
        if (s2.length() >= s1.length()) {
            return s1;
        }
        return s2;
    }

    public static String minus(String originalString, String removeString) {
        String s = originalString.toString();
        int index = s.indexOf(removeString);
        if (index == -1) {
            return s;
        }
        int end = index + removeString.length();
        if (s.length() > end) {
            return s.substring(0, index) + s.substring(end);
        }
        return s.substring(0, index);
    }

    public static String normaliseFileAndLineSeparators(String in) {
        return TextUtil.normaliseLineSeparators(TextUtil.normaliseFileSeparators(in));
    }

    public static String getPluralEnding(Collection<?> collection) {
        return collection.size() > 1 ? "s" : "";
    }

    public static String endLineWithDot(String txt) {
        if (txt.endsWith(".") || txt.endsWith("\n")) {
            return txt;
        }
        return txt + ".";
    }

    public static String screamingSnakeToKebabCase(String text) {
        return Strings.CS.replace(text.toLowerCase(Locale.ENGLISH), "_", "-");
    }

    public static String camelToKebabCase(String camelCase) {
        return Stream.of(UPPER_CASE.split(camelCase)).map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.joining("-"));
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String toCamelCase(@Nullable CharSequence string) {
        return TextUtil.toCamelCase(string, false);
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String toLowerCamelCase(@Nullable CharSequence string) {
        return TextUtil.toCamelCase(string, true);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    private static @Nullable String toCamelCase(@Nullable CharSequence string, boolean lower) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Matcher matcher = WORD_SEPARATOR.matcher(string);
        int pos = 0;
        boolean first = true;
        while (matcher.find()) {
            String chunk = string.subSequence(pos, matcher.start()).toString();
            pos = matcher.end();
            if (chunk.isEmpty()) continue;
            if (lower && first) {
                chunk = StringUtils.uncapitalize((String)chunk);
                first = false;
            } else {
                chunk = StringUtils.capitalize((String)chunk);
            }
            builder.append(chunk);
        }
        String rest = string.subSequence(pos, string.length()).toString();
        rest = lower && first ? StringUtils.uncapitalize((String)rest) : StringUtils.capitalize((String)rest);
        builder.append(rest);
        return builder.toString();
    }

    public static String removeTrailing(String originalString, String suffix) {
        if (originalString.endsWith(suffix)) {
            return originalString.substring(0, originalString.length() - suffix.length());
        }
        return originalString;
    }
}

