/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.internal.reflect.ClassDetails;
import org.gradle.internal.reflect.MutableClassDetails;
import org.gradle.internal.reflect.PropertyAccessorType;

public class ClassInspector {
    public static ClassDetails inspect(Class<?> type) {
        MutableClassDetails classDetails = new MutableClassDetails(type);
        ClassInspector.visitGraph(type, current -> {
            if (!current.equals(type)) {
                classDetails.superType((Class<?>)current);
            }
            ClassInspector.inspectClass(current, classDetails);
        });
        return classDetails;
    }

    public static List<Method> inspectMethods(Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ClassInspector.visitGraph(type, current -> Collections.addAll(methods, current.getDeclaredMethods()));
        return methods;
    }

    private static void visitGraph(Class<?> type, Consumer<Class<?>> visitor) {
        HashSet<Class> seen = new HashSet<Class>();
        ArrayDeque queue = new ArrayDeque();
        queue.add(type);
        ClassInspector.superClasses(type, queue);
        while (!queue.isEmpty()) {
            Class current = (Class)queue.removeFirst();
            if (!seen.add(current)) continue;
            visitor.accept(current);
            Collections.addAll(queue, current.getInterfaces());
        }
    }

    private static void superClasses(Class<?> current, Collection<Class<?>> supers) {
        for (Class<?> superclass = current.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            supers.add(superclass);
        }
    }

    private static void inspectClass(Class<?> type, MutableClassDetails classDetails) {
        for (Method method : type.getDeclaredMethods()) {
            String propertyName;
            classDetails.method(method);
            if (Modifier.isPrivate(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
            PropertyAccessorType accessorType = PropertyAccessorType.of(method);
            if (accessorType == PropertyAccessorType.GET_GETTER || accessorType == PropertyAccessorType.IS_GETTER) {
                propertyName = accessorType.propertyNameFor(method);
                classDetails.property(propertyName).addGetter(method);
                continue;
            }
            if (accessorType == PropertyAccessorType.SETTER) {
                propertyName = accessorType.propertyNameFor(method);
                classDetails.property(propertyName).addSetter(method);
                continue;
            }
            classDetails.instanceMethod(method);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredFields()) {
            classDetails.field((Field)accessibleObject);
        }
    }
}

