/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class DefaultModuleRegistry
implements ModuleRegistry {
    private final GradleInstallation gradleInstallation;
    private final Map<String, Module> modules = new HashMap<String, Module>();
    private final Map<String, Module> externalModules = new HashMap<String, Module>();
    private static final String[] NO_PROJECTS = new String[0];

    public DefaultModuleRegistry(@Nullable GradleInstallation gradleInstallation) {
        if (gradleInstallation == null) {
            throw new IllegalArgumentException("A Gradle installation is required to execute Gradle.");
        }
        this.gradleInstallation = gradleInstallation;
    }

    @Override
    public Module getExternalModule(String name) {
        Module module = this.externalModules.get(name);
        if (module == null) {
            module = this.loadExternalModule(name);
            this.externalModules.put(name, module);
        }
        return module;
    }

    private Module loadExternalModule(String name) {
        File externalJar = this.findJar(name);
        if (externalJar == null) {
            throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in distribution directory '%s'.", name, this.gradleInstallation.getGradleHome()));
        }
        return new DefaultModule(name, Collections.singleton(externalJar), Collections.emptySet());
    }

    @Override
    public Module getModule(String name) {
        Module module = this.modules.get(name);
        if (module == null) {
            module = this.loadModule(name);
            this.modules.put(name, module);
        }
        return module;
    }

    @Override
    public @Nullable Module findModule(String name) {
        Module module = this.modules.get(name);
        if (module == null && (module = this.loadOptionalModule(name)) != null) {
            this.modules.put(name, module);
        }
        return module;
    }

    private Module loadModule(String moduleName) {
        Module module = this.loadOptionalModule(moduleName);
        if (module != null) {
            return module;
        }
        throw new UnknownModuleException(String.format("Cannot locate JAR for module '%s' in distribution directory '%s'.", moduleName, this.gradleInstallation.getGradleHome()));
    }

    private @Nullable Module loadOptionalModule(String moduleName) {
        File jarFile = this.findJar(moduleName);
        if (jarFile != null) {
            LinkedHashSet<File> implementationClasspath = new LinkedHashSet<File>();
            implementationClasspath.add(jarFile);
            Properties properties = DefaultModuleRegistry.loadModuleProperties(moduleName, jarFile);
            return this.module(moduleName, properties, implementationClasspath);
        }
        return null;
    }

    private Module module(String moduleName, Properties properties, Set<File> implementationClasspath) {
        String[] runtimeJarNames = this.split(properties.getProperty("runtime"));
        Set<File> runtimeClasspath = this.findDependencyJars(moduleName, runtimeJarNames);
        String[] projects = this.split(properties.getProperty("projects"));
        String[] optionalProjects = this.split(properties.getProperty("optional"));
        return new DefaultModule(moduleName, implementationClasspath, runtimeClasspath, projects, optionalProjects);
    }

    private Set<File> findDependencyJars(String moduleName, String[] jarNames) {
        LinkedHashSet<File> runtimeClasspath = new LinkedHashSet<File>();
        for (String jarName : jarNames) {
            runtimeClasspath.add(this.findDependencyJar(moduleName, jarName));
        }
        return runtimeClasspath;
    }

    private Set<Module> getModules(String[] projectNames) {
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        for (String project : projectNames) {
            modules.add(this.getModule(project));
        }
        return modules;
    }

    private String[] split(@Nullable String value) {
        if (value == null) {
            return new String[0];
        }
        if ((value = value.trim()).length() == 0) {
            return new String[0];
        }
        return value.split(",");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Properties loadModuleProperties(String name, File jarFile) {
        try (ZipFile zipFile = new ZipFile(jarFile);){
            Properties properties;
            block14: {
                String entryName = name + "-classpath.properties";
                ZipEntry entry = zipFile.getEntry(entryName);
                if (entry == null) {
                    throw new IllegalStateException("Did not find " + entryName + " in " + jarFile.getAbsolutePath());
                }
                InputStream is = zipFile.getInputStream(entry);
                try {
                    properties = GUtil.loadProperties((InputStream)is);
                    if (is == null) break block14;
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                is.close();
            }
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Could not load properties for module '%s' from %s", name, jarFile), e);
        }
    }

    private @Nullable File findJar(String name) {
        Pattern pattern = Pattern.compile(Pattern.quote(name) + "-\\d.*\\.jar");
        for (File libDir : this.gradleInstallation.getLibDirs()) {
            File[] files = libDir.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (!pattern.matcher(file.getName()).matches()) continue;
                return file;
            }
        }
        return null;
    }

    private File findDependencyJar(String module, String name) {
        for (File libDir : this.gradleInstallation.getLibDirs()) {
            File jarFile = new File(libDir, name);
            if (!jarFile.isFile()) continue;
            return jarFile;
        }
        throw new IllegalArgumentException(String.format("Cannot find JAR '%s' required by module '%s' using classpath or distribution directory '%s'", name, module, this.gradleInstallation.getGradleHome()));
    }

    private class DefaultModule
    implements Module {
        private final String name;
        private final String[] projects;
        private final String[] optionalProjects;
        private final ClassPath implementationClasspath;
        private final ClassPath runtimeClasspath;
        private final ClassPath classpath;

        public DefaultModule(String name, Set<File> implementationClasspath, Set<File> runtimeClasspath, String[] projects, String[] optionalProjects) {
            this.name = name;
            this.projects = projects;
            this.optionalProjects = optionalProjects;
            this.implementationClasspath = DefaultClassPath.of(implementationClasspath);
            this.runtimeClasspath = DefaultClassPath.of(runtimeClasspath);
            LinkedHashSet<File> classpath = new LinkedHashSet<File>();
            classpath.addAll(implementationClasspath);
            classpath.addAll(runtimeClasspath);
            this.classpath = DefaultClassPath.of(classpath);
        }

        public DefaultModule(String name, Set<File> singleton, Set<File> files) {
            this(name, singleton, files, NO_PROJECTS, NO_PROJECTS);
        }

        public String toString() {
            return "module '" + this.name + "'";
        }

        @Override
        public Set<Module> getRequiredModules() {
            return DefaultModuleRegistry.this.getModules(this.projects);
        }

        @Override
        public ClassPath getImplementationClasspath() {
            return this.implementationClasspath;
        }

        @Override
        public ClassPath getRuntimeClasspath() {
            return this.runtimeClasspath;
        }

        @Override
        public ClassPath getClasspath() {
            return this.classpath;
        }

        @Override
        public Set<Module> getAllRequiredModules() {
            LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
            this.collectRequiredModules(modules);
            return modules;
        }

        @Override
        public ClassPath getAllRequiredModulesClasspath() {
            ClassPath classPath = ClassPath.EMPTY;
            for (Module module : this.getAllRequiredModules()) {
                classPath = classPath.plus(module.getClasspath());
            }
            return classPath;
        }

        private void collectRequiredModules(Set<Module> modules) {
            if (!modules.add(this)) {
                return;
            }
            for (Module module : this.getRequiredModules()) {
                this.collectDependenciesOf(module, modules);
            }
            for (String optionalProject : this.optionalProjects) {
                Module module = this.findModule(optionalProject);
                if (module == null) continue;
                this.collectDependenciesOf(module, modules);
            }
        }

        private void collectDependenciesOf(Module module, Set<Module> modules) {
            ((DefaultModule)module).collectRequiredModules(modules);
        }

        private @Nullable Module findModule(String optionalProject) {
            try {
                return DefaultModuleRegistry.this.getModule(optionalProject);
            }
            catch (UnknownModuleException ex) {
                return null;
            }
        }
    }
}

