/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.internal.Cast;

public class UnionFileTree
extends CompositeFileTree {
    private final Set<FileTreeInternal> sourceTrees;
    private final String displayName;

    public UnionFileTree(TaskDependencyFactory taskDependencyFactory, FileTreeInternal ... sourceTrees) {
        this(taskDependencyFactory, "file tree", Arrays.asList(sourceTrees));
    }

    public UnionFileTree(TaskDependencyFactory taskDependencyFactory, String displayName, FileTreeInternal ... sourceTrees) {
        this(taskDependencyFactory, displayName, Arrays.asList(sourceTrees));
    }

    public UnionFileTree(TaskDependencyFactory taskDependencyFactory, String displayName, Collection<? extends FileTreeInternal> sourceTrees) {
        super(taskDependencyFactory);
        this.displayName = displayName;
        this.sourceTrees = Sets.newLinkedHashSet(sourceTrees);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        for (FileTreeInternal sourceTree : this.sourceTrees) {
            visitor.accept(sourceTree);
        }
    }

    public void addToUnion(FileCollection source) {
        if (!(source instanceof FileTree)) {
            throw new UnsupportedOperationException(String.format("Can only add FileTree instances to %s.", this.getDisplayName()));
        }
        this.sourceTrees.add((FileTreeInternal)Cast.cast(FileTreeInternal.class, (Object)source));
    }
}

