/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionIdentifierSerializer;
import org.gradle.api.internal.artifacts.capability.CapabilitySelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.CapabilitySerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedVariantResultSerializer;
import org.gradle.api.internal.artifacts.metadata.ComponentArtifactIdentifierSerializer;
import org.gradle.api.internal.artifacts.metadata.ComponentFileArtifactIdentifierSerializer;
import org.gradle.api.internal.artifacts.metadata.ModuleComponentFileArtifactIdentifierSerializer;
import org.gradle.api.internal.artifacts.metadata.PublishArtifactLocalArtifactMetadataSerializer;
import org.gradle.api.internal.artifacts.metadata.TransformedComponentFileArtifactIdentifierSerializer;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentFileArtifactIdentifier;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.local.model.OpaqueComponentArtifactIdentifier;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.local.model.TransformedComponentFileArtifactIdentifier;
import org.gradle.internal.resolve.caching.DesugaringAttributeContainerSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.impl.ValueSnapshotterSerializerRegistry;

public class DependencyManagementValueSnapshotterSerializerRegistry
extends DefaultSerializerRegistry
implements ValueSnapshotterSerializerRegistry {
    private static final List<Class<?>> SUPPORTED_TYPES = ImmutableList.of(Capability.class, ModuleVersionIdentifier.class, PublishArtifactLocalArtifactMetadata.class, OpaqueComponentArtifactIdentifier.class, DefaultModuleComponentArtifactIdentifier.class, ModuleComponentFileArtifactIdentifier.class, ComponentFileArtifactIdentifier.class, ComponentIdentifier.class, AttributeContainer.class, ResolvedVariantResult.class, ComponentSelectionDescriptor.class, ComponentSelectionReason.class, (Object[])new Class[]{ComponentSelector.class, ResolvedComponentResult.class});

    public DependencyManagementValueSnapshotterSerializerRegistry(ImmutableModuleIdentifierFactory moduleIdentifierFactory, AttributesFactory attributesFactory, NamedObjectInstantiator namedObjectInstantiator, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory) {
        super(true);
        CapabilitySelectorSerializer capabilitySelectorSerializer = new CapabilitySelectorSerializer();
        ComponentIdentifierSerializer componentIdentifierSerializer = new ComponentIdentifierSerializer();
        DesugaringAttributeContainerSerializer attributeContainerSerializer = new DesugaringAttributeContainerSerializer(attributesFactory, namedObjectInstantiator);
        ModuleVersionIdentifierSerializer moduleVersionIdentifierSerializer = new ModuleVersionIdentifierSerializer(moduleIdentifierFactory);
        ComponentSelectorSerializer componentSelectorSerializer = new ComponentSelectorSerializer(attributeContainerSerializer, capabilitySelectorSerializer);
        this.register(Capability.class, new CapabilitySerializer());
        this.register(ModuleVersionIdentifier.class, moduleVersionIdentifierSerializer);
        this.register(PublishArtifactLocalArtifactMetadata.class, new PublishArtifactLocalArtifactMetadataSerializer(componentIdentifierSerializer));
        this.register(OpaqueComponentArtifactIdentifier.class, new OpaqueComponentArtifactIdentifierSerializer());
        this.register(DefaultModuleComponentArtifactIdentifier.class, new ComponentArtifactIdentifierSerializer());
        this.register(ModuleComponentFileArtifactIdentifier.class, new ModuleComponentFileArtifactIdentifierSerializer());
        this.register(ComponentFileArtifactIdentifier.class, new ComponentFileArtifactIdentifierSerializer());
        this.register(TransformedComponentFileArtifactIdentifier.class, new TransformedComponentFileArtifactIdentifierSerializer());
        this.register(DefaultModuleComponentIdentifier.class, (Serializer)Cast.uncheckedCast((Object)((Object)componentIdentifierSerializer)));
        this.register(AttributeContainer.class, attributeContainerSerializer);
        this.registerWithFactory(ResolvedVariantResult.class, () -> new ResolvedVariantResultSerializer(componentIdentifierSerializer, attributeContainerSerializer));
        this.register(ComponentSelectionDescriptorInternal.class, new ComponentSelectionDescriptorSerializer(componentSelectionDescriptorFactory));
        ComponentSelectionReasonSerializer componentSelectionReasonSerializer = new ComponentSelectionReasonSerializer(componentSelectionDescriptorFactory);
        this.register(ComponentSelectionReasonInternal.class, componentSelectionReasonSerializer);
        this.register(ComponentSelector.class, (Serializer)componentSelectorSerializer);
        this.registerWithFactory(ResolvedComponentResult.class, () -> DependencyManagementValueSnapshotterSerializerRegistry.lambda$new$1(componentIdentifierSerializer, attributeContainerSerializer, moduleVersionIdentifierSerializer, (Serializer)componentSelectorSerializer, componentSelectionReasonSerializer));
    }

    public boolean canSerialize(Class<?> baseType) {
        return super.canSerialize(DependencyManagementValueSnapshotterSerializerRegistry.baseTypeOf(baseType));
    }

    public <T> Serializer<T> build(Class<T> baseType) {
        return super.build((Class)Cast.uncheckedCast(DependencyManagementValueSnapshotterSerializerRegistry.baseTypeOf(baseType)));
    }

    private static Class<?> baseTypeOf(Class<?> type) {
        for (Class<?> supportedType : SUPPORTED_TYPES) {
            if (!supportedType.isAssignableFrom(type)) continue;
            return supportedType;
        }
        return type;
    }

    private static /* synthetic */ Serializer lambda$new$1(ComponentIdentifierSerializer componentIdentifierSerializer, AttributeContainerSerializer attributeContainerSerializer, ModuleVersionIdentifierSerializer moduleVersionIdentifierSerializer, Serializer componentSelectorSerializer, ComponentSelectionReasonSerializer componentSelectionReasonSerializer) {
        ResolvedVariantResultSerializer resolvedVariantResultSerializer = new ResolvedVariantResultSerializer(componentIdentifierSerializer, attributeContainerSerializer);
        return new ResolvedComponentResultSerializer(moduleVersionIdentifierSerializer, (Serializer<ComponentIdentifier>)componentIdentifierSerializer, (Serializer<ComponentSelector>)componentSelectorSerializer, resolvedVariantResultSerializer, componentSelectionReasonSerializer);
    }

    private static class OpaqueComponentArtifactIdentifierSerializer
    implements Serializer<OpaqueComponentArtifactIdentifier> {
        private OpaqueComponentArtifactIdentifierSerializer() {
        }

        public OpaqueComponentArtifactIdentifier read(Decoder decoder) throws Exception {
            return new OpaqueComponentArtifactIdentifier(new File(decoder.readString()));
        }

        public void write(Encoder encoder, OpaqueComponentArtifactIdentifier value) throws Exception {
            encoder.writeString((CharSequence)value.getFile().getCanonicalPath());
        }
    }
}

