/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.problems;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Comparators;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.cc.impl.problems.ConfigurationCacheProblemsSummaryKt;
import org.gradle.internal.cc.impl.problems.ProblemCause;
import org.gradle.internal.cc.impl.problems.ProblemSeverity;
import org.gradle.internal.configuration.problems.DocumentationSection;
import org.gradle.internal.extensions.stdlib.CharSequenceExtensionsKt;
import org.gradle.internal.logging.ConsoleRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0(H\u0002J\u0018\u0010)\u001a\u00020**\u00060+j\u0002`,2\u0006\u0010-\u001a\u00020#H\u0002J\u0010\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u00020&H\u0002J\u0018\u00100\u001a\n 1*\u0004\u0018\u00010#0#2\u0006\u00102\u001a\u00020&H\u0002J\u0017\u00103\u001a\u0004\u0018\u00010\t2\u0006\u00104\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b5R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u00038\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\u0016\u00a8\u00066"}, d2={"Lorg/gradle/internal/cc/impl/problems/Summary;", "", "totalProblemCount", "", "consoleProblemCount", "deferredProblemCount", "consoleProblemCauses", "", "Lorg/gradle/internal/cc/impl/problems/ProblemCause;", "Lorg/gradle/internal/cc/impl/problems/ProblemSeverity;", "reportUniqueProblemCount", "originalProblemExceptions", "", "", "overflowed", "", "maxCollectedProblems", "incompatibleTasksCount", "incompatibleFeatureCount", "<init>", "(IIILjava/util/Map;ILjava/util/List;ZIII)V", "getTotalProblemCount", "()I", "getConsoleProblemCount", "getDeferredProblemCount", "getReportUniqueProblemCount$configuration_cache", "getOriginalProblemExceptions", "()Ljava/util/List;", "getOverflowed$configuration_cache", "()Z", "consoleUniqueProblemCount", "getConsoleUniqueProblemCount$configuration_cache$annotations", "()V", "getConsoleUniqueProblemCount$configuration_cache", "textForConsole", "", "cacheActionText", "htmlReportFile", "Ljava/io/File;", "topProblemsForConsole", "Lkotlin/sequences/Sequence;", "appendSummaryHeader", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "cacheAction", "buildSummaryReportLink", "reportFile", "clickableUrlFor", "kotlin.jvm.PlatformType", "file", "severityFor", "of", "severityFor$configuration_cache", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nConfigurationCacheProblemsSummary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheProblemsSummary.kt\norg/gradle/internal/cc/impl/problems/Summary\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,439:1\n32#2,2:440\n*S KotlinDebug\n*F\n+ 1 ConfigurationCacheProblemsSummary.kt\norg/gradle/internal/cc/impl/problems/Summary\n*L\n297#1:440,2\n*E\n"})
public final class Summary {
    private final int totalProblemCount;
    private final int consoleProblemCount;
    private final int deferredProblemCount;
    @NotNull
    private final Map<ProblemCause, ProblemSeverity> consoleProblemCauses;
    private final int reportUniqueProblemCount;
    @NotNull
    private final List<Throwable> originalProblemExceptions;
    private final boolean overflowed;
    private final int maxCollectedProblems;
    private final int incompatibleTasksCount;
    private final int incompatibleFeatureCount;
    private final int consoleUniqueProblemCount;

    public Summary(int totalProblemCount, int consoleProblemCount, int deferredProblemCount, @NotNull Map<ProblemCause, ? extends ProblemSeverity> consoleProblemCauses, int reportUniqueProblemCount, @NotNull List<? extends Throwable> originalProblemExceptions, boolean overflowed, int maxCollectedProblems, int incompatibleTasksCount, int incompatibleFeatureCount) {
        Intrinsics.checkNotNullParameter(consoleProblemCauses, (String)"consoleProblemCauses");
        Intrinsics.checkNotNullParameter(originalProblemExceptions, (String)"originalProblemExceptions");
        this.totalProblemCount = totalProblemCount;
        this.consoleProblemCount = consoleProblemCount;
        this.deferredProblemCount = deferredProblemCount;
        this.consoleProblemCauses = consoleProblemCauses;
        this.reportUniqueProblemCount = reportUniqueProblemCount;
        this.originalProblemExceptions = originalProblemExceptions;
        this.overflowed = overflowed;
        this.maxCollectedProblems = maxCollectedProblems;
        this.incompatibleTasksCount = incompatibleTasksCount;
        this.incompatibleFeatureCount = incompatibleFeatureCount;
        this.consoleUniqueProblemCount = this.consoleProblemCauses.size();
    }

    public final int getTotalProblemCount() {
        return this.totalProblemCount;
    }

    public final int getConsoleProblemCount() {
        return this.consoleProblemCount;
    }

    public final int getDeferredProblemCount() {
        return this.deferredProblemCount;
    }

    @VisibleForTesting
    public final int getReportUniqueProblemCount$configuration_cache() {
        return this.reportUniqueProblemCount;
    }

    @NotNull
    public final List<Throwable> getOriginalProblemExceptions() {
        return this.originalProblemExceptions;
    }

    public final boolean getOverflowed$configuration_cache() {
        return this.overflowed;
    }

    public final int getConsoleUniqueProblemCount$configuration_cache() {
        return this.consoleUniqueProblemCount;
    }

    @VisibleForTesting
    public static /* synthetic */ void getConsoleUniqueProblemCount$configuration_cache$annotations() {
    }

    @NotNull
    public final String textForConsole(@NotNull String cacheActionText, @Nullable File htmlReportFile) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)cacheActionText, (String)"cacheActionText");
        DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        StringBuilder $this$textForConsole_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Iterator topConsoleProblems = this.topProblemsForConsole().iterator();
        boolean hasConsoleProblems = topConsoleProblems.hasNext();
        if (hasConsoleProblems) {
            $this$textForConsole_u24lambda_u240.append('\n');
            this.appendSummaryHeader($this$textForConsole_u24lambda_u240, cacheActionText);
            $this$textForConsole_u24lambda_u240.append('\n');
            Iterator $this$forEach$iv = topConsoleProblems;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                DocumentationSection it;
                Object element$iv = iterator.next();
                ProblemCause problem = (ProblemCause)element$iv;
                boolean bl2 = false;
                $this$textForConsole_u24lambda_u240.append("- ");
                $this$textForConsole_u24lambda_u240.append(CharSequenceExtensionsKt.capitalized((CharSequence)problem.getUserCodeLocation()));
                $this$textForConsole_u24lambda_u240.append(": ");
                $this$textForConsole_u24lambda_u240.append(problem.getMessage()).append('\n');
                if (problem.getDocumentationSection() == null) continue;
                boolean bl3 = false;
                $this$textForConsole_u24lambda_u240.append("  See " + documentationRegistry.getDocumentationFor(it.getPage(), it.getAnchor())).append('\n');
            }
            int notShown = this.consoleUniqueProblemCount - 15;
            if (notShown > 0) {
                String problemStr = notShown > 1 ? "problems" : "problem";
                $this$textForConsole_u24lambda_u240.append("plus " + notShown + " more " + problemStr + ". Please see the report for details.").append('\n');
            }
        }
        boolean hasIncompatibleTasks = this.incompatibleTasksCount > 0;
        boolean hasIncompatibleFeatures = this.incompatibleFeatureCount > 0;
        File file = htmlReportFile;
        if (file != null) {
            File it = file;
            boolean bl4 = false;
            $this$textForConsole_u24lambda_u240.append('\n');
            if ((hasIncompatibleTasks || hasIncompatibleFeatures) && !hasConsoleProblems) {
                $this$textForConsole_u24lambda_u240.append("Some tasks or features in this build are not compatible with the configuration cache.");
                $this$textForConsole_u24lambda_u240.append('\n');
            }
            $this$textForConsole_u24lambda_u240.append(this.buildSummaryReportLink(it));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String textForConsole$default(Summary summary, String string, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return summary.textForConsole(string, file);
    }

    private final Sequence<ProblemCause> topProblemsForConsole() {
        Object r = this.consoleProblemCauses.entrySet().stream().collect(Comparators.least((int)15, (Comparator)ConfigurationCacheProblemsSummaryKt.access$consoleComparatorForProblemCauseWithSeverity()));
        Intrinsics.checkNotNullExpressionValue(r, (String)"collect(...)");
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)r)), Summary::topProblemsForConsole$lambda$0);
    }

    private final void appendSummaryHeader(StringBuilder $this$appendSummaryHeader, String cacheAction) {
        $this$appendSummaryHeader.append(this.consoleProblemCount);
        $this$appendSummaryHeader.append(this.consoleProblemCount == 1 ? " problem was found " : " problems were found ");
        $this$appendSummaryHeader.append(cacheAction);
        $this$appendSummaryHeader.append(" the configuration cache");
        if (this.overflowed) {
            $this$appendSummaryHeader.append(", only the first ");
            $this$appendSummaryHeader.append(this.maxCollectedProblems);
            $this$appendSummaryHeader.append(" were considered");
        }
        if (this.consoleUniqueProblemCount != this.consoleProblemCount) {
            $this$appendSummaryHeader.append(", ");
            $this$appendSummaryHeader.append(this.consoleUniqueProblemCount);
            $this$appendSummaryHeader.append(" of which ");
            $this$appendSummaryHeader.append(this.consoleUniqueProblemCount == 1 ? "seems unique" : "seem unique");
        }
        $this$appendSummaryHeader.append(".");
    }

    private final String buildSummaryReportLink(File reportFile) {
        return "See the complete report at " + this.clickableUrlFor(reportFile);
    }

    private final String clickableUrlFor(File file) {
        return new ConsoleRenderer().asClickableFileUrl(file);
    }

    @VisibleForTesting
    @Nullable
    public final ProblemSeverity severityFor$configuration_cache(@NotNull ProblemCause of) {
        Intrinsics.checkNotNullParameter((Object)of, (String)"of");
        return this.consoleProblemCauses.get(of.asShallow());
    }

    private static final ProblemCause topProblemsForConsole$lambda$0(Map.Entry it) {
        return (ProblemCause)it.getKey();
    }
}

