/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.util.internal.CollectionUtils;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class GUtil {
    private static final Pattern UPPER_LOWER = Pattern.compile("(?m)([A-Z]*)([a-z0-9]*)");

    public static <T extends Collection<?>> T flatten(Object[] elements, T addTo, boolean flattenMaps) {
        return GUtil.flatten(Arrays.asList(elements), addTo, flattenMaps);
    }

    public static <T extends Collection<?>> T flatten(Object[] elements, T addTo) {
        return GUtil.flatten(Arrays.asList(elements), addTo);
    }

    public static <T extends Collection<?>> T flatten(Collection<?> elements, T addTo) {
        return GUtil.flatten(elements, addTo, true);
    }

    public static <T extends Collection<?>> T flattenElements(Object ... elements) {
        LinkedList out = new LinkedList();
        GUtil.flatten(elements, out, true);
        return (T)((Collection)Cast.uncheckedNonnullCast(out));
    }

    public static <T extends Collection<?>> T flatten(Collection<?> elements, T addTo, boolean flattenMapsAndArrays) {
        return GUtil.flatten(elements, addTo, flattenMapsAndArrays, flattenMapsAndArrays);
    }

    public static <T extends Collection<?>> T flatten(Collection<?> elements, T addTo, boolean flattenMaps, boolean flattenArrays) {
        for (Object element : elements) {
            if (element instanceof Collection) {
                GUtil.flatten((Collection)element, addTo, flattenMaps, flattenArrays);
                continue;
            }
            if (element instanceof Map && flattenMaps) {
                GUtil.flatten(((Map)element).values(), addTo, flattenMaps, flattenArrays);
                continue;
            }
            if (element.getClass().isArray() && flattenArrays) {
                GUtil.flatten(Arrays.asList((Object[])element), addTo, flattenMaps, flattenArrays);
                continue;
            }
            ((Collection)Cast.uncheckedNonnullCast(addTo)).add(element);
        }
        return addTo;
    }

    public static Collection<?> collectionize(Object input) {
        if (input == null) {
            return Collections.emptyList();
        }
        if (input instanceof Collection) {
            LinkedList out = new LinkedList();
            GUtil.flatten((Collection)input, out, false, true);
            return out;
        }
        if (input.getClass().isArray()) {
            LinkedList out = new LinkedList();
            GUtil.flatten(Arrays.asList((Object[])input), out, false, true);
            return out;
        }
        return Arrays.asList(input);
    }

    public static List<Object> flatten(Collection<Object> elements, boolean flattenMapsAndArrays) {
        return GUtil.flatten(elements, new ArrayList(), flattenMapsAndArrays);
    }

    public static List<Object> flatten(Collection<Object> elements) {
        return GUtil.flatten(elements, new ArrayList());
    }

    public static String asPath(Iterable<?> collection) {
        return CollectionUtils.join((String)File.pathSeparator, collection);
    }

    public static List<String> prefix(String prefix, Collection<String> strings) {
        ArrayList<String> prefixed = new ArrayList<String>();
        for (String string : strings) {
            prefixed.add(prefix + string);
        }
        return prefixed;
    }

    public static boolean isTrue(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() > 0;
        }
        if (object instanceof String) {
            return ((String)object).length() > 0;
        }
        return true;
    }

    public static <T> @Nullable T elvis(@Nullable T object, @Nullable T defaultValue) {
        return GUtil.isTrue(object) ? object : defaultValue;
    }

    public static <T> @Nullable T getOrDefault(@Nullable T object, Factory<T> defaultValueSupplier) {
        return (T)(GUtil.isTrue(object) ? object : defaultValueSupplier.create());
    }

    public static <V, T extends Collection<? super V>> T addToCollection(T dest, boolean failOnNull, Iterable<? extends V> src) {
        for (V v : src) {
            if (failOnNull && v == null) {
                throw new IllegalArgumentException("Illegal null value provided in this collection: " + src);
            }
            dest.add(v);
        }
        return dest;
    }

    public static <V, T extends Collection<? super V>> T addToCollection(T dest, Iterable<? extends V> src) {
        return GUtil.addToCollection(dest, false, src);
    }

    public static Comparator<String> caseInsensitive() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int diff = o1.compareToIgnoreCase(o2);
                if (diff != 0) {
                    return diff;
                }
                return o1.compareTo(o2);
            }
        };
    }

    public static <K, V> Map<K, V> addMaps(Map<K, V> map1, Map<K, V> map2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.putAll(map1);
        map.putAll(map2);
        return map;
    }

    public static void addToMap(Map<String, String> dest, Map<?, ?> src) {
        for (Map.Entry<?, ?> entry : src.entrySet()) {
            dest.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    public static Properties loadProperties(File propertyFile) {
        Properties properties;
        FileInputStream inputStream = new FileInputStream(propertyFile);
        try {
            properties = GUtil.loadProperties(inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }
        inputStream.close();
        return properties;
    }

    public static Properties loadProperties(URL url) {
        try {
            URLConnection uc = url.openConnection();
            uc.setUseCaches(false);
            return GUtil.loadProperties(uc.getInputStream());
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static Properties loadProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            IoActions.closeQuietly(inputStream);
        }
        return properties;
    }

    public static void saveProperties(Properties properties, File propertyFile) {
        try (FileOutputStream propertiesFileOutputStream = new FileOutputStream(propertyFile);){
            properties.store(propertiesFileOutputStream, null);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static void saveProperties(Properties properties, OutputStream outputStream) {
        try {
            try {
                properties.store(outputStream, null);
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public static Map<Object, Object> map(Object ... objects) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        assert (objects.length % 2 == 0);
        for (int i = 0; i < objects.length; i += 2) {
            map.put(objects[i], objects[i + 1]);
        }
        return map;
    }

    public static String toString(Iterable<?> names) {
        Formatter formatter = new Formatter();
        boolean first = true;
        for (Object name : names) {
            if (first) {
                formatter.format("'%s'", name);
                first = false;
                continue;
            }
            formatter.format(", '%s'", name);
        }
        return formatter.toString();
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String toConstant(@Nullable CharSequence string) {
        if (string == null) {
            return null;
        }
        return GUtil.toWords(string, '_').toUpperCase(Locale.ROOT);
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String toWords(@Nullable CharSequence string) {
        return GUtil.toWords(string, ' ');
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static @Nullable String toWords(@Nullable CharSequence string, char separator) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int pos = 0;
        Matcher matcher = UPPER_LOWER.matcher(string);
        while (pos < string.length()) {
            matcher.find(pos);
            if (matcher.end() == pos) {
                ++pos;
                continue;
            }
            if (builder.length() > 0) {
                builder.append(separator);
            }
            String group1 = matcher.group(1).toLowerCase(Locale.ROOT);
            String group2 = matcher.group(2);
            if (group2.length() == 0) {
                builder.append(group1);
            } else {
                if (group1.length() > 1) {
                    builder.append(group1.substring(0, group1.length() - 1));
                    builder.append(separator);
                    builder.append(group1.substring(group1.length() - 1));
                } else {
                    builder.append(group1);
                }
                builder.append(group2);
            }
            pos = matcher.end();
        }
        return builder.toString();
    }

    public static <T> Comparator<T> last(final Comparator<? super T> comparator, final T lastValue) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                boolean o2Last;
                boolean o1Last = comparator.compare(o1, lastValue) == 0;
                boolean bl = o2Last = comparator.compare(o2, lastValue) == 0;
                if (o1Last && o2Last) {
                    return 0;
                }
                if (o1Last && !o2Last) {
                    return 1;
                }
                if (!o1Last && o2Last) {
                    return -1;
                }
                return comparator.compare(o1, o2);
            }
        };
    }

    public static <T extends Enum<T>> T toEnum(Class<? extends T> enumType, Object value) {
        if (enumType.isInstance(value)) {
            return (T)((Enum)enumType.cast(value));
        }
        if (value instanceof CharSequence) {
            String literal = value.toString();
            T match = GUtil.findEnumValue(enumType, literal);
            if (match != null) {
                return match;
            }
            String alternativeLiteral = GUtil.toWords(literal, '_');
            match = GUtil.findEnumValue(enumType, alternativeLiteral);
            if (match != null) {
                return match;
            }
            throw new IllegalArgumentException(String.format("Cannot convert string value '%s' to an enum value of type '%s' (valid case insensitive values: %s)", literal, enumType.getName(), CollectionUtils.join((String)", ", (Iterable)CollectionUtils.collect(Arrays.asList((Enum[])enumType.getEnumConstants()), Enum::name))));
        }
        throw new IllegalArgumentException(String.format("Cannot convert value '%s' of type '%s' to enum type '%s'", value, value.getClass().getName(), enumType.getName()));
    }

    private static <T extends Enum<T>> @Nullable T findEnumValue(Class<? extends T> enumType, final String literal) {
        List<Enum> enumConstants = Arrays.asList((Enum[])enumType.getEnumConstants());
        return (T)((Enum)CollectionUtils.findFirst(enumConstants, (Spec)new Spec<T>(){

            public boolean isSatisfiedBy(T enumValue) {
                return ((Enum)enumValue).name().equalsIgnoreCase(literal);
            }
        }));
    }

    public static <T extends Enum<T>> EnumSet<T> toEnumSet(Class<T> enumType, Object[] values) {
        return GUtil.toEnumSet(enumType, Arrays.asList(values));
    }

    public static <T extends Enum<T>> EnumSet<T> toEnumSet(Class<T> enumType, Iterable<?> values) {
        EnumSet<T> result = EnumSet.noneOf(enumType);
        for (Object value : values) {
            result.add(GUtil.toEnum(enumType, value));
        }
        return result;
    }

    public static boolean endsWith(CharSequence longer, CharSequence shorter) {
        int shorterLength;
        if (longer instanceof String && shorter instanceof String) {
            return ((String)longer).endsWith((String)shorter);
        }
        int longerLength = longer.length();
        if (longerLength < (shorterLength = shorter.length())) {
            return false;
        }
        for (int i = shorterLength; i > 0; --i) {
            if (longer.charAt(longerLength - i) == shorter.charAt(shorterLength - i)) continue;
            return false;
        }
        return true;
    }

    public static URI toSecureUrl(URI scriptUri) {
        try {
            return new URI("https", null, scriptUri.getHost(), scriptUri.getPort(), scriptUri.getPath(), scriptUri.getQuery(), scriptUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("could not make url use https", e);
        }
    }

    public static boolean isSecureUrl(URI url) {
        if ("127.0.0.1".equals(url.getHost())) {
            return true;
        }
        String scheme = url.getScheme();
        return !"http".equalsIgnoreCase(scheme);
    }
}

