/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.gradle.internal.collect.ArrayCopy;
import org.gradle.internal.collect.ChampDeletion;
import org.gradle.internal.collect.ChampIterator;
import org.gradle.internal.collect.ChampLookup;
import org.gradle.internal.collect.ChampNode;
import org.gradle.internal.collect.HashCollisionNode;
import org.gradle.internal.collect.Modification;
import org.gradle.internal.collect.PersistentMap;
import org.gradle.internal.collect.PersistentMap1;
import org.gradle.internal.collect.PersistentMapEntry;
import org.gradle.internal.collect.Preconditions;
import org.gradle.internal.collect.ToString;
import org.jspecify.annotations.Nullable;

final class PersistentMapTrie<K, V>
implements PersistentMap<K, V> {
    private final ChampNode<K> root;
    private final int size;
    private final int hashCode;

    private PersistentMapTrie(ChampNode<K> root, int size, int hashCode) {
        assert (size >= 2);
        this.root = root;
        this.size = size;
        this.hashCode = hashCode;
    }

    @Override
    public PersistentMap<K, V> assoc(K key, V value) {
        Preconditions.entryCannotBeNull(key, value);
        int hash = key.hashCode();
        Modification modification = new Modification(Modification.Kind.INSERT);
        ChampNode<K> newRoot = PersistentMapTrie.insertInto(this.root, key, hash, value, 0, modification);
        if (modification.kind == Modification.Kind.UPDATE) {
            return new PersistentMapTrie<K, V>(newRoot, this.size, this.hashCode);
        }
        if (newRoot == this.root) {
            return this;
        }
        return new PersistentMapTrie<K, V>(newRoot, this.size + 1, this.hashCode + hash);
    }

    @Override
    public PersistentMap<K, V> dissoc(K key) {
        int hash = key.hashCode();
        return this.dissoc(key, hash);
    }

    @Override
    public PersistentMap<K, V> modify(K key, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> function) {
        int hash = key.hashCode();
        Modification modification = new Modification(Modification.Kind.INSERT);
        ChampNode<? super K> newRoot = PersistentMapTrie.modify(this.root, key, hash, function, 0, modification);
        switch (modification.kind) {
            case UPDATE: {
                return new PersistentMapTrie<K, V>(newRoot, this.size, this.hashCode);
            }
            case REMOVAL: {
                return this.dissoc(key, hash);
            }
        }
        return newRoot == this.root ? this : new PersistentMapTrie<K, V>(newRoot, this.size + 1, this.hashCode + hash);
    }

    private PersistentMap<K, V> dissoc(K key, int hash) {
        ChampNode<K> newRoot = ChampDeletion.deleteFrom(this.root, key, hash, 0, 1);
        if (newRoot == this.root) {
            return this;
        }
        int newSize = this.size - 1;
        if (newSize == 1) {
            Object[] content = newRoot.content;
            return new PersistentMap1<Object, Object>(content[0], content[1]);
        }
        return new PersistentMapTrie<K, V>(newRoot, newSize, this.hashCode - hash);
    }

    @Override
    public @Nullable V get(K key) {
        return (V)ChampLookup.lookup(this.root, key, 1, null, (content, index) -> content[index + 1]);
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        return (V)ChampLookup.lookup(this.root, key, 1, defaultValue, (content, index) -> content[index + 1]);
    }

    @Override
    public boolean containsKey(K key) {
        return ChampLookup.containsKey(this.root, key, 1);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new ChampMapIterator(this.root, this.size);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentMapTrie that = (PersistentMapTrie)o;
        return this.hashCode == that.hashCode && this.root.equals(that.root);
    }

    public String toString() {
        return ToString.nonEmptyIterator('{', this.iterator(), '}');
    }

    static <K, V> PersistentMap<K, V> ofDistinct(K k1, V v1, K k2, V v2) {
        int hash2;
        int hash1 = k1.hashCode();
        ChampNode<K> root = hash1 != (hash2 = k2.hashCode()) ? PersistentMapTrie.branchOnKeys(k1, hash1, v1, k2, hash2, v2, 0, new Modification(Modification.Kind.INSERT)) : new ChampNode(0, 1 << ChampNode.mask(hash1, 0), new Object[]{new HashCollisionNode(hash1, new Object[]{k1, v1, k2, v2})});
        return new PersistentMapTrie<K, V>(root, 2, hash1 + hash2);
    }

    private static <K, V> ChampNode<K> insertInto(ChampNode<K> trie, K key, int hash, V val, int shift, Modification modification) {
        assert (shift < 32);
        int mask = ChampNode.mask(hash, shift);
        int bit = 1 << mask;
        return PersistentMapTrie.insertInto(trie, key, hash, mask, bit, val, shift, modification);
    }

    private static <K, V> ChampNode<K> insertInto(ChampNode<K> trie, K key, int hash, int mask, int bit, V val, int shift, Modification modification) {
        int dataMap = trie.dataMap;
        if ((dataMap & bit) == bit) {
            Object[] content = trie.content;
            int index = ChampNode.index(dataMap, mask, bit);
            int keyIndex = index << 1;
            Object data = content[keyIndex];
            if (data == key || data.equals(key)) {
                int valIndex = keyIndex + 1;
                if (Objects.equals(content[valIndex], val)) {
                    return trie;
                }
                modification.kind = Modification.Kind.UPDATE;
                return trie.replaceContentAt(valIndex, val);
            }
            int dataHash = data.hashCode();
            Object dataVal = content[keyIndex + 1];
            Object newNode = dataHash == hash ? new HashCollisionNode(hash, new Object[]{data, dataVal, key, val}) : PersistentMapTrie.branchOnKeys(key, hash, val, data, dataHash, dataVal, shift + 5, modification);
            return trie.replaceDataWithNode(keyIndex, mask, bit, newNode, 1);
        }
        int nodeMap = trie.nodeMap;
        if ((nodeMap & bit) == bit) {
            Object[] content = trie.content;
            int index = ChampNode.nodeIndex(content, nodeMap, mask, bit);
            Object node = content[index];
            if (node instanceof ChampNode) {
                ChampNode champNode = (ChampNode)node;
                ChampNode<K> newNode = PersistentMapTrie.insertInto(champNode, key, hash, val, shift + 5, modification);
                if (newNode == champNode) {
                    return trie;
                }
                return trie.replaceContentAt(index, newNode);
            }
            HashCollisionNode collision = (HashCollisionNode)node;
            if (collision.hash == hash) {
                HashCollisionNode newCollision = collision.put(key, val, modification);
                if (collision == newCollision) {
                    return trie;
                }
                return trie.replaceContentAt(index, newCollision);
            }
            ChampNode<K> newNode = PersistentMapTrie.branchOnCollision(collision, key, hash, val, shift + 5, modification);
            return trie.replaceContentAt(index, newNode);
        }
        int newDataMap = dataMap | bit;
        int newIndex = ChampNode.index(newDataMap, mask, bit);
        Object[] newContent = ArrayCopy.insertAt(newIndex << 1, trie.content, key, val);
        return new ChampNode(newDataMap, nodeMap, newContent);
    }

    private static <K, V> ChampNode<K> branchOnKeys(K k1, int hash1, V v1, K k2, int hash2, V v2, int shift, Modification modification) {
        int mask2;
        int bit2;
        int mask1 = ChampNode.mask(hash1, shift);
        int bit1 = 1 << mask1;
        if (bit1 != (bit2 = 1 << (mask2 = ChampNode.mask(hash2, shift)))) {
            Object[] objectArray;
            if (mask1 > mask2) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = k2;
                objectArray2[1] = v2;
                objectArray2[2] = k1;
                objectArray = objectArray2;
                objectArray2[3] = v1;
            } else {
                Object[] objectArray3 = new Object[4];
                objectArray3[0] = k1;
                objectArray3[1] = v1;
                objectArray3[2] = k2;
                objectArray = objectArray3;
                objectArray3[3] = v2;
            }
            return new ChampNode(bit1 | bit2, 0, objectArray);
        }
        return PersistentMapTrie.insertInto(new ChampNode(bit1, 0, new Object[]{k1, v1}), k2, hash2, mask2, bit2, v2, shift, modification);
    }

    private static <K, V> ChampNode<K> branchOnCollision(HashCollisionNode collision, K key, int hash, V val, int shift, Modification modification) {
        int collisionMask;
        int collisionBit;
        int keyMask = ChampNode.mask(hash, shift);
        int keyBit = 1 << keyMask;
        if (keyBit != (collisionBit = 1 << (collisionMask = ChampNode.mask(collision.hash, shift)))) {
            return new ChampNode(keyBit, collisionBit, new Object[]{key, val, collision});
        }
        ChampNode node = new ChampNode(0, collisionBit, new Object[]{collision});
        return PersistentMapTrie.insertInto(node, key, hash, keyMask, keyBit, val, shift, modification);
    }

    private static <K, V> ChampNode<K> modify(ChampNode<K> trie, K key, int hash, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> f, int shift, Modification modification) {
        assert (shift < 32);
        int mask = ChampNode.mask(hash, shift);
        int bit = 1 << mask;
        return PersistentMapTrie.modify(trie, key, hash, mask, bit, f, shift, modification);
    }

    private static <K, V> ChampNode<K> modify(ChampNode<K> trie, K key, int hash, int mask, int bit, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> f, int shift, Modification modification) {
        int dataMap = trie.dataMap;
        if ((dataMap & bit) == bit) {
            Object[] content = trie.content;
            int index = ChampNode.index(dataMap, mask, bit);
            int keyIndex = index << 1;
            Object curKey = content[keyIndex];
            if (curKey == key || curKey.equals(key)) {
                int valIndex = keyIndex + 1;
                Object curVal = content[valIndex];
                V newVal = f.apply(key, curVal);
                if (newVal != null) {
                    if (curVal == newVal || curVal.equals(newVal)) {
                        return trie;
                    }
                    modification.kind = Modification.Kind.UPDATE;
                    return trie.replaceContentAt(valIndex, newVal);
                }
                modification.kind = Modification.Kind.REMOVAL;
                return trie;
            }
            int curKeyHash = curKey.hashCode();
            Object curVal = content[keyIndex + 1];
            V newVal = f.apply(key, curVal);
            if (newVal != null) {
                Object newNode = curKeyHash == hash ? new HashCollisionNode(hash, new Object[]{curKey, curVal, key, newVal}) : PersistentMapTrie.branchOnKeys(key, hash, newVal, curKey, curKeyHash, curVal, shift + 5, modification);
                return trie.replaceDataWithNode(keyIndex, mask, bit, newNode, 1);
            }
            return trie;
        }
        int nodeMap = trie.nodeMap;
        if ((nodeMap & bit) == bit) {
            Object[] content = trie.content;
            int index = ChampNode.nodeIndex(content, nodeMap, mask, bit);
            Object node = content[index];
            if (node instanceof ChampNode) {
                ChampNode champNode = (ChampNode)node;
                ChampNode<? super K> newNode = PersistentMapTrie.modify(champNode, key, hash, f, shift + 5, modification);
                if (newNode != champNode) {
                    return trie.replaceContentAt(index, newNode);
                }
                return trie;
            }
            HashCollisionNode collision = (HashCollisionNode)node;
            if (collision.hash != hash) {
                V newVal = f.apply(key, null);
                if (newVal != null) {
                    ChampNode<K> newNode = PersistentMapTrie.branchOnCollision(collision, key, hash, newVal, shift + 5, modification);
                    return trie.replaceContentAt(index, newNode);
                }
                return trie;
            }
            HashCollisionNode newCollision = collision.modify(key, f, modification);
            if (collision != newCollision) {
                return trie.replaceContentAt(index, newCollision);
            }
            return trie;
        }
        V newVal = f.apply(key, null);
        if (newVal != null) {
            int newDataMap = dataMap | bit;
            int newIndex = ChampNode.index(newDataMap, mask, bit);
            Object[] newContent = ArrayCopy.insertAt(newIndex << 1, trie.content, key, newVal);
            return new ChampNode(newDataMap, nodeMap, newContent);
        }
        return trie;
    }

    private static final class ChampMapIterator<K, V>
    extends ChampIterator<Map.Entry<K, V>> {
        public ChampMapIterator(ChampNode<?> root, int size) {
            super(root, size);
        }

        @Override
        protected Map.Entry<K, V> getElement(Object[] content, int index) {
            int keyIndex = index << 1;
            Object key = content[keyIndex];
            Object val = content[keyIndex + 1];
            return new PersistentMapEntry<Object, Object>(key, val);
        }

        @Override
        protected int collisionKeyCount(int keys) {
            return keys >> 1;
        }
    }
}

