/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.classpath.DefaultModuleRegistry;
import org.gradle.api.internal.classpath.EffectiveClassPath;
import org.gradle.api.internal.classpath.Module;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.classpath.UnknownModuleException;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.installation.CurrentGradleInstallation;
import org.gradle.internal.installation.GradleInstallation;
import org.gradle.internal.instrumentation.agent.AgentStatus;
import org.gradle.internal.logging.LoggingManagerFactory;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.NoOpBuildOperationProgressEventEmitter;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.internal.time.Clock;
import org.gradle.testfixtures.internal.TestInMemoryCacheFactory;
import org.jspecify.annotations.Nullable;

public class TestGlobalScopeServices
extends GlobalScopeServices {
    public TestGlobalScopeServices() {
        super(false, AgentStatus.disabled(), CurrentGradleInstallation.locate());
    }

    @Provides
    protected CacheFactory createCacheFactory(FileLockManager fileLockManager, ExecutorFactory executorFactory, BuildOperationRunner buildOperationRunner) {
        return new TestInMemoryCacheFactory();
    }

    @Provides
    protected ModuleRegistry createModuleRegistry(CurrentGradleInstallation currentGradleInstallation) {
        GradleInstallation installation = currentGradleInstallation.getInstallation();
        if (installation == null) {
            ClassPath classpath = DefaultClassPath.of((Collection)new EffectiveClassPath(((Object)((Object)this)).getClass().getClassLoader()).getAsFiles());
            return new MockModuleRegistry(classpath);
        }
        return new DefaultModuleRegistry(installation);
    }

    @Provides
    LoggingManagerInternal createLoggingManager(LoggingManagerFactory loggingManagerFactory) {
        return loggingManagerFactory.createLoggingManager();
    }

    @Provides
    protected BuildOperationProgressEventEmitter createBuildOperationProgressEventEmitter(Clock clock, CurrentBuildOperationRef currentBuildOperationRef, BuildOperationListenerManager listenerManager) {
        return new NoOpBuildOperationProgressEventEmitter();
    }

    private static class MockModuleRegistry
    implements ModuleRegistry,
    Module {
        private final ClassPath classpath;

        public MockModuleRegistry(ClassPath classpath) {
            this.classpath = classpath;
        }

        public Module getExternalModule(String name) throws UnknownModuleException {
            return this;
        }

        public Module getModule(String name) throws UnknownModuleException {
            return this;
        }

        public @Nullable Module findModule(String name) throws UnknownModuleException {
            return this;
        }

        public ClassPath getImplementationClasspath() {
            return this.classpath;
        }

        public ClassPath getRuntimeClasspath() {
            return this.classpath;
        }

        public ClassPath getClasspath() {
            return this.classpath;
        }

        public Set<Module> getRequiredModules() {
            return Collections.emptySet();
        }

        public Set<Module> getAllRequiredModules() {
            return Collections.emptySet();
        }

        public ClassPath getAllRequiredModulesClasspath() {
            return this.classpath;
        }
    }
}

