/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PersistentJvmMetadataDetector
implements JvmMetadataDetector,
Closeable {
    private final JvmMetadataDetector delegate;
    private final PersistentCache cache;
    private final IndexedCache<File, JvmInstallationMetadata> indexedCache;

    public PersistentJvmMetadataDetector(JvmMetadataDetector delegate, CacheBuilder cacheBuilder) {
        this.delegate = delegate;
        this.cache = cacheBuilder.withInitialLockMode(FileLockManager.LockMode.None).open();
        IndexedCacheParameters parameters = IndexedCacheParameters.of((String)"metadata", (Serializer)new FileSerializer(), (Serializer)new JvmInstallationMetadataSerializer());
        this.indexedCache = this.cache.createIndexedCache(parameters);
    }

    @Override
    public JvmInstallationMetadata getMetadata(InstallationLocation javaInstallationLocation) {
        if (javaInstallationLocation.isAutoProvisioned()) {
            return (JvmInstallationMetadata)this.cache.useCache(() -> (JvmInstallationMetadata)this.indexedCache.get((Object)javaInstallationLocation.getLocation(), key -> this.delegate.getMetadata(javaInstallationLocation)));
        }
        return this.delegate.getMetadata(javaInstallationLocation);
    }

    @Override
    public void close() throws IOException {
        this.cache.close();
    }

    private static class FileSerializer
    implements Serializer<File> {
        private FileSerializer() {
        }

        public File read(Decoder decoder) throws Exception {
            return new File(decoder.readString());
        }

        public void write(Encoder encoder, File value) throws Exception {
            encoder.writeString((CharSequence)value.getAbsolutePath());
        }
    }

    private static class JvmInstallationMetadataSerializer
    implements Serializer<JvmInstallationMetadata> {
        private JvmInstallationMetadataSerializer() {
        }

        public JvmInstallationMetadata read(Decoder decoder) throws Exception {
            return JvmInstallationMetadata.from(new File(decoder.readString()), decoder.readString(), decoder.readString(), decoder.readString(), decoder.readString(), decoder.readString(), decoder.readString(), decoder.readString(), decoder.readString());
        }

        public void write(Encoder encoder, JvmInstallationMetadata value) throws Exception {
            encoder.writeString((CharSequence)value.getJavaHome().toString());
            encoder.writeString((CharSequence)value.getJavaVersion());
            encoder.writeString((CharSequence)value.getVendor().getRawVendor());
            encoder.writeString((CharSequence)value.getRuntimeName());
            encoder.writeString((CharSequence)value.getRuntimeVersion());
            encoder.writeString((CharSequence)value.getJvmName());
            encoder.writeString((CharSequence)value.getJvmVersion());
            encoder.writeString((CharSequence)value.getJvmVendor());
            encoder.writeString((CharSequence)value.getArchitecture());
        }
    }
}

