/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gradle.wrapper.DownloadProgressListener;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Logger;

public class Download
implements IDownload {
    public static final String UNKNOWN_VERSION = "0";
    public static final int DEFAULT_NETWORK_TIMEOUT_MILLISECONDS = 10000;
    private static final int BUFFER_SIZE = 10240;
    private static final int PROGRESS_CHUNK = 0x100000;
    private final Logger logger;
    private final String appName;
    private final String appVersion;
    private final DownloadProgressListener progressListener;
    private final Map<String, String> systemProperties;
    private final int networkTimeout;

    public Download(Logger logger, String appName, String appVersion) {
        this(logger, null, appName, appVersion, Download.convertSystemProperties(System.getProperties()));
    }

    public Download(Logger logger, String appName, String appVersion, int networkTimeout) {
        this(logger, null, appName, appVersion, Download.convertSystemProperties(System.getProperties()), networkTimeout);
    }

    private static Map<String, String> convertSystemProperties(Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        return result;
    }

    public Download(Logger logger, DownloadProgressListener progressListener, String appName, String appVersion, Map<String, String> systemProperties) {
        this(logger, progressListener, appName, appVersion, systemProperties, 10000);
    }

    public Download(Logger logger, DownloadProgressListener progressListener, String appName, String appVersion, Map<String, String> systemProperties, int networkTimeout) {
        this.logger = logger;
        this.appName = appName;
        this.appVersion = appVersion;
        this.systemProperties = systemProperties;
        this.progressListener = new DefaultDownloadProgressListener(logger, progressListener);
        this.networkTimeout = networkTimeout;
        this.configureProxyAuthentication();
    }

    private void configureProxyAuthentication() {
        if (this.systemProperties.get("http.proxyUser") != null || this.systemProperties.get("https.proxyUser") != null) {
            Authenticator.setDefault(new ProxyAuthenticator(this.systemProperties));
        }
    }

    public void sendHeadRequest(URI uri) throws Exception {
        URL safeUrl = Download.safeUri(uri).toURL();
        int responseCode = -1;
        try {
            HttpURLConnection conn = (HttpURLConnection)safeUrl.openConnection();
            conn.setRequestMethod("HEAD");
            this.addAuthentication(uri, conn);
            conn.setRequestProperty("User-Agent", this.calculateUserAgent());
            conn.setConnectTimeout(this.networkTimeout);
            conn.connect();
            responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new RuntimeException("HEAD request to " + safeUrl + " failed: response code (" + responseCode + ")");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("HEAD request to " + safeUrl + " failed: response code (" + responseCode + "), timeout (" + this.networkTimeout + "ms)", e);
        }
    }

    @Override
    public void download(URI address, File destination) throws Exception {
        destination.getParentFile().mkdirs();
        this.downloadInternal(address, destination);
    }

    private void downloadInternal(URI address, File destination) throws Exception {
        BufferedOutputStream out = null;
        InputStream in = null;
        URL safeUrl = Download.safeUri(address).toURL();
        try {
            int numRead;
            HttpURLConnection httpConn;
            int responseCode;
            out = new BufferedOutputStream(new FileOutputStream(destination));
            URLConnection conn = safeUrl.openConnection();
            this.addAuthentication(address, conn);
            String userAgentValue = this.calculateUserAgent();
            conn.setRequestProperty("User-Agent", userAgentValue);
            conn.setConnectTimeout(this.networkTimeout);
            conn.setReadTimeout(this.networkTimeout);
            if (conn instanceof HttpURLConnection && (responseCode = (httpConn = (HttpURLConnection)conn).getResponseCode()) != 200) {
                throw new IOException("Server returned HTTP response code: " + responseCode + " for URL: " + safeUrl);
            }
            in = conn.getInputStream();
            byte[] buffer = new byte[10240];
            int totalLength = conn.getContentLength();
            long downloadedLength = 0L;
            long progressCounter = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("Download was interrupted.");
                }
                if ((progressCounter += (long)numRead) / 0x100000L > 0L || (downloadedLength += (long)numRead) == (long)totalLength) {
                    progressCounter -= 0x100000L;
                    this.progressListener.downloadStatusChanged(address, totalLength, downloadedLength);
                }
                ((OutputStream)out).write(buffer, 0, numRead);
            }
        }
        catch (SocketTimeoutException e) {
            throw new IOException("Downloading from " + safeUrl + " failed: timeout (" + this.networkTimeout + "ms)", e);
        }
        finally {
            this.logger.log("");
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    static URI safeUri(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse URI", e);
        }
    }

    private void addAuthentication(URI address, URLConnection connection) throws IOException {
        String token = this.getSystemProperty(address.getHost(), "wrapperToken");
        if (token == null) {
            this.addBasicAuthentication(address, connection);
        } else {
            this.addBearerTokenAuthentication(token, address, connection);
        }
    }

    private void addBasicAuthentication(URI address, URLConnection connection) {
        String userInfo = this.calculateUserInfo(address);
        if (userInfo == null) {
            return;
        }
        if (!"https".equals(address.getScheme())) {
            this.logger.log("WARNING Using HTTP Basic Authentication over an insecure connection to download the Gradle distribution. Please consider using HTTPS.");
        }
        connection.setRequestProperty("Authorization", "Basic " + this.base64Encode(userInfo));
    }

    private void addBearerTokenAuthentication(String token, URI address, URLConnection connection) {
        if (!"https".equals(address.getScheme())) {
            this.logger.log("WARNING Using HTTP Bearer Token Authentication over an insecure connection to download the Gradle distribution. Please consider using HTTPS.");
        }
        connection.setRequestProperty("Authorization", "Bearer " + token);
    }

    private String base64Encode(String userInfo) {
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Method getEncoderMethod = loader.loadClass("java.util.Base64").getMethod("getEncoder", new Class[0]);
            Method encodeMethod = loader.loadClass("java.util.Base64$Encoder").getMethod("encodeToString", byte[].class);
            Object encoder = getEncoderMethod.invoke(null, new Object[0]);
            return (String)encodeMethod.invoke(encoder, new Object[]{userInfo.getBytes("UTF-8")});
        }
        catch (Exception java7OrEarlier) {
            try {
                Method encodeMethod = loader.loadClass("javax.xml.bind.DatatypeConverter").getMethod("printBase64Binary", byte[].class);
                return (String)encodeMethod.invoke(null, new Object[]{userInfo.getBytes("UTF-8")});
            }
            catch (Exception java5OrEarlier) {
                throw new RuntimeException("Downloading Gradle distributions with HTTP Basic Authentication is not supported on your JVM.", java5OrEarlier);
            }
        }
    }

    private String getSystemProperty(String host, String key) {
        if (host != null) {
            String hostEscaped = host.replace('.', '_');
            String hostProperty = this.systemProperties.get("gradle." + hostEscaped + '.' + key);
            if (hostProperty != null) {
                return hostProperty;
            }
        }
        return this.systemProperties.get("gradle." + key);
    }

    private String calculateUserInfo(URI uri) {
        String host = uri.getHost();
        String username = this.getSystemProperty(host, "wrapperUser");
        String password = this.getSystemProperty(host, "wrapperPassword");
        if (username != null && password != null) {
            return username + ':' + password;
        }
        return uri.getUserInfo();
    }

    private String calculateUserAgent() {
        String javaVendor = this.systemProperties.get("java.vendor");
        String javaVersion = this.systemProperties.get("java.version");
        String javaVendorVersion = this.systemProperties.get("java.vm.version");
        String osName = this.systemProperties.get("os.name");
        String osVersion = this.systemProperties.get("os.version");
        String osArch = this.systemProperties.get("os.arch");
        return String.format("%s/%s (%s;%s;%s) (%s;%s;%s)", this.appName, this.appVersion, osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    private static class DefaultDownloadProgressListener
    implements DownloadProgressListener {
        private final Logger logger;
        private final DownloadProgressListener delegate;
        private int previousDownloadPercent;

        public DefaultDownloadProgressListener(Logger logger, DownloadProgressListener delegate) {
            this.logger = logger;
            this.delegate = delegate;
            this.previousDownloadPercent = 0;
        }

        @Override
        public void downloadStatusChanged(URI address, long contentLength, long downloaded) {
            if (contentLength > 0L && this.delegate == null) {
                this.appendPercentageSoFar(contentLength, downloaded);
            }
            if (contentLength != downloaded) {
                this.logger.append(".");
            }
            if (this.delegate != null) {
                this.delegate.downloadStatusChanged(address, contentLength, downloaded);
            }
        }

        private void appendPercentageSoFar(long contentLength, long downloaded) {
            try {
                int currentDownloadPercent = 10 * (this.calculateDownloadPercent(contentLength, downloaded) / 10);
                if (currentDownloadPercent != 0 && this.previousDownloadPercent != currentDownloadPercent) {
                    this.logger.append(String.valueOf(currentDownloadPercent)).append('%');
                    this.previousDownloadPercent = currentDownloadPercent;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private int calculateDownloadPercent(long totalLength, long downloadedLength) {
            return Math.min(100, Math.max(0, (int)((double)downloadedLength / (double)totalLength * 100.0)));
        }
    }

    private static class ProxyAuthenticator
    extends Authenticator {
        private final Map<String, String> systemProperties;

        private ProxyAuthenticator(Map<String, String> systemProperties) {
            this.systemProperties = systemProperties;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String protocol;
            String proxyUser;
            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && (proxyUser = this.systemProperties.get((protocol = this.getRequestingURL().getProtocol()) + ".proxyUser")) != null) {
                String proxyPassword = this.systemProperties.get(protocol + ".proxyPassword");
                if (proxyPassword == null) {
                    proxyPassword = "";
                }
                return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
            }
            return super.getPasswordAuthentication();
        }
    }
}

