/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.gradle.internal.collect.ArrayCopy;
import org.gradle.internal.collect.ChampDeletion;
import org.gradle.internal.collect.ChampIterator;
import org.gradle.internal.collect.ChampLookup;
import org.gradle.internal.collect.ChampNode;
import org.gradle.internal.collect.HashCollisionNode;
import org.gradle.internal.collect.PersistentMap;
import org.gradle.internal.collect.PersistentSet;
import org.gradle.internal.collect.PersistentSet1;
import org.gradle.internal.collect.Preconditions;
import org.gradle.internal.collect.ToString;
import org.jspecify.annotations.Nullable;

final class PersistentSetTrie<K>
implements PersistentSet<K> {
    private final ChampNode<K> root;
    private final int size;
    private final int hashCode;

    private PersistentSetTrie(ChampNode<K> root, int size, int hashCode) {
        assert (size >= 2);
        this.root = root;
        this.size = size;
        this.hashCode = hashCode;
    }

    @Override
    public PersistentSet<K> plus(K key) {
        Preconditions.keyCannotBeNull(key);
        int hash = key.hashCode();
        ChampNode<K> newRoot = PersistentSetTrie.insertInto(this.root, key, hash, 0);
        if (newRoot == this.root) {
            return this;
        }
        return new PersistentSetTrie<K>(newRoot, this.size + 1, this.hashCode + hash);
    }

    @Override
    public PersistentSet<K> minus(K key) {
        int hash = key.hashCode();
        ChampNode<K> newRoot = ChampDeletion.deleteFrom(this.root, key, hash, 0, 0);
        if (newRoot == this.root) {
            return this;
        }
        int newSize = this.size - 1;
        if (newSize == 1) {
            return new PersistentSet1<K>(PersistentSetTrie.singleKeyOf(newRoot));
        }
        return new PersistentSetTrie<K>(newRoot, newSize, this.hashCode - hash);
    }

    @Override
    public PersistentSet<K> minusAll(Iterable<K> keys) {
        if (keys instanceof PersistentSet) {
            return this.except((PersistentSet)keys);
        }
        return this.minusAll(keys.iterator());
    }

    @Override
    public PersistentSet<K> except(PersistentSet<K> other) {
        if (this.equals(other)) {
            return PersistentSet.of();
        }
        return this.minusAll(other.iterator());
    }

    @Override
    private PersistentSet<K> minusAll(Iterator<K> iterator) {
        PersistentSet<K> result = this;
        while (iterator.hasNext() && !result.isEmpty()) {
            result = result.minus(iterator.next());
        }
        return result;
    }

    @Override
    public PersistentSet<K> filter(Predicate<? super K> predicate) {
        PersistentSet<K> ks = this;
        for (K k : this) {
            if (predicate.test(k)) continue;
            ks = ks.minus(k);
        }
        return ks;
    }

    @Override
    public <R> PersistentSet<R> map(Function<? super K, ? extends R> mapper) {
        PersistentSet<R> rs = PersistentSet.of();
        for (K k : this) {
            rs = rs.plus(mapper.apply(k));
        }
        return rs;
    }

    @Override
    public <R> PersistentSet<R> flatMap(Function<? super K, PersistentSet<R>> mapper) {
        PersistentSet rs = PersistentSet.of();
        for (K k : this) {
            rs = rs.union(mapper.apply(k));
        }
        return rs;
    }

    @Override
    public <G> PersistentMap<G, PersistentSet<K>> groupBy(Function<? super K, ? extends @Nullable G> group) {
        PersistentMap<Object, PersistentSet> rs = PersistentMap.of();
        for (Object k : this) {
            G g = group.apply(k);
            if (g == null) continue;
            rs = rs.modify(g, (g1, set) -> set == null ? PersistentSet.of(k) : set.plus(k));
        }
        return rs;
    }

    @Override
    public boolean anyMatch(Predicate<? super K> predicate) {
        for (K k : this) {
            if (!predicate.test(k)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean noneMatch(Predicate<? super K> predicate) {
        for (K k : this) {
            if (!predicate.test(k)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(K key) {
        return ChampLookup.containsKey(this.root, key, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public <S extends K> PersistentSet<K> union(PersistentSet<S> other) {
        if (other.isEmpty()) {
            return this;
        }
        return this.join(other, (smaller, larger) -> {
            for (Object key : smaller) {
                larger = larger.plus(key);
            }
            return larger;
        });
    }

    @Override
    public PersistentSet<K> intersect(PersistentSet<K> other) {
        if (other.isEmpty()) {
            return other;
        }
        return this.join(other, (smaller, larger) -> {
            for (Object key : smaller) {
                if (!larger.contains(key) && (smaller = smaller.minus(key)).isEmpty()) break;
            }
            return smaller;
        });
    }

    private PersistentSet<K> join(PersistentSet<K> other, BiFunction<PersistentSet<K>, PersistentSet<K>, PersistentSet<K>> joinFunction) {
        PersistentSetTrie larger;
        PersistentSetTrie smaller;
        if (this.equals(other)) {
            return this;
        }
        if (this.size > other.size()) {
            smaller = other;
            larger = this;
        } else {
            smaller = this;
            larger = other;
        }
        return joinFunction.apply(smaller, larger);
    }

    @Override
    public Iterator<K> iterator() {
        return new ChampSetIterator<K>(this.root, this.size);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentSetTrie that = (PersistentSetTrie)o;
        return this.hashCode == that.hashCode && this.root.equals(that.root);
    }

    public String toString() {
        return ToString.nonEmptyIterator('{', this.iterator(), '}');
    }

    static <K> PersistentSet<K> ofDistinct(K k1, K k2) {
        int hash2;
        int hash1 = k1.hashCode();
        ChampNode<K> root = hash1 != (hash2 = k2.hashCode()) ? PersistentSetTrie.branchOnKeys(k1, hash1, k2, hash2, 0) : new ChampNode<K>(0, 1 << ChampNode.mask(hash1, 0), new Object[]{new HashCollisionNode(hash1, new Object[]{k1, k2})});
        return new PersistentSetTrie<K>(root, 2, hash1 + hash2);
    }

    private static <K> ChampNode<K> insertInto(ChampNode<K> trie, K key, int hash, int shift) {
        assert (shift < 32);
        int mask = ChampNode.mask(hash, shift);
        int bit = 1 << mask;
        return PersistentSetTrie.insertInto(trie, key, hash, mask, bit, shift);
    }

    private static <K> ChampNode<K> insertInto(ChampNode<K> trie, K key, int hash, int mask, int bit, int shift) {
        int dataMap = trie.dataMap;
        if ((dataMap & bit) == bit) {
            int index = ChampNode.index(dataMap, mask, bit);
            Object curKey = trie.content[index];
            if (curKey == key || curKey.equals(key)) {
                return trie;
            }
            int curKeyHash = curKey.hashCode();
            Object newNode = curKeyHash == hash ? new HashCollisionNode(hash, new Object[]{curKey, key}) : PersistentSetTrie.branchOnKeys(key, hash, curKey, curKeyHash, shift + 5);
            return trie.replaceDataWithNode(index, mask, bit, newNode, 0);
        }
        int nodeMap = trie.nodeMap;
        if ((nodeMap & bit) == bit) {
            Object[] content = trie.content;
            int index = ChampNode.nodeIndex(content, nodeMap, mask, bit);
            Object node = content[index];
            if (node instanceof ChampNode) {
                ChampNode champNode = (ChampNode)node;
                ChampNode<K> newNode = PersistentSetTrie.insertInto(champNode, key, hash, shift + 5);
                if (champNode == newNode) {
                    return trie;
                }
                return trie.replaceContentAt(index, newNode);
            }
            HashCollisionNode collision = (HashCollisionNode)node;
            if (collision.hash == hash) {
                HashCollisionNode newCollision = collision.add(key);
                if (collision == newCollision) {
                    return trie;
                }
                return trie.replaceContentAt(index, newCollision);
            }
            ChampNode<K> newNode = PersistentSetTrie.branchOnCollision(collision, key, hash, shift + 5);
            return trie.replaceContentAt(index, newNode);
        }
        int newDataMap = dataMap | bit;
        int newIndex = ChampNode.index(newDataMap, mask, bit);
        Object[] newContent = ArrayCopy.insertAt(newIndex, trie.content, key);
        return new ChampNode(newDataMap, nodeMap, newContent);
    }

    private static <K> ChampNode<K> branchOnKeys(K k1, int hash1, K k2, int hash2, int shift) {
        int mask2;
        int bit2;
        int mask1 = ChampNode.mask(hash1, shift);
        int bit1 = 1 << mask1;
        if (bit1 != (bit2 = 1 << (mask2 = ChampNode.mask(hash2, shift)))) {
            Object[] objectArray;
            if (mask1 > mask2) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = k2;
                objectArray = objectArray2;
                objectArray2[1] = k1;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = k1;
                objectArray = objectArray3;
                objectArray3[1] = k2;
            }
            return new ChampNode(bit1 | bit2, 0, objectArray);
        }
        return PersistentSetTrie.insertInto(new ChampNode(bit1, 0, new Object[]{k1}), k2, hash2, mask2, bit2, shift);
    }

    private static <K> ChampNode<K> branchOnCollision(HashCollisionNode collision, K key, int hash, int shift) {
        int collisionMask;
        int collisionBit;
        int keyMask = ChampNode.mask(hash, shift);
        int keyBit = 1 << keyMask;
        if (keyBit != (collisionBit = 1 << (collisionMask = ChampNode.mask(collision.hash, shift)))) {
            return new ChampNode(keyBit, collisionBit, new Object[]{key, collision});
        }
        ChampNode node = new ChampNode(0, collisionBit, new Object[]{collision});
        return PersistentSetTrie.insertInto(node, key, hash, keyMask, keyBit, shift);
    }

    private static <K> K singleKeyOf(ChampNode<K> node) {
        Object[] content = node.content;
        assert (content.length == 1);
        return (K)content[0];
    }

    private static final class ChampSetIterator<K>
    extends ChampIterator<K> {
        public ChampSetIterator(ChampNode<K> root, int size) {
            super(root, size);
        }

        @Override
        protected K getElement(Object[] content, int index) {
            return (K)content[index];
        }

        @Override
        protected int collisionKeyCount(int keys) {
            return keys;
        }
    }
}

