/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.gradle.internal.collect.PersistentSet;

final class PersistentSetCollector<K>
implements Collector<K, Accumulator<K>, PersistentSet<K>> {
    static final Collector<?, ?, ?> INSTANCE = new PersistentSetCollector();

    PersistentSetCollector() {
    }

    @Override
    public Supplier<Accumulator<K>> supplier() {
        return Accumulator::new;
    }

    @Override
    public BiConsumer<Accumulator<K>, K> accumulator() {
        return Accumulator::accept;
    }

    @Override
    public BinaryOperator<Accumulator<K>> combiner() {
        return Accumulator::combine;
    }

    @Override
    public Function<Accumulator<K>, PersistentSet<K>> finisher() {
        return Accumulator::finish;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.UNORDERED);
    }

    public static final class Accumulator<K> {
        private PersistentSet<K> set = PersistentSet.of();

        public void accept(K k) {
            this.set = this.set.plus(k);
        }

        public Accumulator<K> combine(Accumulator<K> c2) {
            this.set = this.set.union(c2.set);
            return this;
        }

        public PersistentSet<K> finish() {
            return this.set;
        }
    }
}

