/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gradle.internal.collect.ChampNode;
import org.gradle.internal.collect.HashCollisionNode;
import org.jspecify.annotations.Nullable;

abstract class ChampIterator<K>
implements Iterator<K> {
    private final int count;
    private int index = 0;
    private int nextKey;
    private int nextNode;
    private Object[] content;
    private @Nullable IteratorState<K> parent = null;

    ChampIterator(ChampNode<?> trie, int count) {
        this.nextKey = Integer.bitCount(trie.dataMap);
        this.nextNode = Integer.bitCount(trie.nodeMap);
        this.content = trie.content;
        this.count = count;
    }

    protected abstract K getElement(Object[] var1, int var2);

    protected abstract int collisionKeyCount(int var1);

    @Override
    public final boolean hasNext() {
        return this.index < this.count;
    }

    @Override
    public final K next() {
        if (this.nextKey != 0) {
            return this.nextKey();
        }
        int nextNode = this.nextNode;
        while (true) {
            if (nextNode != 0) {
                Object node = this.content[this.content.length - nextNode--];
                IteratorState<K> iteratorState = this.parent = nextNode != 0 ? new IteratorState<K>(nextNode, this.content, this.parent) : this.parent;
                if (node instanceof ChampNode) {
                    ChampNode champNode = (ChampNode)node;
                    this.content = champNode.content;
                    int nodeMap = champNode.nodeMap;
                    int n = nextNode = nodeMap == -1 ? 32 : Integer.bitCount(nodeMap);
                    int dataMap = champNode.dataMap;
                    if (dataMap == 0) continue;
                    this.nextKey = dataMap == -1 ? 32 : Integer.bitCount(dataMap);
                } else {
                    Object[] keys = ((HashCollisionNode)node).content;
                    this.content = keys;
                    this.nextKey = this.collisionKeyCount(keys.length);
                    nextNode = 0;
                }
                this.nextNode = nextNode;
                return this.nextKey();
            }
            if (this.parent == null) break;
            nextNode = ((IteratorState)this.parent).nextNode;
            this.content = ((IteratorState)this.parent).content;
            this.parent = ((IteratorState)this.parent).parent;
        }
        throw new NoSuchElementException();
    }

    private K nextKey() {
        ++this.index;
        return this.getElement(this.content, --this.nextKey);
    }

    private static final class IteratorState<K> {
        private final int nextNode;
        private final Object[] content;
        private final @Nullable IteratorState<K> parent;

        IteratorState(int nextNode, Object[] content, @Nullable IteratorState<K> parent) {
            this.nextNode = nextNode;
            this.content = content;
            this.parent = parent;
        }
    }
}

