/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.internal.tasks.testing.ClassTestDefinition;
import org.gradle.api.internal.tasks.testing.DefaultTestClassDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.DefaultTestFailure;
import org.gradle.api.internal.tasks.testing.DefaultTestSuiteDescriptor;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.internal.tasks.testing.failure.DefaultThrowableToTestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.TestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.AssertErrorMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.AssertjMultipleAssertionsErrorMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.JUnitComparisonTestFailureMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.OpenTestAssertionFailedMapper;
import org.gradle.api.internal.tasks.testing.failure.mappers.OpenTestMultipleFailuresErrorMapper;
import org.gradle.api.internal.tasks.testing.junit.DescriptionMap;
import org.gradle.api.internal.tasks.testing.junit.DescriptionSet;
import org.gradle.api.internal.tasks.testing.junit.IgnoredTestDescriptorProvider;
import org.gradle.api.internal.tasks.testing.source.DefaultClassSource;
import org.gradle.api.internal.tasks.testing.source.DefaultMethodSource;
import org.gradle.api.internal.tasks.testing.source.DefaultOtherSource;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.api.tasks.testing.source.OtherSource;
import org.gradle.api.tasks.testing.source.TestSource;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

@NullMarked
public class JUnitTestEventAdapter
extends RunListener {
    private static final List<TestFailureMapper> MAPPERS;
    private static final DefaultThrowableToTestFailureMapper FAILURE_MAPPER;
    private static final Pattern DESCRIPTOR_PATTERN;
    private final IdGenerator<?> idGenerator;
    private final TestResultProcessor resultProcessor;
    private final Clock clock;
    private final Deque<TestNode> executingStack = new ArrayDeque<TestNode>();
    private final Map<Thread, Deque<TestNode>> executingStackPerThread = new HashMap<Thread, Deque<TestNode>>();
    private final Set<TestNode> executing = new LinkedHashSet<TestNode>();
    private final DescriptionSet assumptionFailed = new DescriptionSet();
    private boolean testsStarted = false;
    private @Nullable String rootName;
    private @Nullable TestNode rootNode;
    private final DescriptionMap<TestNode, TestNode> descriptionsToDescriptors = new DescriptionMap<TestNode, TestNode>((desc, v) -> v, new DescriptionMap.DescriptionWitness<TestNode, TestNode>(){

        @Override
        public Description getDescription(TestNode wrappedValue) {
            return wrappedValue.description;
        }

        @Override
        public TestNode getValue(TestNode wrappedValue) {
            return wrappedValue;
        }
    });
    private final Map<Description, Integer> descriptionToStartedCount = new LinkedHashMap<Description, Integer>();
    private static final @Nullable Method DESCRIPTION_GET_TEST_CLASS;

    public JUnitTestEventAdapter(TestResultProcessor resultProcessor, Clock clock, IdGenerator<?> idGenerator) {
        this.resultProcessor = resultProcessor;
        this.clock = clock;
        this.idGenerator = idGenerator;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    private @Nullable TestNode getNodeOrNext(Description description) {
        List<TestNode> candidates;
        TestNode unambiguousNode = this.descriptionsToDescriptors.get(description);
        if (unambiguousNode != null) {
            return unambiguousNode;
        }
        int startedCount = this.descriptionToStartedCount.getOrDefault(description, 0);
        if (startedCount >= (candidates = this.descriptionsToDescriptors.getByEquality(description)).size()) {
            return null;
        }
        return candidates.get(startedCount);
    }

    private Deque<TestNode> getExecutingStackForCurrentThread() {
        return this.executingStackPerThread.computeIfAbsent(Thread.currentThread(), t -> new ArrayDeque());
    }

    private @Nullable TestNode getNodeOrCurrent(Description description) {
        TestNode unambiguousNode = this.descriptionsToDescriptors.get(description);
        if (unambiguousNode != null) {
            return unambiguousNode;
        }
        TestNode lastStarted = this.getExecutingStackForCurrentThread().peekLast();
        if (lastStarted != null && lastStarted.description.equals((Object)description)) {
            return lastStarted;
        }
        return null;
    }

    private TestNode getOrRegisterNextNode(Description description, RegistrationMode registrationMode) {
        TestNode node = this.getNodeOrNext(description);
        if (node != null) {
            return node;
        }
        return this.registerNode(description, registrationMode);
    }

    private TestNode registerNode(Description description, RegistrationMode registrationMode) {
        TestNode parent = this.getParentForDynamicRegistration(description);
        TestNode node = this.createNode(parent, description, registrationMode);
        this.descriptionsToDescriptors.put(description, node);
        return node;
    }

    private TestNode getParentForDynamicRegistration(Description description) {
        Description fakeParentDescription;
        TestNode node;
        Class<?> testClass = JUnitTestEventAdapter.getTestClassIfPossible(description);
        if (testClass != null && (node = this.getNodeOrNext(fakeParentDescription = Description.createSuiteDescription(testClass))) != null) {
            return node;
        }
        return this.rootNode;
    }

    private Object startRequiredParentIfNeeded(TestNode node) {
        Object parentId = this.startParentIfNeeded(node);
        if (parentId == null) {
            throw new AssertionError((Object)("No parent found for " + node));
        }
        return parentId;
    }

    private @Nullable Object startParentIfNeeded(TestNode node) {
        TestNode parent = node.parent;
        if (parent == null) {
            return null;
        }
        this.startParentByNodeIfNeeded(parent, this.clock.getCurrentTime());
        return parent.descriptor.getId();
    }

    private void startParentByNodeIfNeeded(TestNode parent, long now) {
        Object grandparentId = this.startParentIfNeeded(parent);
        if (this.executing.contains(parent)) {
            return;
        }
        this.startNode(parent, new TestStartEvent(now, grandparentId));
    }

    private void startNode(TestNode node, TestStartEvent event) {
        this.testsStarted = true;
        this.executing.add(node);
        this.executingStack.addLast(node);
        this.getExecutingStackForCurrentThread().addLast(node);
        this.resultProcessor.started(node.descriptor, event);
        this.descriptionToStartedCount.compute(node.description, (desc, count) -> count == null ? 1 : count + 1);
    }

    private void completeNode(TestNode node, TestCompleteEvent event) {
        this.resultProcessor.completed(node.descriptor.getId(), event);
        this.executing.remove(node);
        this.executingStack.removeLastOccurrence(node);
        this.getExecutingStackForCurrentThread().removeLastOccurrence(node);
    }

    public void testSuiteStarted(Description description) {
        TestNode node = this.getOrRegisterNextNode(description, RegistrationMode.SUITE);
        this.startParentByNodeIfNeeded(node, this.clock.getCurrentTime());
    }

    public void testSuiteFinished(Description description) {
        TestNode node = this.getNodeOrCurrent(description);
        if (node == null || !this.executing.contains(node)) {
            return;
        }
        this.completeNode(node, new TestCompleteEvent(this.clock.getCurrentTime()));
    }

    public void testStarted(Description description) {
        TestNode node = this.getOrRegisterNextNode(description, RegistrationMode.TEST);
        Object parentId = this.startRequiredParentIfNeeded(node);
        this.startNode(node, this.startEvent(parentId));
    }

    public void testFailure(Failure failure) {
        this.addFailure(failure, null, this::reportFailure);
    }

    private void reportFailure(Object descriptorId, Throwable throwable) {
        TestFailure failure = FAILURE_MAPPER.createFailure(throwable);
        this.resultProcessor.failure(descriptorId, failure);
    }

    public void testAssumptionFailure(Failure failure) {
        this.assumptionFailed.add(failure.getDescription());
        this.addFailure(failure, TestResult.ResultType.SKIPPED, this::reportAssumptionFailure);
    }

    private void reportAssumptionFailure(Object descriptorId, Throwable throwable) {
        TestFailure assumptionFailure = DefaultTestFailure.fromTestAssumptionFailure((Throwable)throwable);
        this.resultProcessor.failure(descriptorId, assumptionFailure);
    }

    private void addFailure(Failure failure, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable TestResult.ResultType resultType, BiConsumer<Object, Throwable> reportFailureMethod) {
        TestNode node = this.getNodeOrCurrent(failure.getDescription());
        if (node != null && !node.descriptor.isComposite() && this.executing.contains(node)) {
            reportFailureMethod.accept(node.descriptor.getId(), failure.getException());
        } else {
            this.withPotentiallyMissingParent(JUnitTestEventAdapter.className(failure.getDescription()), this.clock.getCurrentTime(), parentNode -> {
                TestNode newNode = this.registerNode(failure.getDescription(), RegistrationMode.TEST);
                this.startNode(newNode, this.startEvent(((TestNode)parentNode).descriptor.getId()));
                reportFailureMethod.accept(newNode.descriptor.getId(), failure.getException());
                this.completeNode(newNode, new TestCompleteEvent(this.clock.getCurrentTime(), resultType));
            });
        }
    }

    private void withPotentiallyMissingParent(String parentClassName, long now, Consumer<TestNode> action) {
        boolean synthetic;
        TestNode parent = this.startParentMatchingClassName(parentClassName, now);
        boolean bl = synthetic = parent == null;
        if (synthetic) {
            parent = this.getOrRegisterNextNode(Description.createSuiteDescription((String)parentClassName, (Annotation[])new Annotation[0]), RegistrationMode.SUITE);
            this.startNode(parent, this.startEvent(null));
        }
        action.accept(parent);
        if (synthetic) {
            this.completeNode(parent, new TestCompleteEvent(this.clock.getCurrentTime()));
        }
    }

    private @Nullable TestNode startParentMatchingClassName(String className, long now) {
        TestNode parent = this.descriptionsToDescriptors.getFirstMatching(description -> description.isSuite() && JUnitTestEventAdapter.className(description).equals(className));
        if (parent != null) {
            this.startParentByNodeIfNeeded(parent, now);
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExecutionFailure(ClassTestDefinition testClassDefinition, TestFailure failure) {
        try {
            List<TestNode> executingTests = this.executing.stream().filter(t -> !((TestNode)t).descriptor.isComposite()).collect(Collectors.toList());
            if (executingTests.isEmpty()) {
                Description failureDescription;
                String testName = this.testsStarted ? "executionError" : "initializationError";
                TestNode likelyCulprit = this.executingStack.peekLast();
                if (likelyCulprit == null) {
                    Description fakeClassDescription = Description.createSuiteDescription((String)testClassDefinition.getTestClassName(), (Annotation[])new Annotation[0]);
                    failureDescription = Description.createTestDescription((String)testClassDefinition.getTestClassName(), (String)testName, (Annotation[])new Annotation[0]);
                    fakeClassDescription.addChild(failureDescription);
                    this.testRunStarted(fakeClassDescription);
                    likelyCulprit = this.executingStack.getLast();
                } else {
                    failureDescription = Description.createTestDescription((String)likelyCulprit.description.getClassName(), (String)testName, (Annotation[])new Annotation[0]);
                }
                TestNode newNode = this.registerNode(failureDescription, RegistrationMode.TEST);
                this.startNode(newNode, this.startEvent(likelyCulprit.descriptor.getId()));
                this.resultProcessor.failure(newNode.descriptor.getId(), failure);
                this.completeNode(newNode, new TestCompleteEvent(this.clock.getCurrentTime()));
            } else {
                executingTests.forEach(node -> this.resultProcessor.failure(((TestNode)node).descriptor.getId(), failure));
            }
        }
        finally {
            this.handleRunFinished();
        }
    }

    public void testIgnored(Description description) {
        if (JUnitTestEventAdapter.methodName(description) == null) {
            this.processIgnoredClass(description);
        } else {
            TestNode node = this.getOrRegisterNextNode(description, RegistrationMode.DETECTED);
            Object parentId = this.startRequiredParentIfNeeded(node);
            this.startNode(node, this.startEvent(parentId));
            this.completeNode(node, new TestCompleteEvent(this.clock.getCurrentTime(), TestResult.ResultType.SKIPPED));
        }
    }

    private void processIgnoredClass(Description description) {
        TestNode classNode = this.getOrRegisterNextNode(description, RegistrationMode.SUITE);
        this.startParentByNodeIfNeeded(classNode, this.clock.getCurrentTime());
        String className = JUnitTestEventAdapter.className(description);
        for (Description childDescription : IgnoredTestDescriptorProvider.getAllDescriptions(description, className)) {
            TestNode childNode = this.getOrRegisterNextNode(childDescription, RegistrationMode.DETECTED);
            this.startNode(childNode, this.startEvent(classNode.descriptor.getId()));
            this.completeNode(childNode, new TestCompleteEvent(this.clock.getCurrentTime(), TestResult.ResultType.SKIPPED));
        }
    }

    public void testFinished(Description description) {
        long endTime = this.clock.getCurrentTime();
        TestNode node = this.getNodeOrCurrent(description);
        if (node == null || !this.executing.contains(node)) {
            return;
        }
        if (!this.executing.remove(node)) {
            if (this.executing.size() != 1) {
                throw new AssertionError((Object)String.format("Unexpected end event for %s", description));
            }
            node = this.executing.iterator().next();
            this.executing.clear();
        }
        TestResult.ResultType resultType = this.assumptionFailed.remove(description) ? TestResult.ResultType.SKIPPED : null;
        this.completeNode(node, new TestCompleteEvent(endTime, resultType));
    }

    public void testRunStarted(Description description) {
        this.rootNode = new TestNode(null, description, (TestDescriptorInternal)new DefaultTestClassDescriptor(this.idGenerator.generateId(), this.rootName, JUnitTestEventAdapter.classDisplayName(this.rootName)));
        this.addDescriptorAndChildren(description, this.rootNode);
        this.startParentByNodeIfNeeded(this.rootNode, this.clock.getCurrentTime());
    }

    public void testRunFinished(Result result) {
        this.handleRunFinished();
    }

    private void handleRunFinished() {
        TestNode node;
        long now = this.clock.getCurrentTime();
        while ((node = this.executingStack.pollLast()) != null) {
            this.resultProcessor.completed(node.descriptor.getId(), new TestCompleteEvent(now));
        }
        this.executing.clear();
        this.executingStackPerThread.clear();
        this.assumptionFailed.clear();
        this.testsStarted = false;
        this.rootName = null;
        this.rootNode = null;
        this.descriptionsToDescriptors.clear();
        this.descriptionToStartedCount.clear();
    }

    private void addDescriptorAndChildren(Description parent, TestNode parentNode) {
        this.descriptionsToDescriptors.put(parent, parentNode);
        for (Description child : parent.getChildren()) {
            TestNode node = this.createNode(parentNode, child, RegistrationMode.DETECTED);
            this.addDescriptorAndChildren(child, node);
        }
    }

    private static boolean supportsTestClassMethod() {
        return DESCRIPTION_GET_TEST_CLASS != null;
    }

    private static @Nullable Class<?> getTestClassIfPossible(Description description) {
        if (!JUnitTestEventAdapter.supportsTestClassMethod()) {
            return null;
        }
        try {
            return (Class)DESCRIPTION_GET_TEST_CLASS.invoke((Object)description, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("Should always have access to getTestClass when present", e);
        }
    }

    public static @Nullable String methodName(Description description) {
        return JUnitTestEventAdapter.methodName(description.toString());
    }

    public static @Nullable String methodName(String description) {
        Matcher matcher = JUnitTestEventAdapter.methodStringMatcher(description);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String className(Description description) {
        return JUnitTestEventAdapter.className(description.toString());
    }

    public static String className(String description) {
        Matcher matcher = JUnitTestEventAdapter.methodStringMatcher(description);
        return matcher.matches() ? matcher.group(2) : description;
    }

    private static String classDisplayName(String className) {
        int lastDot = className.lastIndexOf(46);
        if (lastDot > 0) {
            return className.substring(lastDot + 1);
        }
        return className;
    }

    private static Matcher methodStringMatcher(String description) {
        return DESCRIPTOR_PATTERN.matcher(description);
    }

    private TestStartEvent startEvent(@Nullable Object parentId) {
        return new TestStartEvent(this.clock.getCurrentTime(), parentId);
    }

    private TestNode createNode(TestNode parent, Description description, RegistrationMode registrationMode) {
        Object descriptor;
        Object id = this.idGenerator.generateId();
        String className = JUnitTestEventAdapter.className(description);
        if (registrationMode == RegistrationMode.SUITE || registrationMode == RegistrationMode.DETECTED && description.isSuite()) {
            descriptor = JUnitTestEventAdapter.supportsTestClassMethod() && JUnitTestEventAdapter.getTestClassIfPossible(description) == null ? new DefaultTestSuiteDescriptor(id, className, (TestSource)DefaultOtherSource.getInstance()) : new DefaultTestClassDescriptor(id, className, JUnitTestEventAdapter.classDisplayName(className), (TestSource)new DefaultClassSource(className));
        } else {
            String methodName = JUnitTestEventAdapter.methodName(description);
            OtherSource testSource = null;
            if (registrationMode != RegistrationMode.TEST) {
                if (JUnitTestEventAdapter.supportsTestClassMethod() && JUnitTestEventAdapter.getTestClassIfPossible(description) == null) {
                    testSource = DefaultOtherSource.getInstance();
                } else if (methodName == null) {
                    testSource = new DefaultClassSource(className);
                }
            }
            if (methodName == null) {
                methodName = "classMethod";
            }
            if (testSource == null) {
                testSource = new DefaultMethodSource(className, methodName);
            }
            descriptor = new DefaultTestDescriptor(id, className, methodName, (TestSource)testSource);
        }
        return new TestNode(parent, description, (TestDescriptorInternal)descriptor);
    }

    static {
        Method getTestClass;
        MAPPERS = Arrays.asList(new JUnitComparisonTestFailureMapper(), new OpenTestAssertionFailedMapper(), new OpenTestMultipleFailuresErrorMapper(), new AssertjMultipleAssertionsErrorMapper(), new AssertErrorMapper());
        FAILURE_MAPPER = new DefaultThrowableToTestFailureMapper(MAPPERS);
        DESCRIPTOR_PATTERN = Pattern.compile("(.*)\\((.*)\\)(\\[\\d+])?", 32);
        try {
            getTestClass = Description.class.getDeclaredMethod("getTestClass", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getTestClass = null;
        }
        DESCRIPTION_GET_TEST_CLASS = getTestClass;
    }

    private static final class TestNode {
        private final @Nullable TestNode parent;
        private final Description description;
        private final TestDescriptorInternal descriptor;

        private TestNode(@Nullable TestNode parent, Description description, TestDescriptorInternal descriptor) {
            this.parent = parent;
            this.description = description;
            this.descriptor = descriptor;
        }

        public String toString() {
            return "TestNode{name=" + this.descriptor.getName() + ",id=" + this.descriptor.getId() + "}";
        }
    }

    private static enum RegistrationMode {
        TEST,
        SUITE,
        DETECTED;

    }
}

