/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.bootstrap;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.instrumentation.agent.AgentInitializer;
import org.gradle.internal.logging.LoggingManagerFactory;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.nativeintegration.ProcessEnvironment;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.remote.Address;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.stream.EncodedStream;
import org.gradle.launcher.bootstrap.EntryPoint;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.daemon.bootstrap.DaemonStartupCommunication;
import org.gradle.launcher.daemon.configuration.DaemonPriority;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.configuration.DefaultDaemonServerConfiguration;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.registry.DaemonDir;
import org.gradle.launcher.daemon.server.Daemon;
import org.gradle.launcher.daemon.server.DaemonLogFile;
import org.gradle.launcher.daemon.server.DaemonProcessState;
import org.gradle.launcher.daemon.server.DaemonStopState;
import org.gradle.launcher.daemon.server.MasterExpirationStrategy;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.process.internal.shutdown.ShutdownHooks;
import org.gradle.util.internal.DefaultGradleVersion;

public class DaemonMain
extends EntryPoint {
    private static final Logger LOGGER = Logging.getLogger(DaemonMain.class);
    private PrintStream originalOut;
    private PrintStream originalErr;
    private static final long FOURTEEN_DAYS_MILLIS = TimeUnit.DAYS.toMillis(14L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAction(String[] args, ExecutionListener listener) {
        DaemonServerConfiguration parameters;
        File gradleHomeDir;
        if (args.length != 1) {
            DaemonMain.invalidArgs();
        }
        try {
            KryoBackedDecoder decoder = new KryoBackedDecoder((InputStream)new EncodedStream.EncodedInput(System.in));
            gradleHomeDir = new File(decoder.readString());
            parameters = DaemonMain.readDaemonServerConfiguration(decoder);
        }
        catch (EOFException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        NativeServices.initializeOnDaemon((File)gradleHomeDir, (NativeServices.NativeServicesMode)NativeServices.NativeServicesMode.fromSystemProperties());
        ServiceRegistry loggingRegistry = LoggingServiceRegistry.newCommandLineProcessLogging();
        LoggingManagerInternal loggingManager = ((LoggingManagerFactory)loggingRegistry.get(LoggingManagerFactory.class)).createLoggingManager();
        DaemonProcessState daemonProcessState = new DaemonProcessState(parameters, loggingRegistry, loggingManager);
        ServiceRegistry daemonServices = daemonProcessState.getServices();
        File daemonLog = ((DaemonLogFile)daemonServices.get(DaemonLogFile.class)).getFile();
        File daemonBaseDir = ((DaemonDir)daemonServices.get(DaemonDir.class)).getBaseDir();
        this.initialiseLogging(loggingManager, daemonLog);
        ProcessEnvironment processEnvironment = (ProcessEnvironment)daemonServices.get(ProcessEnvironment.class);
        processEnvironment.maybeDetachProcess();
        LOGGER.debug("Assuming the daemon was started with following jvm opts: {}", (Object)parameters.getJvmOptions());
        ((AgentInitializer)daemonServices.get(AgentInitializer.class)).maybeConfigureInstrumentationAgent();
        Daemon daemon = (Daemon)daemonServices.get(Daemon.class);
        daemon.start();
        try {
            DaemonContext daemonContext = (DaemonContext)daemonServices.get(DaemonContext.class);
            Long pid = daemonContext.getPid();
            this.daemonStarted(pid, daemon.getUid(), daemon.getAddress(), daemonLog);
            DaemonExpirationStrategy expirationStrategy = (DaemonExpirationStrategy)daemonServices.get(MasterExpirationStrategy.class);
            DaemonStopState stopState = daemon.stopOnExpiration(expirationStrategy, parameters.getPeriodicCheckIntervalMs());
            daemonProcessState.stopped(stopState);
        }
        catch (Throwable throwable) {
            CompositeStoppable.stoppable((Object[])new Object[]{daemon, daemonProcessState}).stop();
            DaemonMain.cleanupOldLogFiles(daemonBaseDir);
            throw throwable;
        }
        CompositeStoppable.stoppable((Object[])new Object[]{daemon, daemonProcessState}).stop();
        DaemonMain.cleanupOldLogFiles(daemonBaseDir);
    }

    private static DaemonServerConfiguration readDaemonServerConfiguration(KryoBackedDecoder decoder) throws EOFException {
        File daemonBaseDir = new File(decoder.readString());
        int idleTimeoutMs = decoder.readSmallInt();
        int periodicCheckIntervalMs = decoder.readSmallInt();
        boolean singleUse = decoder.readBoolean();
        NativeServices.NativeServicesMode nativeServicesMode = NativeServices.NativeServicesMode.values()[decoder.readSmallInt()];
        String daemonUid = decoder.readString();
        DaemonPriority priority = DaemonPriority.values()[decoder.readSmallInt()];
        int argCount = decoder.readSmallInt();
        ArrayList<String> startupJvmOpts = new ArrayList<String>(argCount);
        for (int i = 0; i < argCount; ++i) {
            startupJvmOpts.add(decoder.readString());
        }
        return new DefaultDaemonServerConfiguration(daemonUid, daemonBaseDir, idleTimeoutMs, periodicCheckIntervalMs, singleUse, priority, startupJvmOpts, nativeServicesMode);
    }

    private static void invalidArgs() {
        System.out.println("USAGE: <gradle version>");
        System.out.println("Following arguments are required: <gradle-version>");
        System.exit(1);
    }

    public static void cleanupOldLogFiles(File daemonBaseDir) {
        try {
            File[] daemonLogDirectories = daemonBaseDir.listFiles(file -> file.isDirectory() && DefaultGradleVersion.VERSION_PATTERN.matcher(file.getName()).matches());
            if (daemonLogDirectories == null) {
                LOGGER.warn("Could not list daemon log directories for cleanup in: {}", (Object)daemonBaseDir.getAbsolutePath());
                return;
            }
            long maxAge = System.currentTimeMillis() - FOURTEEN_DAYS_MILLIS;
            for (File daemonLogDirectory : daemonLogDirectories) {
                File[] logFiles = daemonLogDirectory.listFiles(f -> f.isFile() && f.getName().endsWith(".out.log") && f.getName().startsWith("daemon-"));
                if (logFiles == null) {
                    LOGGER.warn("Could not list log files for cleanup in: {}", (Object)daemonLogDirectory.getAbsolutePath());
                    return;
                }
                for (File logFile : logFiles) {
                    if (logFile.equals(daemonBaseDir) || logFile.lastModified() >= maxAge || logFile.delete()) continue;
                    LOGGER.warn("Could not delete old log file: {}", (Object)logFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error cleaning up old log files", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void daemonStarted(Long pid, String uid, Address address, File daemonLog) {
        new DaemonStartupCommunication().printDaemonStarted(this.originalOut, pid, uid, address, daemonLog);
        try {
            this.originalOut.close();
            this.originalErr.close();
        }
        finally {
            this.originalOut = null;
            this.originalErr = null;
        }
    }

    protected void initialiseLogging(LoggingManagerInternal loggingManager, File daemonLog) {
        final PrintStream log = DaemonMain.createLogFile(daemonLog);
        DaemonMain.reducePermissionsOnDaemonLog(daemonLog);
        ShutdownHooks.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                log.println("Daemon vm is shutting down... The daemon has exited normally or was terminated in response to a user interrupt.");
            }
        });
        this.redirectOutputsAndInput(log);
        loggingManager.attachSystemOutAndErr();
        loggingManager.setLevelInternal(LogLevel.DEBUG);
        loggingManager.start();
    }

    private static PrintStream createLogFile(File daemonLog) {
        try {
            com.google.common.io.Files.createParentDirs((File)daemonLog);
            return new PrintStream(Files.newOutputStream(daemonLog.toPath(), new OpenOption[0]), true, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create daemon log file", e);
        }
    }

    private static void reducePermissionsOnDaemonLog(File daemonLog) {
        daemonLog.setReadable(false, false);
        daemonLog.setReadable(true);
        daemonLog.setExecutable(false);
    }

    private void redirectOutputsAndInput(PrintStream printStream) {
        this.originalOut = System.out;
        this.originalErr = System.err;
        System.setOut(printStream);
        System.setErr(printStream);
        System.setIn(new ByteArrayInputStream(new byte[0]));
    }
}

