/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.composite.BuildIncludeListener;
import org.gradle.internal.composite.IncludedBuildInternal;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.plugins.ide.internal.tooling.model.BasicGradleProject;
import org.gradle.plugins.ide.internal.tooling.model.DefaultGradleBuild;
import org.gradle.plugins.ide.internal.tooling.model.PartialBasicGradleProject;
import org.gradle.tooling.internal.gradle.DefaultBuildIdentifier;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.provider.model.internal.BuildScopeModelBuilder;
import org.gradle.tooling.provider.model.internal.ToolingModelBuilderResultInternal;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class GradleBuildBuilder
implements BuildScopeModelBuilder {
    public static final String GRADLE_BUILD_MODEL_NAME = "org.gradle.tooling.model.gradle.GradleBuild";
    private final BuildStateRegistry buildStateRegistry;
    private final BuildIncludeListener failedIncludedBuildsRegistry;
    private final FailureFactory failureFactory;

    public GradleBuildBuilder(BuildStateRegistry buildStateRegistry, BuildIncludeListener failedIncludedBuildsRegistry, FailureFactory failureFactory) {
        this.buildStateRegistry = buildStateRegistry;
        this.failedIncludedBuildsRegistry = failedIncludedBuildsRegistry;
        this.failureFactory = failureFactory;
    }

    public boolean canBuild(String modelName) {
        return GRADLE_BUILD_MODEL_NAME.equals(modelName);
    }

    public ToolingModelBuilderResultInternal create(BuildState target) {
        return new ResilientGradleBuildCreator(target).create();
    }

    protected static BasicGradleProject convert(BuildState owner, ProjectState project, Map<ProjectState, BasicGradleProject> convertedProjects) {
        DefaultProjectIdentifier id = new DefaultProjectIdentifier(owner.getBuildRootDir(), project.getProjectPath().asString());
        BasicGradleProject converted = new BasicGradleProject().setName(project.getName()).setProjectIdentifier(id).setBuildTreePath(project.getIdentityPath().asString()).setProjectDirectory(project.getProjectDir());
        if (project.getParent() != null) {
            converted.setParent(convertedProjects.get(project.getParent()));
        }
        convertedProjects.put(project, converted);
        for (ProjectState child : project.getChildProjects()) {
            converted.addChild(GradleBuildBuilder.convert(owner, child, convertedProjects));
        }
        return converted;
    }

    protected static void addProjects(BuildState target, DefaultGradleBuild model) {
        LinkedHashMap<ProjectState, BasicGradleProject> convertedProjects = new LinkedHashMap<ProjectState, BasicGradleProject>();
        ProjectState rootProject = target.getProjects().getRootProject();
        BasicGradleProject convertedRootProject = GradleBuildBuilder.convert(target, rootProject, convertedProjects);
        model.setRootProject(convertedRootProject);
        for (ProjectState project : target.getProjects().getAllProjects()) {
            model.addProject((PartialBasicGradleProject)convertedProjects.get(project));
        }
    }

    private class ResilientGradleBuildCreator {
        private final BuildState target;
        private final Map<BuildState, DefaultGradleBuild> all = new LinkedHashMap<BuildState, DefaultGradleBuild>();
        private final Collection<Failure> failures = new LinkedHashSet<Failure>();

        ResilientGradleBuildCreator(BuildState target) {
            this.target = target;
        }

        private ToolingModelBuilderResultInternal create() {
            this.ensureProjectsLoaded(this.target);
            DefaultGradleBuild gradleBuild = this.convert(this.target);
            List allFailures = (List)this.failures.stream().distinct().collect(ImmutableList.toImmutableList());
            return ToolingModelBuilderResultInternal.of((Object)gradleBuild, (List)allFailures);
        }

        private void addIncludedBuilds(GradleInternal gradle, DefaultGradleBuild model) {
            for (IncludedBuildInternal reference : gradle.includedBuilds()) {
                BuildState target = reference.getTarget();
                if (target instanceof IncludedBuildState || target instanceof RootBuildState) {
                    model.addIncludedBuild(this.convert(target));
                    continue;
                }
                throw new IllegalStateException("Unknown build type: " + reference.getClass().getName());
            }
        }

        private void addAllImportableBuilds(BuildState targetBuild, GradleInternal gradle, DefaultGradleBuild model) {
            if (gradle.getParent() == null) {
                ArrayList<DefaultGradleBuild> allBuilds = new ArrayList<DefaultGradleBuild>();
                GradleBuildBuilder.this.buildStateRegistry.visitBuilds(buildState -> {
                    if (buildState != targetBuild && buildState.isImportableBuild()) {
                        allBuilds.add(this.convert((BuildState)buildState));
                    }
                });
                model.addBuilds(allBuilds);
            }
        }

        private void ensureProjectsLoaded(BuildState target) {
            try {
                target.ensureProjectsLoaded();
            }
            catch (GradleException e) {
                this.failures.add(GradleBuildBuilder.this.failureFactory.create((Throwable)e));
            }
        }

        private DefaultGradleBuild convert(BuildState targetBuild) {
            DefaultGradleBuild model = this.all.get(targetBuild);
            if (model != null) {
                return model;
            }
            model = new DefaultGradleBuild();
            this.all.put(targetBuild, model);
            this.ensureProjectsLoaded(targetBuild);
            GradleInternal gradle = targetBuild.getMutableModel();
            this.addProjectsAndBuildIdentifier(targetBuild, model);
            try {
                this.addFailedBuilds(targetBuild, model);
                this.addIncludedBuilds(gradle, model);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.addAllImportableBuilds(targetBuild, gradle, model);
            return model;
        }

        private void addProjectsAndBuildIdentifier(BuildState targetBuild, DefaultGradleBuild model) {
            Optional<SettingsInternal> brokenSettingsInternal;
            if (targetBuild.isProjectsLoaded()) {
                GradleBuildBuilder.addProjects(targetBuild, model);
                return;
            }
            Set brokenBuilds = GradleBuildBuilder.this.failedIncludedBuildsRegistry.getBrokenBuilds();
            Set brokenSettings = GradleBuildBuilder.this.failedIncludedBuildsRegistry.getBrokenSettings();
            if (!brokenBuilds.contains(targetBuild) && !brokenSettings.isEmpty() && (brokenSettingsInternal = this.findBrokenSettingsForBuild(targetBuild, brokenSettings)).isPresent()) {
                ProjectDescriptor rootProject = brokenSettingsInternal.get().getRootProject();
                BasicGradleProject root = this.convertRoot(targetBuild, rootProject);
                model.setRootProject(root);
                model.addProject(root);
            }
            if (model.getRootProject() == null && targetBuild instanceof IncludedBuildState && ((IncludedBuildState)targetBuild).getBuildDefinition().getBuildRootDir() != null) {
                model.setBuildIdentifier((BuildIdentifier)new DefaultBuildIdentifier(((IncludedBuildState)targetBuild).getBuildDefinition().getBuildRootDir()));
            }
        }

        private Optional<SettingsInternal> findBrokenSettingsForBuild(BuildState buildState, Set<SettingsInternal> brokenSettings) {
            File buildRootDir = buildState.getBuildRootDir();
            return brokenSettings.stream().filter(settings -> settings.getRootDir().equals(buildRootDir)).findFirst();
        }

        private BasicGradleProject convertRoot(BuildState owner, ProjectDescriptor project) {
            DefaultProjectIdentifier id = new DefaultProjectIdentifier(owner.getBuildRootDir(), project.getPath());
            return new BasicGradleProject().setName(project.getName()).setProjectIdentifier(id).setBuildTreePath(project.getPath()).setProjectDirectory(project.getProjectDir());
        }

        private void addFailedBuilds(BuildState targetBuild, DefaultGradleBuild model) {
            for (BuildState entry : GradleBuildBuilder.this.failedIncludedBuildsRegistry.getBrokenBuilds()) {
                BuildState parent = entry.getParent();
                if (parent == null || !parent.equals(targetBuild)) continue;
                model.addIncludedBuild(this.convert(entry));
            }
        }
    }
}

