/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.function.Consumer;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.RelativePath;

public abstract class TransformExecutionResult {
    protected final ImmutableList<Builder.TransformExecutionOutput> executionOutputs;

    protected TransformExecutionResult(ImmutableList<Builder.TransformExecutionOutput> executionOutputs) {
        this.executionOutputs = executionOutputs;
    }

    public abstract TransformWorkspaceResult resolveForWorkspace(File var1);

    public void visitOutputs(OutputVisitor visitor) {
        this.executionOutputs.forEach(output -> output.visitOutput(visitor));
    }

    public int size() {
        return this.executionOutputs.size();
    }

    public static OutputTypeInferringBuilder builderFor(File inputArtifact, File outputDir) {
        return new OutputTypeInferringBuilder(inputArtifact, outputDir);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static interface OutputVisitor {
        public void visitEntireInputArtifact();

        public void visitPartOfInputArtifact(String var1);

        public void visitProducedOutput(String var1);
    }

    public static class OutputTypeInferringBuilder {
        private final File inputArtifact;
        private final File outputDir;
        private final String inputArtifactPrefix;
        private final String outputDirPrefix;
        private final Builder delegate = TransformExecutionResult.builder();

        public OutputTypeInferringBuilder(File inputArtifact, File outputDir) {
            this.inputArtifact = inputArtifact;
            this.outputDir = outputDir;
            this.inputArtifactPrefix = inputArtifact.getPath() + File.separator;
            this.outputDirPrefix = outputDir.getPath() + File.separator;
        }

        public void addOutput(File output, Consumer<File> workspaceAction) {
            if (output.equals(this.inputArtifact)) {
                this.delegate.addEntireInputArtifact();
            } else if (output.equals(this.outputDir)) {
                this.delegate.addProducedOutput("");
                workspaceAction.accept(output);
            } else if (output.getPath().startsWith(this.outputDirPrefix)) {
                String relativePath = RelativePath.parse((boolean)true, (String)output.getPath().substring(this.outputDirPrefix.length())).getPathString();
                this.delegate.addProducedOutput(relativePath);
                workspaceAction.accept(output);
            } else if (output.getPath().startsWith(this.inputArtifactPrefix)) {
                String relativePath = RelativePath.parse((boolean)true, (String)output.getPath().substring(this.inputArtifactPrefix.length())).getPathString();
                this.delegate.addPartOfInputArtifact(relativePath);
            } else {
                throw new InvalidUserDataException("Transform output " + output.getPath() + " must be a part of the input artifact or refer to a relative path.");
            }
        }

        public TransformExecutionResult build() {
            return this.delegate.build();
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<TransformExecutionOutput> builder = ImmutableList.builder();
        private boolean onlyProducedOutputs = true;

        public void addEntireInputArtifact() {
            this.onlyProducedOutputs = false;
            this.builder.add((Object)EntireInputArtifact.INSTANCE);
        }

        public void addPartOfInputArtifact(String relativePath) {
            this.onlyProducedOutputs = false;
            this.builder.add((Object)new PartOfInputArtifact(relativePath));
        }

        public void addProducedOutput(String relativePath) {
            this.builder.add((Object)new ProducedExecutionOutput(relativePath));
        }

        public TransformExecutionResult build() {
            ImmutableList transformOutputs = this.builder.build();
            return this.onlyProducedOutputs ? new ProducedOutputOnlyResult((ImmutableList<TransformExecutionOutput>)transformOutputs) : new MixedInputAndProducedOutputResult((ImmutableList<TransformExecutionOutput>)transformOutputs);
        }

        private static class EntireInputArtifact
        implements TransformExecutionOutput,
        TransformWorkspaceOutput {
            public static final EntireInputArtifact INSTANCE = new EntireInputArtifact();

            private EntireInputArtifact() {
            }

            @Override
            public TransformWorkspaceOutput resolveForWorkspace(File workspaceDir) {
                return this;
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return inputArtifact;
            }

            @Override
            public void visitOutput(OutputVisitor visitor) {
                visitor.visitEntireInputArtifact();
            }
        }

        private static class PartOfInputArtifact
        implements TransformExecutionOutput,
        TransformWorkspaceOutput {
            private final String relativePath;

            public PartOfInputArtifact(String relativePath) {
                this.relativePath = relativePath;
            }

            @Override
            public TransformWorkspaceOutput resolveForWorkspace(File workspaceDir) {
                return this;
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return new File(inputArtifact, this.relativePath);
            }

            @Override
            public void visitOutput(OutputVisitor visitor) {
                visitor.visitPartOfInputArtifact(this.relativePath);
            }
        }

        private static class ProducedExecutionOutput
        implements TransformExecutionOutput {
            private final String relativePath;

            public ProducedExecutionOutput(String relativePath) {
                this.relativePath = relativePath;
            }

            @Override
            public TransformWorkspaceOutput resolveForWorkspace(File workspaceDir) {
                File workspacePath = this.resolveForWorkspaceDirectly(workspaceDir);
                return inputArtifact -> workspacePath;
            }

            public File resolveForWorkspaceDirectly(File workspaceDir) {
                return new File(workspaceDir, this.relativePath);
            }

            @Override
            public void visitOutput(OutputVisitor visitor) {
                visitor.visitProducedOutput(this.relativePath);
            }
        }

        private static class ProducedOutputOnlyResult
        extends TransformExecutionResult {
            public ProducedOutputOnlyResult(ImmutableList<TransformExecutionOutput> executionOutputs) {
                super(executionOutputs);
            }

            @Override
            public TransformWorkspaceResult resolveForWorkspace(File workspaceDir) {
                ImmutableList resolvedOutputs = (ImmutableList)this.executionOutputs.stream().map(ProducedExecutionOutput.class::cast).map(output -> output.resolveForWorkspaceDirectly(workspaceDir)).collect(ImmutableList.toImmutableList());
                return inputArtifact -> resolvedOutputs;
            }
        }

        private static class MixedInputAndProducedOutputResult
        extends TransformExecutionResult {
            public MixedInputAndProducedOutputResult(ImmutableList<TransformExecutionOutput> executionOutputs) {
                super(executionOutputs);
            }

            @Override
            public TransformWorkspaceResult resolveForWorkspace(File workspaceDir) {
                ImmutableList resolvedOutputs = (ImmutableList)this.executionOutputs.stream().map(output -> output.resolveForWorkspace(workspaceDir)).collect(ImmutableList.toImmutableList());
                return inputArtifact -> (ImmutableList)resolvedOutputs.stream().map(output -> output.resolveForInputArtifact(inputArtifact)).collect(ImmutableList.toImmutableList());
            }
        }

        protected static interface TransformWorkspaceOutput {
            public File resolveForInputArtifact(File var1);
        }

        protected static interface TransformExecutionOutput {
            public TransformWorkspaceOutput resolveForWorkspace(File var1);

            public void visitOutput(OutputVisitor var1);
        }
    }

    public static interface TransformWorkspaceResult {
        public ImmutableList<File> resolveForInputArtifact(File var1);
    }
}

