/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.transform.AbstractTransformExecution;
import org.gradle.api.internal.artifacts.transform.ImmutableTransformExecution;
import org.gradle.api.internal.artifacts.transform.ImmutableTransformWorkspaceServices;
import org.gradle.api.internal.artifacts.transform.MutableTransformExecution;
import org.gradle.api.internal.artifacts.transform.MutableTransformWorkspaceServices;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformExecutionListener;
import org.gradle.api.internal.artifacts.transform.TransformExecutionResult;
import org.gradle.api.internal.artifacts.transform.TransformInvocationFactory;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.cache.Cache;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.buildoption.InternalOption;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.buildoption.StringInternalOption;
import org.gradle.internal.execution.DeferredResult;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.Identity;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.jspecify.annotations.Nullable;

public class DefaultTransformInvocationFactory
implements TransformInvocationFactory {
    private static final InternalOption<@Nullable String> CACHING_DISABLED_PROPERTY = StringInternalOption.of((String)"org.gradle.internal.transform-caching-disabled");
    private final ExecutionEngine executionEngine;
    private final InternalOptions internalOptions;
    private final TransformExecutionListener transformExecutionListener;
    private final ImmutableTransformWorkspaceServices immutableWorkspaceServices;
    private final FileCollectionFactory fileCollectionFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildOperationRunner buildOperationRunner;
    private final BuildOperationProgressEventEmitter progressEventEmitter;

    public DefaultTransformInvocationFactory(ExecutionEngine executionEngine, InternalOptions internalOptions, TransformExecutionListener transformExecutionListener, ImmutableTransformWorkspaceServices immutableWorkspaceServices, FileCollectionFactory fileCollectionFactory, ProjectStateRegistry projectStateRegistry, BuildOperationRunner buildOperationRunner, BuildOperationProgressEventEmitter progressEventEmitter) {
        this.executionEngine = executionEngine;
        this.internalOptions = internalOptions;
        this.transformExecutionListener = transformExecutionListener;
        this.immutableWorkspaceServices = immutableWorkspaceServices;
        this.fileCollectionFactory = fileCollectionFactory;
        this.projectStateRegistry = projectStateRegistry;
        this.buildOperationRunner = buildOperationRunner;
        this.progressEventEmitter = progressEventEmitter;
    }

    @Override
    public Deferrable<Try<ImmutableList<File>>> createInvocation(Transform transform, File inputArtifact, TransformDependencies dependencies, TransformStepSubject subject, InputFingerprinter inputFingerprinter) {
        AbstractTransformExecution execution;
        Cache<Identity, DeferredResult<TransformExecutionResult.TransformWorkspaceResult>> identityCache;
        ProjectInternal producerProject = this.determineProducerProject(subject);
        boolean cachingDisabledByProperty = this.isCachingDisabledByProperty(transform);
        if (producerProject != null && transform.requiresInputChanges()) {
            MutableTransformWorkspaceServices workspaceServices = (MutableTransformWorkspaceServices)producerProject.getServices().get(MutableTransformWorkspaceServices.class);
            identityCache = workspaceServices.getIdentityCache();
            execution = new MutableTransformExecution(transform, inputArtifact, dependencies, subject, producerProject, this.transformExecutionListener, this.buildOperationRunner, this.progressEventEmitter, this.fileCollectionFactory, inputFingerprinter, workspaceServices.getWorkspaceProvider(), workspaceServices.getExecutionHistoryStore(), cachingDisabledByProperty);
        } else {
            identityCache = this.immutableWorkspaceServices.getIdentityCache();
            execution = new ImmutableTransformExecution(transform, inputArtifact, dependencies, subject, this.transformExecutionListener, this.buildOperationRunner, this.progressEventEmitter, this.fileCollectionFactory, inputFingerprinter, this.immutableWorkspaceServices.getWorkspaceProvider(), cachingDisabledByProperty);
        }
        return this.executionEngine.createRequest((UnitOfWork)execution).executeDeferred(identityCache).map(result -> result.map(successfulResult -> successfulResult.resolveForInputArtifact(inputArtifact)).mapFailure(failure -> new TransformException(String.format("Execution failed for %s.", execution.getDisplayName()), (Throwable)failure)));
    }

    private @Nullable ProjectInternal determineProducerProject(TransformStepSubject subject) {
        ComponentIdentifier componentIdentifier = subject.getInitialComponentIdentifier();
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            return this.projectStateRegistry.stateFor((ProjectComponentIdentifier)componentIdentifier).getMutableModel();
        }
        return null;
    }

    private boolean isCachingDisabledByProperty(Transform transform) {
        String experimentalProperty = (String)this.internalOptions.getOption(CACHING_DISABLED_PROPERTY).get();
        if (experimentalProperty != null) {
            if (experimentalProperty.isEmpty() || experimentalProperty.equals("true")) {
                return true;
            }
            List<String> disabledTransformClasses = Arrays.asList(experimentalProperty.split(","));
            return disabledTransformClasses.contains(transform.getImplementationClass().getName());
        }
        return false;
    }
}

