/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.work;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.work.Synchronizer;

public class WaitBuildOperationFiringSynchronizer
implements Synchronizer {
    private final DisplayName targetDescription;
    private final Synchronizer delegate;
    private final BuildOperationRunner buildOperationRunner;

    public WaitBuildOperationFiringSynchronizer(DisplayName targetDescription, Synchronizer delegate, BuildOperationRunner buildOperationRunner) {
        this.targetDescription = targetDescription;
        this.delegate = delegate;
        this.buildOperationRunner = buildOperationRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withLock(final Runnable action) {
        final AtomicBoolean successfulWait = new AtomicBoolean(false);
        final BuildOperationContext buildOperationContext = this.startWaitingOperation();
        try {
            this.delegate.withLock(new Runnable(){

                @Override
                public void run() {
                    successfulWait.set(true);
                    buildOperationContext.setResult(null);
                    action.run();
                }
            });
        }
        finally {
            if (!successfulWait.get()) {
                buildOperationContext.setResult(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withLock(final Factory<T> action) {
        final AtomicBoolean successfulWait = new AtomicBoolean(false);
        final BuildOperationContext buildOperationContext = this.startWaitingOperation();
        try {
            Object t = this.delegate.withLock(new Factory<T>(){

                public T create() {
                    successfulWait.set(true);
                    buildOperationContext.setResult(null);
                    return action.create();
                }
            });
            return t;
        }
        finally {
            if (!successfulWait.get()) {
                buildOperationContext.setResult(null);
            }
        }
    }

    private BuildOperationContext startWaitingOperation() {
        return this.buildOperationRunner.start(BuildOperationDescriptor.displayName((String)("Synchronizer wait: " + this.targetDescription.getDisplayName())));
    }
}

