/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.workers.internal.WorkerDaemonClientsManager;
import org.jspecify.annotations.NullMarked;

@ServiceScope(value={Scope.BuildSession.class})
@NullMarked
public class WorkerDaemonClientCancellationHandler
implements Stoppable {
    private final WorkerDaemonClientsManager workerDaemonClientsManager;
    private final BuildCancellationToken buildCancellationToken;
    private final Runnable cancellationCallback = new KillWorkers();
    private final AtomicBoolean started = new AtomicBoolean();

    public WorkerDaemonClientCancellationHandler(WorkerDaemonClientsManager workerDaemonClientsManager, BuildCancellationToken buildCancellationToken) {
        this.workerDaemonClientsManager = workerDaemonClientsManager;
        this.buildCancellationToken = buildCancellationToken;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.buildCancellationToken.addCallback(this.cancellationCallback);
        }
    }

    public void stop() {
        if (this.started.compareAndSet(true, false)) {
            this.buildCancellationToken.removeCallback(this.cancellationCallback);
        }
    }

    private class KillWorkers
    implements Runnable {
        private KillWorkers() {
        }

        @Override
        public void run() {
            WorkerDaemonClientCancellationHandler.this.workerDaemonClientsManager.killAllWorkers();
        }
    }
}

