/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.internal.service.AnnotatedServiceLifecycleHandler;
import org.gradle.internal.service.ServiceScopeValidatorWorkarounds;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.internal.ArrayUtils;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.Nullable;

class ServiceScopeValidator
implements AnnotatedServiceLifecycleHandler {
    private static final List<Class<? extends Annotation>> SCOPE_ANNOTATIONS = Collections.singletonList(ServiceScope.class);
    private final Class<? extends Scope> scope;
    private final boolean strict;

    public ServiceScopeValidator(Class<? extends Scope> scope, boolean strict) {
        this.scope = scope;
        this.strict = strict;
    }

    public List<Class<? extends Annotation>> getAnnotations() {
        return SCOPE_ANNOTATIONS;
    }

    public Class<? extends Annotation> getImplicitAnnotation() {
        return ServiceScope.class;
    }

    public void whenRegistered(Class<? extends Annotation> annotation, AnnotatedServiceLifecycleHandler.Registration registration) {
        for (Class declaredType : registration.getDeclaredTypes()) {
            this.validateScope(declaredType);
        }
    }

    private void validateScope(Class<?> serviceType) {
        if (ServiceScopeValidator.class.isAssignableFrom(serviceType)) {
            return;
        }
        if (ServiceScopeValidatorWorkarounds.shouldSuppressValidation(serviceType)) {
            return;
        }
        Object[] serviceScopes = ServiceScopeValidator.scopeOf(serviceType);
        if (serviceScopes == null) {
            if (this.strict) {
                this.failWithMissingScope(serviceType);
            }
            return;
        }
        if (serviceScopes.length == 0) {
            throw new IllegalArgumentException(String.format("Service '%s' is declared with empty scope list", serviceType.getName()));
        }
        if (!ArrayUtils.contains((Object[])serviceScopes, this.scope)) {
            throw new IllegalArgumentException(this.invalidScopeMessage(serviceType, (Class<? extends Scope>[])serviceScopes));
        }
    }

    private void failWithMissingScope(Class<?> serviceType) {
        Set<Class<?>> annotatedSupertypes = ServiceScopeValidator.findAnnotatedSupertypes(serviceType);
        if (annotatedSupertypes.size() != 1) {
            throw new IllegalArgumentException(this.missingScopeMessage(serviceType));
        }
        Class<?> inferredServiceType = annotatedSupertypes.iterator().next();
        throw new IllegalArgumentException(this.implementationWithMissingScopeMessage(inferredServiceType, serviceType));
    }

    private static Set<Class<?>> findAnnotatedSupertypes(Class<?> serviceType) {
        LinkedHashSet annotatedSuperTypes = new LinkedHashSet();
        HashSet seen = new HashSet();
        seen.add(Object.class);
        ArrayDeque queue = new ArrayDeque();
        queue.add(serviceType);
        while (!queue.isEmpty()) {
            Class type = (Class)queue.remove();
            if (ServiceScopeValidator.scopeOf(type) != null) {
                annotatedSuperTypes.add(type);
                continue;
            }
            if (type.getSuperclass() != null) {
                queue.add(type.getSuperclass());
            }
            for (Class<?> superInterface : type.getInterfaces()) {
                if (!seen.add(superInterface)) continue;
                queue.add(superInterface);
            }
        }
        return annotatedSuperTypes;
    }

    private String invalidScopeMessage(Class<?> serviceType, Class<? extends Scope>[] actualScopes) {
        return String.format("The service '%s' declares %s but is registered in the '%s' scope. Either update the '@ServiceScope()' annotation on '%s' to include the '%s' scope or move the service registration to one of the declared scopes.", serviceType.getName(), ServiceScopeValidator.displayScopes(actualScopes), this.scope.getSimpleName(), serviceType.getSimpleName(), this.scope.getSimpleName());
    }

    private String missingScopeMessage(Class<?> serviceType) {
        return String.format("The service '%s' is registered in the '%s' scope but does not declare it. Add the '@ServiceScope()' annotation on '%s' with the '%s' scope.", serviceType.getName(), this.scope.getSimpleName(), serviceType.getSimpleName(), this.scope.getSimpleName());
    }

    private String implementationWithMissingScopeMessage(Class<?> serviceType, Class<?> implementationType) {
        return String.format("The service implementation '%s' is registered in the '%s' scope but does not declare it explicitly.\nThe implementation appears to serve %s.\nTry the following:\n- If registered via an instance or implementation type then use an overload providing an explicit service type, e.g. 'ServiceRegistration.add(serviceType, implementationType)'\n- If registered via a creator-method in a service provider class then change the return type of the method to the service type\n- Alternatively, add the '@ServiceScope()' to the implementation type", implementationType.getName(), this.scope.getSimpleName(), ServiceScopeValidator.displayServiceTypes(serviceType));
    }

    private static String displayServiceTypes(Class<?> serviceType) {
        return String.format("'%s' service type", serviceType.getSimpleName());
    }

    private static String displayScopes(Class<? extends Scope>[] scopes) {
        if (scopes.length == 1) {
            return "service scope '" + scopes[0].getSimpleName() + "'";
        }
        return "service scopes " + CollectionUtils.join((String)", ", (Object[])scopes, aClass -> "'" + aClass.getSimpleName() + "'");
    }

    private static Class<? extends Scope> @Nullable [] scopeOf(Class<?> serviceType) {
        ServiceScope scopeAnnotation = serviceType.getAnnotation(ServiceScope.class);
        return scopeAnnotation != null ? scopeAnnotation.value() : null;
    }
}

