/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal.jvm;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.buildtools.api.ProjectId;
import org.jetbrains.kotlin.buildtools.api.jvm.JvmPlatformToolchain;
import org.jetbrains.kotlin.buildtools.api.jvm.operations.JvmClasspathSnapshottingOperation;
import org.jetbrains.kotlin.buildtools.api.jvm.operations.JvmCompilationOperation;
import org.jetbrains.kotlin.buildtools.internal.jvm.operations.JvmClasspathSnapshottingOperationImpl;
import org.jetbrains.kotlin.buildtools.internal.jvm.operations.JvmCompilationOperationImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/jvm/JvmPlatformToolchainImpl;", "Lorg/jetbrains/kotlin/buildtools/api/jvm/JvmPlatformToolchain;", "buildIdToSessionFlagFile", "", "Lorg/jetbrains/kotlin/buildtools/api/ProjectId;", "Ljava/io/File;", "<init>", "(Ljava/util/Map;)V", "createJvmCompilationOperation", "Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmCompilationOperation;", "sources", "", "Ljava/nio/file/Path;", "destinationDirectory", "createClasspathSnapshottingOperation", "Lorg/jetbrains/kotlin/buildtools/api/jvm/operations/JvmClasspathSnapshottingOperation;", "classpathEntry", "kotlin-build-tools-impl"})
public final class JvmPlatformToolchainImpl
implements JvmPlatformToolchain {
    @NotNull
    private final Map<ProjectId, File> buildIdToSessionFlagFile;

    public JvmPlatformToolchainImpl(@NotNull Map<ProjectId, File> buildIdToSessionFlagFile) {
        Intrinsics.checkNotNullParameter(buildIdToSessionFlagFile, (String)"buildIdToSessionFlagFile");
        this.buildIdToSessionFlagFile = buildIdToSessionFlagFile;
    }

    @NotNull
    public JvmCompilationOperation createJvmCompilationOperation(@NotNull List<? extends Path> sources, @NotNull Path destinationDirectory) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        return new JvmCompilationOperationImpl(sources, destinationDirectory, null, this.buildIdToSessionFlagFile, 4, null);
    }

    @NotNull
    public JvmClasspathSnapshottingOperation createClasspathSnapshottingOperation(@NotNull Path classpathEntry) {
        Intrinsics.checkNotNullParameter((Object)classpathEntry, (String)"classpathEntry");
        return new JvmClasspathSnapshottingOperationImpl(classpathEntry);
    }
}

