/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.buildtools.internal;

import java.io.File;
import java.io.Serializable;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.buildtools.api.KotlinLogger;
import org.jetbrains.kotlin.buildtools.internal.DaemonAdaptersKt;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileIterationResult;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/buildtools/internal/DaemonCompilationResults;", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "Ljava/rmi/server/UnicastRemoteObject;", "kotlinLogger", "Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;", "rootProjectDir", "Ljava/io/File;", "buildMetricsReporter", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "<init>", "(Lorg/jetbrains/kotlin/buildtools/api/KotlinLogger;Ljava/io/File;Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;)V", "add", "", "compilationResultCategory", "", "value", "Ljava/io/Serializable;", "kotlin-build-tools-impl"})
public final class DaemonCompilationResults
extends UnicastRemoteObject
implements CompilationResults {
    @NotNull
    private final KotlinLogger kotlinLogger;
    @Nullable
    private final File rootProjectDir;
    @NotNull
    private final BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter;

    public DaemonCompilationResults(@NotNull KotlinLogger kotlinLogger, @Nullable File rootProjectDir, @NotNull BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> buildMetricsReporter) {
        Intrinsics.checkNotNullParameter((Object)kotlinLogger, (String)"kotlinLogger");
        Intrinsics.checkNotNullParameter(buildMetricsReporter, (String)"buildMetricsReporter");
        super(0, (RMIClientSocketFactory)LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), (RMIServerSocketFactory)LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        this.kotlinLogger = kotlinLogger;
        this.rootProjectDir = rootProjectDir;
        this.buildMetricsReporter = buildMetricsReporter;
    }

    public void add(int compilationResultCategory, @NotNull Serializable value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int n = compilationResultCategory;
        if (n == CompilationResultCategory.IC_COMPILE_ITERATION.getCode()) {
            Iterable sourceFiles;
            CompileIterationResult compileIterationResult;
            DaemonAdaptersKt.debug(this.kotlinLogger, value instanceof CompileIterationResult ? (CompileIterationResult)value : null, this.rootProjectDir);
            CompileIterationResult compileIterationResult2 = compileIterationResult = value instanceof CompileIterationResult ? (CompileIterationResult)value : null;
            if (compileIterationResult != null && CollectionsKt.any((Iterable)(sourceFiles = compileIterationResult.getSourceFiles()))) {
                this.buildMetricsReporter.addMetric((BuildPerformanceMetric)GradleBuildPerformanceMetric.COMPILE_ITERATION, 1L);
            }
        } else if (n == CompilationResultCategory.BUILD_METRICS.getCode()) {
            BuildMetrics buildMetrics = value instanceof BuildMetrics ? (BuildMetrics)value : null;
            if (buildMetrics != null) {
                BuildMetrics it = buildMetrics;
                boolean bl = false;
                this.buildMetricsReporter.addMetrics(it);
            }
        } else {
            this.kotlinLogger.debug("Result category=" + compilationResultCategory + " value=" + value);
        }
    }
}

