/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.problems;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.internal.cc.impl.problems.ConfigurationCacheProblemsSummaryKt;
import org.gradle.internal.cc.impl.problems.ProblemCause;
import org.gradle.internal.cc.impl.problems.ProblemSeverity;
import org.gradle.internal.cc.impl.problems.Summary;
import org.gradle.internal.configuration.problems.PropertyProblem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010%\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010&\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fj\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0018j\b\u0012\u0004\u0012\u00020\u0011`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gradle/internal/cc/impl/problems/ConfigurationCacheProblemsSummary;", "", "maxCollectedProblems", "", "<init>", "(I)V", "overflowed", "", "totalProblemCount", "deferredProblemCount", "suppressedProblemCount", "suppressedSilentlyProblemCount", "incompatibleTasksCount", "incompatibleFeatureCount", "problemCauses", "Ljava/util/HashMap;", "Lorg/gradle/internal/cc/impl/problems/ProblemCause;", "Lorg/gradle/internal/cc/impl/problems/ProblemSeverity;", "Lkotlin/collections/HashMap;", "originalProblemExceptions", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "severityComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "get", "Lorg/gradle/internal/cc/impl/problems/Summary;", "onProblem", "problem", "Lorg/gradle/internal/configuration/problems/PropertyProblem;", "severity", "onIncompatibleTask", "", "onIncompatibleFeature", "collectOriginalException", "recordProblemCause", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nConfigurationCacheProblemsSummary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationCacheProblemsSummary.kt\norg/gradle/internal/cc/impl/problems/ConfigurationCacheProblemsSummary\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,395:1\n507#2,7:396\n*S KotlinDebug\n*F\n+ 1 ConfigurationCacheProblemsSummary.kt\norg/gradle/internal/cc/impl/problems/ConfigurationCacheProblemsSummary\n*L\n108#1:396,7\n*E\n"})
public final class ConfigurationCacheProblemsSummary {
    private final int maxCollectedProblems;
    private boolean overflowed;
    private int totalProblemCount;
    private int deferredProblemCount;
    private int suppressedProblemCount;
    private int suppressedSilentlyProblemCount;
    private int incompatibleTasksCount;
    private int incompatibleFeatureCount;
    @NotNull
    private final HashMap<ProblemCause, ProblemSeverity> problemCauses;
    @NotNull
    private final ArrayList<Throwable> originalProblemExceptions;
    @NotNull
    private final Comparator<ProblemSeverity> severityComparator;
    @NotNull
    private final ReentrantLock lock;

    public ConfigurationCacheProblemsSummary(int maxCollectedProblems) {
        this.maxCollectedProblems = maxCollectedProblems;
        this.problemCauses = new HashMap();
        this.originalProblemExceptions = new ArrayList(5);
        this.severityComparator = ConfigurationCacheProblemsSummaryKt.access$consoleComparatorForSeverity();
        this.lock = new ReentrantLock();
    }

    public /* synthetic */ ConfigurationCacheProblemsSummary(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4096;
        }
        this(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Summary get() {
        Summary summary;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            int n = this.totalProblemCount;
            int n2 = this.problemCauses.size();
            int n3 = this.deferredProblemCount;
            int n4 = this.totalProblemCount - this.suppressedSilentlyProblemCount;
            Map $this$filterValues$iv = this.problemCauses;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                ProblemSeverity it = (ProblemSeverity)entry$iv.getValue();
                boolean bl2 = false;
                if (!(it != ProblemSeverity.SuppressedSilently)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            ImmutableMap immutableMap = ImmutableMap.copyOf((Map)result$iv);
            Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"copyOf(...)");
            ImmutableMap immutableMap2 = immutableMap;
            ImmutableList immutableList = ImmutableList.copyOf((Collection)this.originalProblemExceptions);
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(...)");
            ImmutableList immutableList2 = immutableList;
            boolean bl3 = this.overflowed;
            int n5 = this.maxCollectedProblems;
            int n6 = this.incompatibleTasksCount;
            int n7 = this.incompatibleFeatureCount;
            summary = new Summary(n, n4, n3, (Map)immutableMap2, n2, (List)immutableList2, bl3, n5, n6, n7);
        }
        finally {
            lock.unlock();
        }
        return summary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onProblem(@NotNull PropertyProblem problem, @NotNull ProblemSeverity severity) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            ++this.totalProblemCount;
            switch (WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
                case 1: {
                    ++this.deferredProblemCount;
                    break;
                }
                case 2: {
                    ++this.suppressedProblemCount;
                    break;
                }
                case 3: {
                    ++this.suppressedSilentlyProblemCount;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if (this.overflowed) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.problemCauses.size() == this.maxCollectedProblems) {
                this.overflowed = true;
                boolean bl3 = false;
                return bl3;
            }
            boolean isNewCause = this.recordProblemCause(problem, severity);
            if (!isNewCause) {
                boolean bl4 = false;
                return bl4;
            }
            if (severity != ProblemSeverity.Interrupting) {
                this.collectOriginalException(problem);
            }
            boolean bl5 = true;
            return bl5;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onIncompatibleTask() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            ++this.incompatibleTasksCount;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onIncompatibleFeature(@NotNull PropertyProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.onProblem(problem, ProblemSeverity.SuppressedSilently);
            ++this.incompatibleFeatureCount;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void collectOriginalException(PropertyProblem problem) {
        block1: {
            if (this.originalProblemExceptions.size() >= 5) break block1;
            Throwable throwable = problem.getException();
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                this.originalProblemExceptions.add(it);
            }
        }
    }

    private final boolean recordProblemCause(PropertyProblem problem, ProblemSeverity severity) {
        ProblemCause newCause = ProblemCause.Companion.of(problem);
        Ref.BooleanRef problemAccepted = new Ref.BooleanRef();
        problemAccepted.element = true;
        this.problemCauses.merge(newCause, severity, new BiFunction(this, problemAccepted){
            final /* synthetic */ ConfigurationCacheProblemsSummary this$0;
            final /* synthetic */ Ref.BooleanRef $problemAccepted;
            {
                this.this$0 = $receiver;
                this.$problemAccepted = $problemAccepted;
            }

            public final ProblemSeverity apply(ProblemSeverity existingSeverity, ProblemSeverity newSeverity) {
                ProblemSeverity problemSeverity;
                boolean newSeverityIsHigher;
                Intrinsics.checkNotNullParameter((Object)existingSeverity, (String)"existingSeverity");
                Intrinsics.checkNotNullParameter((Object)newSeverity, (String)"newSeverity");
                boolean bl = newSeverityIsHigher = ConfigurationCacheProblemsSummary.access$getSeverityComparator$p(this.this$0).compare(existingSeverity, newSeverity) > 0;
                if (newSeverityIsHigher) {
                    problemSeverity = newSeverity;
                } else {
                    this.$problemAccepted.element = false;
                    problemSeverity = existingSeverity;
                }
                return problemSeverity;
            }
        });
        return problemAccepted.element;
    }

    public ConfigurationCacheProblemsSummary() {
        this(0, 1, null);
    }

    public static final /* synthetic */ Comparator access$getSeverityComparator$p(ConfigurationCacheProblemsSummary $this) {
        return $this.severityComparator;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProblemSeverity.values().length];
            try {
                nArray[ProblemSeverity.Deferred.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemSeverity.Suppressed.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemSeverity.SuppressedSilently.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemSeverity.Interrupting.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

