/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.evaluator;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.declarative.dsl.schema.DataParameter;
import org.gradle.internal.declarativedsl.analysis.ErrorReason;
import org.gradle.internal.declarativedsl.analysis.FunctionCallResolver;
import org.gradle.internal.declarativedsl.analysis.ResolutionError;
import org.gradle.internal.declarativedsl.evaluator.checks.DocumentCheckFailure;
import org.gradle.internal.declarativedsl.evaluator.checks.DocumentCheckFailureReason;
import org.gradle.internal.declarativedsl.evaluator.runner.EvaluationResult;
import org.gradle.internal.declarativedsl.language.LanguageTreeElement;
import org.gradle.internal.declarativedsl.language.ParsingError;
import org.gradle.internal.declarativedsl.language.SingleFailureResult;
import org.gradle.internal.declarativedsl.language.SourceData;
import org.gradle.internal.declarativedsl.language.UnsupportedConstruct;
import org.gradle.internal.declarativedsl.objectGraph.PropertyLinkTraceElement;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\bH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010(\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010)\u001a\u00020*H\u0002\u00a8\u0006+"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/EvaluationFailureMessageGenerator;", "", "<init>", "()V", "generateFailureMessage", "", "scriptSourceIdentifier", "stageFailures", "", "Lorg/gradle/internal/declarativedsl/evaluator/runner/EvaluationResult$NotEvaluated$StageFailure;", "formatFailuresInLanguageTree", "failures", "Lorg/gradle/internal/declarativedsl/language/SingleFailureResult;", "formatUnsupportedConstruct", "unsupportedConstruct", "Lorg/gradle/internal/declarativedsl/language/UnsupportedConstruct;", "formatParsingError", "parsingError", "Lorg/gradle/internal/declarativedsl/language/ParsingError;", "formatResolutionError", "resolutionError", "Lorg/gradle/internal/declarativedsl/analysis/ResolutionError;", "describeResolutionErrorReason", "errorReason", "Lorg/gradle/internal/declarativedsl/analysis/ErrorReason;", "describePropertyLinkIssue", "issue", "Lorg/gradle/internal/declarativedsl/objectGraph/PropertyLinkTraceElement$FailedToResolveLinks;", "elementLocationString", "languageTreeElement", "Lorg/gradle/internal/declarativedsl/language/LanguageTreeElement;", "describeDocumentCheckFailure", "failure", "Lorg/gradle/internal/declarativedsl/evaluator/checks/DocumentCheckFailure;", "describeDocumentCheckFailureReason", "reason", "Lorg/gradle/internal/declarativedsl/evaluator/checks/DocumentCheckFailureReason;", "locationPrefixString", "ast", "Lorg/gradle/internal/declarativedsl/language/SourceData;", "indent", "level", "", "declarative-dsl-evaluator"})
@SourceDebugExtension(value={"SMAP\nEvaluationFailureMessageGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluationFailureMessageGenerator.kt\norg/gradle/internal/declarativedsl/evaluator/EvaluationFailureMessageGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1915#2:166\n1915#2,2:167\n1915#2,2:169\n1915#2,2:171\n1915#2,2:173\n1916#2:175\n1915#2,2:176\n*S KotlinDebug\n*F\n+ 1 EvaluationFailureMessageGenerator.kt\norg/gradle/internal/declarativedsl/evaluator/EvaluationFailureMessageGenerator\n*L\n38#1:166\n43#1:167,2\n51#1:169,2\n60#1:171,2\n67#1:173,2\n38#1:175\n77#1:176,2\n*E\n"})
public final class EvaluationFailureMessageGenerator {
    @NotNull
    public static final EvaluationFailureMessageGenerator INSTANCE = new EvaluationFailureMessageGenerator();

    private EvaluationFailureMessageGenerator() {
    }

    @NotNull
    public final String generateFailureMessage(@NotNull String scriptSourceIdentifier, @NotNull List<? extends EvaluationResult.NotEvaluated.StageFailure> stageFailures) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)scriptSourceIdentifier, (String)"scriptSourceIdentifier");
        Intrinsics.checkNotNullParameter(stageFailures, (String)"stageFailures");
        StringBuilder $this$generateFailureMessage_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateFailureMessage_u24lambda_u240.append("Failed to interpret the declarative DSL file '" + scriptSourceIdentifier + "':").append('\n');
        Iterable $this$forEach$iv = stageFailures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object it;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv2;
            EvaluationResult.NotEvaluated.StageFailure stageFailure = (EvaluationResult.NotEvaluated.StageFailure)element$iv;
            boolean bl2 = false;
            EvaluationResult.NotEvaluated.StageFailure stageFailure2 = stageFailure;
            if (stageFailure2 instanceof EvaluationResult.NotEvaluated.StageFailure.FailuresInLanguageTree) {
                $this$generateFailureMessage_u24lambda_u240.append(INSTANCE.indent("Failures in building the language tree:", 1)).append('\n');
                if (!(!((Collection)((EvaluationResult.NotEvaluated.StageFailure.FailuresInLanguageTree)stageFailure).getFailures()).isEmpty())) continue;
                $this$forEach$iv2 = INSTANCE.formatFailuresInLanguageTree(((EvaluationResult.NotEvaluated.StageFailure.FailuresInLanguageTree)stageFailure).getFailures());
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    it = (String)element$iv2;
                    boolean bl3 = false;
                    $this$generateFailureMessage_u24lambda_u240.append(INSTANCE.indent((String)it, 2)).append('\n');
                }
                continue;
            }
            if (stageFailure2 instanceof EvaluationResult.NotEvaluated.StageFailure.FailuresInResolution) {
                $this$generateFailureMessage_u24lambda_u240.append(INSTANCE.indent("Failures in resolution:", 1)).append('\n');
                $this$forEach$iv2 = ((EvaluationResult.NotEvaluated.StageFailure.FailuresInResolution)stageFailure).getErrors();
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    it = (ResolutionError)element$iv2;
                    boolean bl4 = false;
                    $this$generateFailureMessage_u24lambda_u240.append(INSTANCE.indent(INSTANCE.formatResolutionError((ResolutionError)it), 2)).append('\n');
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)stageFailure2, (Object)EvaluationResult.NotEvaluated.StageFailure.NoParseResult.INSTANCE)) {
                $this$generateFailureMessage_u24lambda_u240.append("Failed to parse due to syntax errors").append('\n');
                continue;
            }
            if (stageFailure2 instanceof EvaluationResult.NotEvaluated.StageFailure.NoSchemaAvailable) {
                $this$generateFailureMessage_u24lambda_u240.append("No associated schema for " + ((EvaluationResult.NotEvaluated.StageFailure.NoSchemaAvailable)stageFailure).getScriptContext()).append('\n');
                continue;
            }
            if (stageFailure2 instanceof EvaluationResult.NotEvaluated.StageFailure.PropertyLinkErrors) {
                $this$generateFailureMessage_u24lambda_u240.append(INSTANCE.indent("Failures in property links:", 1)).append('\n');
                $this$forEach$iv2 = ((EvaluationResult.NotEvaluated.StageFailure.PropertyLinkErrors)stageFailure).getUsages();
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    PropertyLinkTraceElement.FailedToResolveLinks unassigned = (PropertyLinkTraceElement.FailedToResolveLinks)element$iv2;
                    boolean bl5 = false;
                    $this$generateFailureMessage_u24lambda_u240.append(INSTANCE.indent(INSTANCE.describePropertyLinkIssue(unassigned), 2)).append('\n');
                }
                continue;
            }
            if (stageFailure2 instanceof EvaluationResult.NotEvaluated.StageFailure.DocumentCheckFailures) {
                $this$generateFailureMessage_u24lambda_u240.append(INSTANCE.indent("Failures in document checks:", 1)).append('\n');
                $this$forEach$iv2 = ((EvaluationResult.NotEvaluated.StageFailure.DocumentCheckFailures)stageFailure).getFailures();
                $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    DocumentCheckFailure failure = (DocumentCheckFailure)element$iv2;
                    boolean bl6 = false;
                    $this$generateFailureMessage_u24lambda_u240.append(INSTANCE.indent(INSTANCE.describeDocumentCheckFailure(failure), 2)).append('\n');
                }
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return stringBuilder.toString();
    }

    private final List<String> formatFailuresInLanguageTree(List<? extends SingleFailureResult> failures) {
        List list;
        List $this$formatFailuresInLanguageTree_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = failures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl2;
            SingleFailureResult failure = (SingleFailureResult)element$iv;
            boolean bl3 = false;
            SingleFailureResult singleFailureResult = failure;
            if (singleFailureResult instanceof UnsupportedConstruct) {
                bl2 = $this$formatFailuresInLanguageTree_u24lambda_u240.add(INSTANCE.formatUnsupportedConstruct((UnsupportedConstruct)failure));
                continue;
            }
            if (singleFailureResult instanceof ParsingError) {
                bl2 = $this$formatFailuresInLanguageTree_u24lambda_u240.add(INSTANCE.formatParsingError((ParsingError)failure));
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return CollectionsKt.build((List)list);
    }

    private final String formatUnsupportedConstruct(UnsupportedConstruct unsupportedConstruct) {
        return this.locationPrefixString(unsupportedConstruct.getErroneousSource()) + ": unsupported language feature: " + unsupportedConstruct.getLanguageFeature();
    }

    private final String formatParsingError(ParsingError parsingError) {
        return this.locationPrefixString(parsingError.getErroneousSource()) + ": parsing error: " + parsingError.getMessage();
    }

    private final String formatResolutionError(ResolutionError resolutionError) {
        return this.elementLocationString(resolutionError.getElement()) + ": " + this.describeResolutionErrorReason(resolutionError.getErrorReason());
    }

    private final String describeResolutionErrorReason(ErrorReason errorReason) {
        String string;
        ErrorReason errorReason2 = errorReason;
        if (errorReason2 instanceof ErrorReason.AmbiguousFunctions) {
            string = "ambiguous functions: " + CollectionsKt.joinToString$default((Iterable)((ErrorReason.AmbiguousFunctions)errorReason).getFunctions(), (CharSequence)", ", null, null, (int)0, null, EvaluationFailureMessageGenerator::describeResolutionErrorReason$lambda$0, (int)30, null);
        } else if (errorReason2 instanceof ErrorReason.AmbiguousImport) {
            string = "ambiguous import '" + ((ErrorReason.AmbiguousImport)errorReason).getFqName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.AssignmentTypeMismatch) {
            string = "assignment type mismatch, expected '" + ((ErrorReason.AssignmentTypeMismatch)errorReason).getExpected() + "', got '" + ((ErrorReason.AssignmentTypeMismatch)errorReason).getActual() + '\'';
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.DanglingPureExpression.INSTANCE)) {
            string = "dangling pure expression";
        } else if (errorReason2 instanceof ErrorReason.DuplicateLocalValue) {
            string = "duplicate local 'val " + ((ErrorReason.DuplicateLocalValue)errorReason).getName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.ExternalReassignment) {
            string = "assignment to external property";
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.MissingConfigureLambda.INSTANCE)) {
            string = "a configuring block expected but not found";
        } else if (errorReason2 instanceof ErrorReason.ReadOnlyPropertyAssignment) {
            string = "assignment to property '" + ((ErrorReason.ReadOnlyPropertyAssignment)errorReason).getProperty().getName() + "' with read-only type '" + ((ErrorReason.ReadOnlyPropertyAssignment)errorReason).getProperty().getValueType() + '\'';
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.UnitAssignment.INSTANCE)) {
            string = "assignment of a Unit value";
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.UnresolvedAssignmentLhs.INSTANCE)) {
            string = "unresolved assignment target";
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.UnresolvedAssignmentRhs.INSTANCE)) {
            string = "unresolved assigned value";
        } else if (errorReason2 instanceof ErrorReason.AugmentingAssignmentNotResolved) {
            string = "augmenting assignment operation not resolved for '" + ((ErrorReason.AugmentingAssignmentNotResolved)errorReason).getPropertyType() + '\'';
        } else if (errorReason2 instanceof ErrorReason.UnresolvedReference) {
            string = "unresolved reference '" + ((ErrorReason.UnresolvedReference)errorReason).getReference().getSourceData().text() + '\'';
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.UnusedConfigureLambda.INSTANCE)) {
            string = "a configuring block is not expected";
        } else if (errorReason2 instanceof ErrorReason.ValReassignment) {
            string = "assignment to a local 'val " + ((ErrorReason.ValReassignment)errorReason).getLocalVal().getName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.UnresolvedFunctionCallArguments) {
            string = "unresolved function call arguments for '" + ((ErrorReason.UnresolvedFunctionCallArguments)errorReason).getFunctionCall().getName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.UnresolvedFunctionCallReceiver) {
            string = "unresolved function call receiver for '" + ((ErrorReason.UnresolvedFunctionCallReceiver)errorReason).getFunctionCall().getName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.UnresolvedFunctionCallSignature) {
            string = "unresolved function call signature for '" + ((ErrorReason.UnresolvedFunctionCallSignature)errorReason).getFunctionCall().getName() + '\'';
        } else if (Intrinsics.areEqual((Object)errorReason2, (Object)ErrorReason.AccessOnCurrentReceiverOnlyViolation.INSTANCE)) {
            string = "this member can only be accessed on a current receiver";
        } else if (errorReason2 instanceof ErrorReason.NonReadableProperty) {
            string = "property cannot be used as a value: '" + ((ErrorReason.NonReadableProperty)errorReason).getProperty().getName() + '\'';
        } else if (errorReason2 instanceof ErrorReason.OpaqueArgumentForIdentityParameter) {
            string = "opaque identity argument: " + ((ErrorReason.OpaqueArgumentForIdentityParameter)errorReason).getParameter().getName() + " = " + ((ErrorReason.OpaqueArgumentForIdentityParameter)errorReason).getArgument().getOriginElement().getSourceData().text();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String describePropertyLinkIssue(PropertyLinkTraceElement.FailedToResolveLinks issue) {
        String string;
        PropertyLinkTraceElement.FailedToResolveLinks failedToResolveLinks = issue;
        if (failedToResolveLinks instanceof PropertyLinkTraceElement.Reassignment) {
            string = "reassigned value in '" + ((PropertyLinkTraceElement.Reassignment)issue).getOriginElement().getSourceData().text() + '\'';
        } else if (failedToResolveLinks instanceof PropertyLinkTraceElement.UnassignedValueUsedInAssignment) {
            string = "unassigned property used in assigned value";
        } else if (failedToResolveLinks instanceof PropertyLinkTraceElement.UnassignedValueUsedInAddition) {
            string = "unassigned property used in expression";
        } else if (failedToResolveLinks instanceof PropertyLinkTraceElement.UnassignedValueUsedInNestedObjectAccess) {
            string = "unassigned property used in expression";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String errorMessage = string;
        return this.elementLocationString(issue.getOriginElement()) + ": " + errorMessage;
    }

    private final String elementLocationString(LanguageTreeElement languageTreeElement) {
        return this.locationPrefixString(languageTreeElement.getSourceData());
    }

    private final String describeDocumentCheckFailure(DocumentCheckFailure failure) {
        return this.locationPrefixString(failure.getLocation().getSourceData()) + ": " + this.describeDocumentCheckFailureReason(failure.getReason());
    }

    private final String describeDocumentCheckFailureReason(DocumentCheckFailureReason reason) {
        String string;
        DocumentCheckFailureReason documentCheckFailureReason = reason;
        if (Intrinsics.areEqual((Object)documentCheckFailureReason, (Object)DocumentCheckFailureReason.PluginManagementBlockOrderViolated.INSTANCE)) {
            string = "illegal content before 'pluginManagement', which can only appear as the first element in the file";
        } else if (Intrinsics.areEqual((Object)documentCheckFailureReason, (Object)DocumentCheckFailureReason.PluginsBlockOrderViolated.INSTANCE)) {
            string = "illegal content before 'plugins', which can only be preceded by 'pluginManagement'";
        } else if (Intrinsics.areEqual((Object)documentCheckFailureReason, (Object)DocumentCheckFailureReason.DuplicatePluginManagementBlock.INSTANCE)) {
            string = "duplicate 'pluginManagement'";
        } else if (Intrinsics.areEqual((Object)documentCheckFailureReason, (Object)DocumentCheckFailureReason.DuplicatePluginsBlock.INSTANCE)) {
            string = "duplicate 'plugins'";
        } else if (Intrinsics.areEqual((Object)documentCheckFailureReason, (Object)DocumentCheckFailureReason.AccessOnCurrentReceiverViolation.INSTANCE)) {
            string = "illegal receiver, only implicit 'this' receiver is allowed";
        } else if (documentCheckFailureReason instanceof DocumentCheckFailureReason.UnsupportedSyntaxInDocument) {
            string = "unsupported syntax (" + ((DocumentCheckFailureReason.UnsupportedSyntaxInDocument)reason).getCause() + ')';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String locationPrefixString(SourceData ast) {
        return ast.getLineRange().getFirst() != -1 ? "" + ast.getLineRange().getFirst() + ':' + ast.getStartColumn() : "";
    }

    private final String indent(String $this$indent, int level) {
        return StringsKt.repeat((CharSequence)" ", (int)(level * 2)) + $this$indent;
    }

    static /* synthetic */ String indent$default(EvaluationFailureMessageGenerator evaluationFailureMessageGenerator, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return evaluationFailureMessageGenerator.indent(string, n);
    }

    private static final CharSequence describeResolutionErrorReason$lambda$0(FunctionCallResolver.FunctionResolutionAndBinding resolution) {
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        return resolution.getSchemaFunction().getSimpleName() + '(' + CollectionsKt.joinToString$default((Iterable)resolution.getBinding().getBinding().keySet(), null, null, null, (int)0, null, EvaluationFailureMessageGenerator::describeResolutionErrorReason$lambda$0$0, (int)31, null) + ')';
    }

    private static final CharSequence describeResolutionErrorReason$lambda$0$0(DataParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName() + ": " + it.getType();
    }
}

