/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.gradle.internal.collect.PersistentMap;
import org.gradle.internal.collect.PersistentMapEntry;
import org.gradle.internal.collect.PersistentMapTrie;
import org.gradle.internal.collect.Preconditions;
import org.gradle.internal.collect.SingletonIterator;
import org.gradle.internal.collect.ToString;
import org.jspecify.annotations.Nullable;

final class PersistentMap1<K, V>
implements PersistentMap<K, V> {
    private final K key;
    private final V value;

    public PersistentMap1(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public PersistentMap<K, V> assoc(K key, V value) {
        Preconditions.entryCannotBeNull(key, value);
        if (this.containsKey(key)) {
            return Objects.equals(this.value, value) ? this : new PersistentMap1<K, V>(key, value);
        }
        return this.assocNew(key, value);
    }

    @Override
    public PersistentMap<K, V> dissoc(K key) {
        return this.containsKey(key) ? PersistentMap.of() : this;
    }

    @Override
    public PersistentMap<K, V> modify(K key, BiFunction<? super K, ? super @Nullable V, ? extends @Nullable V> function) {
        if (this.containsKey(key)) {
            V val = function.apply(key, this.value);
            if (Objects.equals(this.value, val)) {
                return this;
            }
            return val != null ? new PersistentMap1<K, V>(key, val) : PersistentMap.of();
        }
        V val = function.apply(key, null);
        return val != null ? this.assocNew(key, val) : this;
    }

    private PersistentMap<K, V> assocNew(K key, V value) {
        return PersistentMapTrie.ofDistinct(key, value, this.key, this.value);
    }

    @Override
    public @Nullable V get(K key) {
        return this.containsKey(key) ? (V)this.value : null;
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        return this.containsKey(key) ? this.value : defaultValue;
    }

    @Override
    public boolean containsKey(K key) {
        return this.key.equals(key);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new SingletonIterator<Map.Entry<K, V>>(this.mapEntry());
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> action) {
        action.accept(this.mapEntry());
    }

    public String toString() {
        return "{" + ToString.entry(this.key, this.value) + "}";
    }

    public int hashCode() {
        return PersistentMapEntry.hashCodeOf(this.key, this.value);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof PersistentMap1)) {
            return false;
        }
        PersistentMap1 that = (PersistentMap1)other;
        return that.size() == 1 && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    private Map.Entry<K, V> mapEntry() {
        return new PersistentMapEntry<K, V>(this.key, this.value);
    }
}

