/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.Cast;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ProxyDispatchAdapter;
import org.gradle.internal.dispatch.ReflectionDispatch;
import org.gradle.internal.event.AbstractBroadcastDispatch;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ScopedListenerManager;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.service.AnnotatedServiceLifecycleHandler;
import org.gradle.internal.service.scopes.EventScope;
import org.gradle.internal.service.scopes.ListenerService;
import org.gradle.internal.service.scopes.ParallelListener;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.StatefulListener;
import org.gradle.util.internal.ArrayUtils;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class DefaultListenerManager
implements ScopedListenerManager {
    private static final List<Class<? extends Annotation>> ANNOTATIONS = ImmutableList.of(StatefulListener.class, ListenerService.class);
    private final Map<Object, ListenerDetails> allListeners = new LinkedHashMap<Object, ListenerDetails>();
    private final Map<Object, ListenerDetails> allLoggers = new LinkedHashMap<Object, ListenerDetails>();
    private final Map<Class<?>, EventBroadcast<?>> broadcasters = new ConcurrentHashMap();
    private final List<AnnotatedServiceLifecycleHandler.Registration> pendingServices = new ArrayList<AnnotatedServiceLifecycleHandler.Registration>();
    private final List<AnnotatedServiceLifecycleHandler.Registration> pendingRegistrations = new ArrayList<AnnotatedServiceLifecycleHandler.Registration>();
    private final Object lock = new Object();
    private final Class<? extends Scope> scope;
    private final @Nullable DefaultListenerManager parent;

    public DefaultListenerManager(Class<? extends Scope> scope) {
        this(scope, null);
    }

    private DefaultListenerManager(Class<? extends Scope> scope, @Nullable DefaultListenerManager parent) {
        this.scope = scope;
        this.parent = parent;
    }

    public List<Class<? extends Annotation>> getAnnotations() {
        return ANNOTATIONS;
    }

    public @Nullable Class<? extends Annotation> getImplicitAnnotation() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whenRegistered(Class<? extends Annotation> annotation, AnnotatedServiceLifecycleHandler.Registration registration) {
        Object object = this.lock;
        synchronized (object) {
            if (annotation == ListenerService.class) {
                this.pendingServices.add(registration);
            } else {
                this.pendingRegistrations.add(registration);
                for (EventBroadcast<?> broadcast : this.broadcasters.values()) {
                    if (!DefaultListenerManager.registrationProvides(broadcast.type, registration)) continue;
                    broadcast.assertMutable("add listener");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddPendingRegistrations(Class<?> type) {
        Object object = this.lock;
        synchronized (object) {
            for (AnnotatedServiceLifecycleHandler.Registration registration : this.pendingServices) {
                this.addListener(registration.getInstance());
            }
            this.pendingServices.clear();
            int i = 0;
            while (i < this.pendingRegistrations.size()) {
                AnnotatedServiceLifecycleHandler.Registration registration;
                registration = this.pendingRegistrations.get(i);
                if (DefaultListenerManager.registrationProvides(type, registration)) {
                    this.addListener(registration.getInstance());
                    this.pendingRegistrations.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    private static boolean registrationProvides(Class<?> type, AnnotatedServiceLifecycleHandler.Registration registration) {
        for (Class declaredType : registration.getDeclaredTypes()) {
            if (!type.isAssignableFrom(declaredType)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Object listener) {
        ListenerDetails details = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.allListeners.containsKey(listener)) {
                details = new ListenerDetails(listener);
                this.allListeners.put(listener, details);
            }
        }
        if (details != null) {
            details.useAsListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object listener) {
        ListenerDetails details;
        Object object = this.lock;
        synchronized (object) {
            details = this.allListeners.remove(listener);
            if (details != null) {
                details.disconnect();
            }
        }
        if (details != null) {
            details.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useLogger(Object logger) {
        ListenerDetails details = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.allLoggers.containsKey(logger)) {
                details = new ListenerDetails(logger);
                this.allLoggers.put(logger, details);
            }
        }
        if (details != null) {
            details.useAsLogger();
        }
    }

    @Override
    public <T> boolean hasListeners(Class<T> listenerClass) {
        EventBroadcast<T> broadcaster = this.getBroadcasterInternal(listenerClass);
        return !((EventBroadcast)broadcaster).listeners.isEmpty();
    }

    @Override
    public <T> T getBroadcaster(Class<T> listenerClass) {
        this.assertCanBroadcast(listenerClass);
        return this.getBroadcasterInternal(listenerClass).getBroadcaster();
    }

    @Override
    public <T> AnonymousListenerBroadcast<T> createAnonymousBroadcaster(Class<T> listenerClass) {
        this.assertCanBroadcast(listenerClass);
        return new AnonymousListenerBroadcast<T>(listenerClass, this.getBroadcasterInternal(listenerClass).getDispatch(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> EventBroadcast<T> getBroadcasterInternal(Class<T> listenerClass) {
        Object object = this.lock;
        synchronized (object) {
            EventBroadcast broadcaster = (ParallelEventBroadcast<T>)Cast.uncheckedCast(this.broadcasters.get(listenerClass));
            if (broadcaster == null) {
                broadcaster = listenerClass.getAnnotation(StatefulListener.class) != null ? new ParallelEventBroadcast<T>(listenerClass) : new ExclusiveEventBroadcast<T>(listenerClass);
                this.broadcasters.put(listenerClass, broadcaster);
                for (ListenerDetails listener : this.allListeners.values()) {
                    broadcaster.maybeAdd(listener);
                }
                for (ListenerDetails logger : this.allLoggers.values()) {
                    broadcaster.maybeSetLogger(logger);
                }
            }
            return broadcaster;
        }
    }

    private <T> void assertCanBroadcast(Class<T> listenerClass) {
        EventScope scope = listenerClass.getAnnotation(EventScope.class);
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Listener type %s is not annotated with @EventScope.", listenerClass.getName()));
        }
        if (!ArrayUtils.contains((Object[])scope.value(), this.scope)) {
            throw new IllegalArgumentException(String.format("Listener type %s with %s cannot be used to generate events in scope '%s'.", listenerClass.getName(), DefaultListenerManager.displayScopes(scope.value()), this.scope.getSimpleName()));
        }
    }

    @Override
    public DefaultListenerManager createChild(Class<? extends Scope> scope) {
        return new DefaultListenerManager(scope, this);
    }

    private static String displayScopes(Class<? extends Scope>[] scopes) {
        if (scopes.length == 1) {
            return "service scope '" + scopes[0].getSimpleName() + "'";
        }
        return "service scopes " + CollectionUtils.join((String)", ", (Object[])scopes, aClass -> "'" + aClass.getSimpleName() + "'");
    }

    private abstract class EventBroadcast<T> {
        protected final Class<T> type;
        private final ListenerDispatch dispatch;
        private final ListenerDispatch dispatchNoLogger;
        private final Set<ListenerDetails> listeners = new LinkedHashSet<ListenerDetails>();
        private volatile @Nullable ProxyDispatchAdapter<T> source;
        private @Nullable ListenerDetails logger;
        private @Nullable Dispatch<MethodInvocation> parentDispatch;
        private ImmutableList<Dispatch<MethodInvocation>> allWithLogger = ImmutableList.of();
        private ImmutableList<Dispatch<MethodInvocation>> allWithNoLogger = ImmutableList.of();
        protected volatile boolean initialized;
        protected final Object initializationLock = new Object();

        EventBroadcast(Class<T> type) {
            this.type = type;
            this.dispatch = new ListenerDispatch(type, true);
            this.dispatchNoLogger = new ListenerDispatch(type, false);
            if (DefaultListenerManager.this.parent != null) {
                this.parentDispatch = DefaultListenerManager.this.parent.getBroadcasterInternal(type).getDispatch(true);
                this.initLoggers();
            }
        }

        Dispatch<MethodInvocation> getDispatch(boolean includeLogger) {
            return includeLogger ? this.dispatch : this.dispatchNoLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getBroadcaster() {
            if (this.source == null) {
                EventBroadcast eventBroadcast = this;
                synchronized (eventBroadcast) {
                    if (this.source == null) {
                        this.source = new ProxyDispatchAdapter<T>(this.dispatch, this.type);
                    }
                }
            }
            return this.source.getSource();
        }

        protected List<Dispatch<MethodInvocation>> getListeners(boolean withLogger) {
            return withLogger ? this.allWithLogger : this.allWithNoLogger;
        }

        protected void initLoggers() {
            this.allWithLogger = this.initAllWithLogger();
            this.allWithNoLogger = this.initAllWithNoLogger();
        }

        public final void maybeAdd(ListenerDetails listener) {
            if (!this.type.isInstance(listener.listener)) {
                return;
            }
            this.assertMutable("add listener");
            this.doAdd(listener);
        }

        protected void doAdd(ListenerDetails listener) {
            this.listeners.add(listener);
        }

        public final void maybeRemove(ListenerDetails listener) {
            if (!this.type.isInstance(listener.listener)) {
                return;
            }
            this.assertMutable("remove listener");
            this.doRemove(listener);
        }

        protected void doRemove(ListenerDetails listener) {
            this.listeners.remove(listener);
        }

        public final void maybeSetLogger(ListenerDetails candidate) {
            if (!this.type.isInstance(candidate.listener)) {
                return;
            }
            this.assertMutable("set logger");
            this.doSetLogger(candidate);
        }

        protected void doSetLogger(ListenerDetails candidate) {
            if (this.logger == null && DefaultListenerManager.this.parent != null) {
                this.parentDispatch = DefaultListenerManager.this.parent.getBroadcasterInternal(this.type).getDispatch(false);
            }
            this.logger = candidate;
        }

        private ImmutableList<Dispatch<MethodInvocation>> initAllWithNoLogger() {
            if (this.parentDispatch == null && this.listeners.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder dispatchers = ImmutableList.builder();
            if (this.parentDispatch != null) {
                dispatchers.add(this.parentDispatch);
            }
            dispatchers.addAll(this.listeners);
            return dispatchers.build();
        }

        private ImmutableList<Dispatch<MethodInvocation>> initAllWithLogger() {
            if (this.logger == null && this.parentDispatch == null && this.listeners.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder result = ImmutableList.builder();
            if (this.logger != null) {
                result.add((Object)this.logger);
            }
            if (this.parentDispatch != null) {
                result.add(this.parentDispatch);
            }
            result.addAll(this.listeners);
            return result.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void maybeInitialize() {
            if (!this.initialized) {
                Object object = this.initializationLock;
                synchronized (object) {
                    if (!this.initialized) {
                        DefaultListenerManager.this.maybeAddPendingRegistrations(this.type);
                        this.initLoggers();
                        this.initialized = true;
                    }
                }
            }
        }

        protected abstract List<Dispatch<MethodInvocation>> startDispatch(boolean var1);

        protected abstract void endDispatch();

        protected abstract void assertMutable(String var1);

        private class ListenerDispatch
        extends AbstractBroadcastDispatch<T> {
            private final boolean includeLogger;

            ListenerDispatch(Class<T> type, boolean includeLogger) {
                super(type);
                this.includeLogger = includeLogger;
            }

            @Override
            public void dispatch(MethodInvocation invocation) {
                EventBroadcast.this.maybeInitialize();
                List<Dispatch<MethodInvocation>> dispatchers = EventBroadcast.this.startDispatch(this.includeLogger);
                try {
                    this.dispatch(invocation, dispatchers);
                }
                finally {
                    EventBroadcast.this.endDispatch();
                }
            }
        }
    }

    private class ListenerDetails
    implements Dispatch<MethodInvocation> {
        final Object listener;
        final Dispatch<MethodInvocation> dispatch;
        final boolean parallel;
        final AtomicBoolean removed = new AtomicBoolean();
        final ReentrantLock notifyingLock = new ReentrantLock();

        public ListenerDetails(Object listener) {
            this.listener = listener;
            this.dispatch = new ReflectionDispatch(listener);
            this.parallel = JavaReflectionUtil.hasAnnotation(listener.getClass(), ParallelListener.class);
        }

        void disconnect() {
            this.removed.set(true);
        }

        @Override
        public void dispatch(MethodInvocation message) {
            if (this.removed.get()) {
                return;
            }
            if (this.parallel) {
                this.dispatch.dispatch(message);
                return;
            }
            this.notifyingLock.lock();
            try {
                this.dispatch.dispatch(message);
            }
            finally {
                this.notifyingLock.unlock();
            }
        }

        void remove() {
            this.notifyingLock.lock();
            try {
                for (EventBroadcast broadcaster : DefaultListenerManager.this.broadcasters.values()) {
                    broadcaster.maybeRemove(this);
                }
            }
            finally {
                this.notifyingLock.unlock();
            }
        }

        void useAsLogger() {
            for (EventBroadcast broadcaster : DefaultListenerManager.this.broadcasters.values()) {
                broadcaster.maybeSetLogger(this);
            }
        }

        void useAsListener() {
            for (EventBroadcast broadcaster : DefaultListenerManager.this.broadcasters.values()) {
                broadcaster.maybeAdd(this);
            }
        }
    }

    private class ParallelEventBroadcast<T>
    extends EventBroadcast<T> {
        public ParallelEventBroadcast(Class<T> type) {
            super(type);
        }

        @Override
        protected List<Dispatch<MethodInvocation>> startDispatch(boolean includeLogger) {
            return this.getListeners(includeLogger);
        }

        @Override
        protected void endDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void assertMutable(String operation) {
            Object object = this.initializationLock;
            synchronized (object) {
                if (this.initialized) {
                    throw new IllegalStateException(String.format("Cannot %s of type %s after events have been broadcast.", operation, this.type.getSimpleName()));
                }
            }
        }
    }

    private class ExclusiveEventBroadcast<T>
    extends EventBroadcast<T> {
        private final ReentrantLock broadcasterLock;
        private final List<Runnable> queuedOperations;

        public ExclusiveEventBroadcast(Class<T> type) {
            super(type);
            this.broadcasterLock = new ReentrantLock();
            this.queuedOperations = new LinkedList<Runnable>();
        }

        @Override
        protected void doAdd(ListenerDetails listener) {
            this.executeNowOrLater(() -> ExclusiveEventBroadcast.super.doAdd(listener));
        }

        @Override
        protected void doRemove(ListenerDetails listener) {
            this.executeNowOrLater(() -> ExclusiveEventBroadcast.super.doRemove(listener));
        }

        @Override
        protected void doSetLogger(ListenerDetails candidate) {
            this.executeNowOrLater(() -> ExclusiveEventBroadcast.super.doSetLogger(candidate));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeNowOrLater(Runnable operation) {
            if (this.broadcasterLock.tryLock()) {
                try {
                    operation.run();
                    this.initLoggers();
                }
                finally {
                    this.broadcasterLock.unlock();
                }
            }
            List<Runnable> list = this.queuedOperations;
            synchronized (list) {
                this.queuedOperations.add(operation);
            }
        }

        @Override
        protected List<Dispatch<MethodInvocation>> startDispatch(boolean includeLogger) {
            if (this.broadcasterLock.isHeldByCurrentThread()) {
                throw new IllegalStateException(String.format("Cannot notify listeners of type %s as these listeners are already being notified.", this.type.getSimpleName()));
            }
            this.broadcasterLock.lock();
            return this.getListeners(includeLogger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void endDispatch() {
            try {
                List<Runnable> list = this.queuedOperations;
                synchronized (list) {
                    if (!this.queuedOperations.isEmpty()) {
                        for (Runnable queuedOperation : this.queuedOperations) {
                            queuedOperation.run();
                        }
                        this.initLoggers();
                    }
                }
            }
            finally {
                this.broadcasterLock.unlock();
            }
        }

        @Override
        protected void assertMutable(String operation) {
        }
    }
}

