/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.kotlin.dsl.KotlinDependencyExtensionsKt;
import org.gradle.kotlin.dsl.execution.KotlinMetadataCompatibilityChecker;
import org.gradle.kotlin.dsl.support.KotlinCompilerOptions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\f"}, d2={"checkAllMetadataInClasspath", "", "compileOptions", "Lorg/gradle/kotlin/dsl/support/KotlinCompilerOptions;", "classPath", "Lorg/gradle/internal/classpath/ClassPath;", "compatibilityChecker", "Lorg/gradle/kotlin/dsl/execution/KotlinMetadataCompatibilityChecker;", "issueDeprecationWarning", "files", "", "Ljava/io/File;", "kotlin-dsl"})
public final class MetadataCompatibilityCheckKt {
    public static final void checkAllMetadataInClasspath(@NotNull KotlinCompilerOptions compileOptions, @NotNull ClassPath classPath, @NotNull KotlinMetadataCompatibilityChecker compatibilityChecker) {
        Intrinsics.checkNotNullParameter((Object)compileOptions, (String)"compileOptions");
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        Intrinsics.checkNotNullParameter((Object)compatibilityChecker, (String)"compatibilityChecker");
        if (compileOptions.getExplicitSkipMetadataVersionCheck() != null) {
            return;
        }
        List<File> incompatibleFilesInClasspath = compatibilityChecker.incompatibleClasspathElements(classPath);
        if (!((Collection)incompatibleFilesInClasspath).isEmpty()) {
            MetadataCompatibilityCheckKt.issueDeprecationWarning((Iterable<? extends File>)incompatibleFilesInClasspath);
        }
    }

    private static final void issueDeprecationWarning(Iterable<? extends File> files) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"Using incompatible Kotlin dependencies in scripts without setting the 'org.gradle.kotlin.dsl.skipMetadataVersionCheck' property.").withAdvice("Using dependencies compiled with an incompatible Kotlin version has undefined behaviour and could lead to strange errors.\n\nCompatible Kotlin versions are:\n    - the CURRENT version (" + KotlinDependencyExtensionsKt.getEmbeddedKotlinVersion() + ")\n    - the NEXT version\n    - all PAST versions\n\nIncompatible dependencies were found in: " + CollectionsKt.joinToString$default(files, (CharSequence)"\n    - ", (CharSequence)"\n    - ", (CharSequence)"", (int)0, null, MetadataCompatibilityCheckKt::issueDeprecationWarning$lambda$0, (int)24, null) + ".\n\nYou have the following options:\n    Solution 1: \n        - remove the offending dependency\n        - optionally: set the property to false to enforce metadata check\n    \n    Solution 2: \n        - set the property to 'true' to disable this warning\n        \nIn Gradle 10, the property will default to 'false'.")).willBecomeAnErrorInGradle10().undocumented()).nagUser();
    }

    private static final CharSequence issueDeprecationWarning$lambda$0(File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

