/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.Incubating;
import org.gradle.api.artifacts.verification.DependencyVerificationMode;
import org.gradle.api.launcher.cli.WelcomeMessageConfiguration;
import org.gradle.api.launcher.cli.WelcomeMessageDisplayMode;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.CompositeInitScriptFinder;
import org.gradle.initialization.DistributionInitScriptFinder;
import org.gradle.initialization.UserHomeInitScriptFinder;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.internal.FileUtils;
import org.gradle.internal.RunDefaultTasksExecutionRequest;
import org.gradle.internal.concurrent.DefaultParallelismConfiguration;
import org.gradle.internal.deprecation.StartParameterDeprecations;
import org.gradle.internal.logging.DefaultLoggingConfiguration;
import org.jspecify.annotations.Nullable;

public class StartParameter
implements LoggingConfiguration,
ParallelismConfiguration,
Serializable {
    public static final String GRADLE_USER_HOME_PROPERTY_KEY = "gradle.user.home";
    public static final File DEFAULT_GRADLE_USER_HOME = new BuildLayoutParameters().getGradleUserHomeDir();
    private final DefaultLoggingConfiguration loggingConfiguration = new DefaultLoggingConfiguration();
    private final DefaultParallelismConfiguration parallelismConfiguration = new DefaultParallelismConfiguration();
    private List<TaskExecutionRequest> taskRequests = new ArrayList<TaskExecutionRequest>();
    private Set<String> excludedTaskNames = new LinkedHashSet<String>();
    private boolean buildProjectDependencies = true;
    private File currentDir;
    private File projectDir;
    private Map<String, String> projectProperties = new HashMap<String, String>();
    private Map<String, String> systemPropertiesArgs = new HashMap<String, String>();
    private File gradleUserHomeDir;
    protected File gradleHomeDir;
    private File settingsFile;
    private File buildFile;
    private List<File> initScripts = new ArrayList<File>();
    private boolean dryRun;
    private boolean rerunTasks;
    private boolean taskGraph;
    private boolean profile;
    private boolean continueOnFailure;
    private boolean offline;
    private File projectCacheDir;
    private boolean refreshDependencies;
    private boolean buildCacheEnabled;
    private boolean buildCacheDebugLogging;
    private boolean configureOnDemand;
    private boolean continuous;
    private List<File> includedBuilds = new ArrayList<File>();
    private boolean buildScan;
    private boolean noBuildScan;
    private boolean writeDependencyLocks;
    private List<String> writeDependencyVerifications = Collections.emptyList();
    private List<String> lockedDependenciesToUpdate = Collections.emptyList();
    private DependencyVerificationMode verificationMode = DependencyVerificationMode.STRICT;
    private boolean refreshKeys;
    private boolean exportKeys;
    private WelcomeMessageConfiguration welcomeMessageConfiguration = new WelcomeMessageConfiguration(WelcomeMessageDisplayMode.ONCE);

    public LogLevel getLogLevel() {
        return this.loggingConfiguration.getLogLevel();
    }

    public void setLogLevel(LogLevel logLevel) {
        this.loggingConfiguration.setLogLevel(logLevel);
    }

    public ShowStacktrace getShowStacktrace() {
        return this.loggingConfiguration.getShowStacktrace();
    }

    public void setShowStacktrace(ShowStacktrace showStacktrace) {
        this.loggingConfiguration.setShowStacktrace(showStacktrace);
    }

    public ConsoleOutput getConsoleOutput() {
        return this.loggingConfiguration.getConsoleOutput();
    }

    public void setConsoleOutput(ConsoleOutput consoleOutput) {
        this.loggingConfiguration.setConsoleOutput(consoleOutput);
    }

    public WarningMode getWarningMode() {
        return this.loggingConfiguration.getWarningMode();
    }

    public void setWarningMode(WarningMode warningMode) {
        this.loggingConfiguration.setWarningMode(warningMode);
    }

    public void setProjectCacheDir(@Nullable File projectCacheDir) {
        this.projectCacheDir = projectCacheDir;
    }

    public @Nullable File getProjectCacheDir() {
        return this.projectCacheDir;
    }

    public StartParameter() {
        this(new BuildLayoutParameters());
    }

    protected StartParameter(BuildLayoutParameters layoutParameters) {
        this.gradleHomeDir = layoutParameters.getGradleInstallationHomeDir();
        this.currentDir = layoutParameters.getCurrentDir();
        this.projectDir = layoutParameters.getProjectDir();
        this.gradleUserHomeDir = layoutParameters.getGradleUserHomeDir();
        this.setTaskNames(null);
    }

    public StartParameter newInstance() {
        return this.prepareNewInstance(new StartParameter());
    }

    protected StartParameter prepareNewInstance(StartParameter p) {
        this.prepareNewBuild(p);
        p.setWarningMode(this.getWarningMode());
        p.buildFile = this.buildFile;
        p.projectDir = this.projectDir;
        p.settingsFile = this.settingsFile;
        p.taskRequests = new ArrayList<TaskExecutionRequest>(this.taskRequests);
        p.excludedTaskNames = new LinkedHashSet<String>(this.excludedTaskNames);
        p.buildProjectDependencies = this.buildProjectDependencies;
        p.currentDir = this.currentDir;
        p.projectProperties = new HashMap<String, String>(this.projectProperties);
        p.systemPropertiesArgs = new HashMap<String, String>(this.systemPropertiesArgs);
        p.initScripts = new ArrayList<File>(this.initScripts);
        p.includedBuilds = new ArrayList<File>(this.includedBuilds);
        p.projectCacheDir = this.projectCacheDir;
        return p;
    }

    public StartParameter newBuild() {
        return this.prepareNewBuild(new StartParameter());
    }

    protected StartParameter prepareNewBuild(StartParameter p) {
        p.gradleUserHomeDir = this.gradleUserHomeDir;
        p.gradleHomeDir = this.gradleHomeDir;
        p.setLogLevel(this.getLogLevel());
        p.setConsoleOutput(this.getConsoleOutput());
        p.setShowStacktrace(this.getShowStacktrace());
        p.setWarningMode(this.getWarningMode());
        p.profile = this.profile;
        p.continueOnFailure = this.continueOnFailure;
        p.offline = this.offline;
        p.rerunTasks = this.rerunTasks;
        p.refreshDependencies = this.refreshDependencies;
        p.setParallelProjectExecutionEnabled(this.isParallelProjectExecutionEnabled());
        p.buildCacheEnabled = this.buildCacheEnabled;
        p.configureOnDemand = this.configureOnDemand;
        p.setMaxWorkerCount(this.getMaxWorkerCount());
        p.systemPropertiesArgs = new HashMap<String, String>(this.systemPropertiesArgs);
        p.writeDependencyLocks = this.writeDependencyLocks;
        p.writeDependencyVerifications = this.writeDependencyVerifications;
        p.lockedDependenciesToUpdate = new ArrayList<String>(this.lockedDependenciesToUpdate);
        p.verificationMode = this.verificationMode;
        p.refreshKeys = this.refreshKeys;
        p.exportKeys = this.exportKeys;
        p.welcomeMessageConfiguration = this.welcomeMessageConfiguration;
        p.dryRun = this.dryRun;
        p.taskGraph = this.taskGraph;
        return p;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public List<String> getTaskNames() {
        ArrayList<String> taskNames = new ArrayList<String>();
        for (TaskExecutionRequest taskRequest : this.taskRequests) {
            taskNames.addAll(taskRequest.getArgs());
        }
        return taskNames;
    }

    public void setTaskNames(@Nullable Iterable<String> taskNames) {
        this.taskRequests = taskNames == null ? Collections.singletonList(new RunDefaultTasksExecutionRequest()) : Collections.singletonList(DefaultTaskExecutionRequest.of(taskNames));
    }

    public List<TaskExecutionRequest> getTaskRequests() {
        return this.taskRequests;
    }

    public void setTaskRequests(Iterable<? extends TaskExecutionRequest> taskParameters) {
        this.taskRequests = Lists.newArrayList(taskParameters);
    }

    public Set<String> getExcludedTaskNames() {
        return this.excludedTaskNames;
    }

    public void setExcludedTaskNames(Iterable<String> excludedTaskNames) {
        this.excludedTaskNames = Sets.newLinkedHashSet(excludedTaskNames);
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public void setCurrentDir(@Nullable File currentDir) {
        this.currentDir = currentDir != null ? FileUtils.canonicalize((File)currentDir) : new BuildLayoutParameters().getCurrentDir();
    }

    public Map<String, String> getProjectProperties() {
        return this.projectProperties;
    }

    public void setProjectProperties(Map<String, String> projectProperties) {
        this.projectProperties = projectProperties;
    }

    public Map<String, String> getSystemPropertiesArgs() {
        return this.systemPropertiesArgs;
    }

    public void setSystemPropertiesArgs(Map<String, String> systemPropertiesArgs) {
        this.systemPropertiesArgs = systemPropertiesArgs;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public void setGradleUserHomeDir(@Nullable File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir == null ? new BuildLayoutParameters().getGradleUserHomeDir() : FileUtils.canonicalize((File)gradleUserHomeDir);
    }

    public boolean isBuildProjectDependencies() {
        return this.buildProjectDependencies;
    }

    public StartParameter setBuildProjectDependencies(boolean build) {
        this.buildProjectDependencies = build;
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void addInitScript(File initScriptFile) {
        this.initScripts.add(initScriptFile);
    }

    public void setInitScripts(List<File> initScripts) {
        this.initScripts = initScripts;
    }

    public List<File> getInitScripts() {
        return Collections.unmodifiableList(this.initScripts);
    }

    public List<File> getAllInitScripts() {
        CompositeInitScriptFinder initScriptFinder = new CompositeInitScriptFinder(new UserHomeInitScriptFinder(this.getGradleUserHomeDir()), new DistributionInitScriptFinder(this.gradleHomeDir));
        ArrayList<File> scripts = new ArrayList<File>(this.getInitScripts());
        initScriptFinder.findScripts(scripts);
        return Collections.unmodifiableList(scripts);
    }

    public void setProjectDir(@Nullable File projectDir) {
        if (projectDir == null) {
            this.setCurrentDir(null);
            this.projectDir = null;
        } else {
            File canonicalFile;
            this.currentDir = canonicalFile = FileUtils.canonicalize((File)projectDir);
            this.projectDir = canonicalFile;
        }
    }

    public @Nullable File getProjectDir() {
        return this.projectDir;
    }

    public void setProfile(boolean profile) {
        this.profile = profile;
    }

    public boolean isProfile() {
        return this.profile;
    }

    public boolean isContinueOnFailure() {
        return this.continueOnFailure;
    }

    public void setContinueOnFailure(boolean continueOnFailure) {
        this.continueOnFailure = continueOnFailure;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isRefreshDependencies() {
        return this.refreshDependencies;
    }

    public void setRefreshDependencies(boolean refreshDependencies) {
        this.refreshDependencies = refreshDependencies;
    }

    public boolean isRerunTasks() {
        return this.rerunTasks;
    }

    public void setRerunTasks(boolean rerunTasks) {
        this.rerunTasks = rerunTasks;
    }

    public boolean isTaskGraph() {
        return this.taskGraph;
    }

    public void setTaskGraph(boolean taskGraph) {
        this.taskGraph = taskGraph;
    }

    @Override
    public boolean isParallelProjectExecutionEnabled() {
        return this.parallelismConfiguration.isParallelProjectExecutionEnabled();
    }

    @Override
    public void setParallelProjectExecutionEnabled(boolean parallelProjectExecution) {
        this.parallelismConfiguration.setParallelProjectExecutionEnabled(parallelProjectExecution);
    }

    public boolean isBuildCacheEnabled() {
        return this.buildCacheEnabled;
    }

    public void setBuildCacheEnabled(boolean buildCacheEnabled) {
        this.buildCacheEnabled = buildCacheEnabled;
    }

    public boolean isBuildCacheDebugLogging() {
        return this.buildCacheDebugLogging;
    }

    public void setBuildCacheDebugLogging(boolean buildCacheDebugLogging) {
        this.buildCacheDebugLogging = buildCacheDebugLogging;
    }

    @Override
    public int getMaxWorkerCount() {
        return this.parallelismConfiguration.getMaxWorkerCount();
    }

    @Override
    public void setMaxWorkerCount(int maxWorkerCount) {
        this.parallelismConfiguration.setMaxWorkerCount(maxWorkerCount);
    }

    @Incubating
    public boolean isConfigureOnDemand() {
        return this.configureOnDemand;
    }

    public String toString() {
        return "StartParameter{taskRequests=" + this.taskRequests + ", excludedTaskNames=" + this.excludedTaskNames + ", buildProjectDependencies=" + this.buildProjectDependencies + ", currentDir=" + this.currentDir + ", projectDir=" + this.projectDir + ", projectProperties=" + this.projectProperties + ", systemPropertiesArgs=" + this.systemPropertiesArgs + ", gradleUserHomeDir=" + this.gradleUserHomeDir + ", gradleHome=" + this.gradleHomeDir + ", logLevel=" + this.getLogLevel() + ", showStacktrace=" + this.getShowStacktrace() + ", settingsFile=" + this.settingsFile + ", buildFile=" + this.buildFile + ", initScripts=" + this.initScripts + ", dryRun=" + this.dryRun + ", rerunTasks=" + this.rerunTasks + ", taskGraph=" + this.taskGraph + ", profile=" + this.profile + ", continueOnFailure=" + this.continueOnFailure + ", offline=" + this.offline + ", projectCacheDir=" + this.projectCacheDir + ", refreshDependencies=" + this.refreshDependencies + ", buildCacheEnabled=" + this.buildCacheEnabled + ", buildCacheDebugLogging=" + this.buildCacheDebugLogging + ", parallelProjectExecution=" + this.isParallelProjectExecutionEnabled() + ", configureOnDemand=" + this.configureOnDemand + ", continuous=" + this.continuous + ", maxWorkerCount=" + this.getMaxWorkerCount() + ", includedBuilds=" + this.includedBuilds + ", buildScan=" + this.buildScan + ", noBuildScan=" + this.noBuildScan + ", writeDependencyLocks=" + this.writeDependencyLocks + ", writeDependencyVerifications=" + this.writeDependencyVerifications + ", lockedDependenciesToUpdate=" + this.lockedDependenciesToUpdate + ", verificationMode=" + (Object)((Object)this.verificationMode) + ", refreshKeys=" + this.refreshKeys + ", exportKeys=" + this.exportKeys + ", welcomeMessageConfiguration=" + this.welcomeMessageConfiguration + '}';
    }

    void setGradleHomeDir(File gradleHomeDir) {
        this.gradleHomeDir = gradleHomeDir;
    }

    @Incubating
    public void setConfigureOnDemand(boolean configureOnDemand) {
        this.configureOnDemand = configureOnDemand;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean enabled) {
        this.continuous = enabled;
    }

    public void includeBuild(File includedBuild) {
        this.includedBuilds.add(includedBuild);
    }

    public void setIncludedBuilds(List<File> includedBuilds) {
        this.includedBuilds = includedBuilds;
    }

    public List<File> getIncludedBuilds() {
        return Collections.unmodifiableList(this.includedBuilds);
    }

    public boolean isBuildScan() {
        return this.buildScan;
    }

    public void setBuildScan(boolean buildScan) {
        this.buildScan = buildScan;
    }

    public boolean isNoBuildScan() {
        return this.noBuildScan;
    }

    public void setNoBuildScan(boolean noBuildScan) {
        this.noBuildScan = noBuildScan;
    }

    public void setWriteDependencyLocks(boolean writeDependencyLocks) {
        this.writeDependencyLocks = writeDependencyLocks;
    }

    public boolean isWriteDependencyLocks() {
        return this.writeDependencyLocks;
    }

    public void setLockedDependenciesToUpdate(List<String> lockedDependenciesToUpdate) {
        this.lockedDependenciesToUpdate = Lists.newArrayList(lockedDependenciesToUpdate);
        this.writeDependencyLocks = true;
    }

    public List<String> getWriteDependencyVerifications() {
        return this.writeDependencyVerifications;
    }

    public void setWriteDependencyVerifications(List<String> checksums) {
        this.writeDependencyVerifications = checksums;
    }

    public List<String> getLockedDependenciesToUpdate() {
        return this.lockedDependenciesToUpdate;
    }

    public void setDependencyVerificationMode(DependencyVerificationMode verificationMode) {
        this.verificationMode = verificationMode;
    }

    public DependencyVerificationMode getDependencyVerificationMode() {
        return this.verificationMode;
    }

    public void setRefreshKeys(boolean refresh) {
        this.refreshKeys = refresh;
    }

    public boolean isRefreshKeys() {
        return this.refreshKeys;
    }

    public boolean isExportKeys() {
        return this.exportKeys;
    }

    public void setExportKeys(boolean exportKeys) {
        this.exportKeys = exportKeys;
    }

    @Incubating
    public WelcomeMessageConfiguration getWelcomeMessageConfiguration() {
        return this.welcomeMessageConfiguration;
    }

    @Incubating
    public void setWelcomeMessageConfiguration(WelcomeMessageConfiguration welcomeMessageConfiguration) {
        this.welcomeMessageConfiguration = welcomeMessageConfiguration;
    }

    @Incubating
    @Deprecated
    public boolean isConfigurationCacheRequested() {
        StartParameterDeprecations.nagOnIsConfigurationCacheRequested();
        return false;
    }
}

