/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.inspection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.Cast;
import org.gradle.internal.inspection.TypeParameterInspection;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.Types;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DefaultTypeParameterInspection<INTERFACE, PARAMS>
implements TypeParameterInspection<INTERFACE, PARAMS> {
    private final Class<INTERFACE> interfaceType;
    private final Class<PARAMS> paramsType;
    private final Class<? extends PARAMS> noParamsType;

    public DefaultTypeParameterInspection(Class<INTERFACE> interfaceType, Class<PARAMS> paramsType, Class<? extends PARAMS> noParamsType) {
        this.interfaceType = interfaceType;
        this.paramsType = paramsType;
        this.noParamsType = noParamsType;
    }

    @Override
    public <T extends INTERFACE, P extends PARAMS> @Nullable Class<P> parameterTypeFor(Class<T> implementationType) {
        return this.parameterTypeFor(implementationType, 0);
    }

    @Override
    public <T extends INTERFACE, P extends PARAMS> @Nullable Class<P> parameterTypeFor(Class<T> implementationType, int typeArgumentIndex) {
        if (implementationType == this.interfaceType) {
            return null;
        }
        Class<P> parametersType = this.inferParameterType(implementationType, typeArgumentIndex);
        if (parametersType == this.paramsType) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not create the parameters for ");
            formatter.appendType(implementationType);
            formatter.append((CharSequence)": must use a sub-type of ");
            formatter.appendType(parametersType);
            formatter.append((CharSequence)" as the parameters type. Use ");
            formatter.appendType(this.noParamsType);
            formatter.append((CharSequence)" as the parameters type for implementations that do not take parameters.");
            throw new IllegalArgumentException(formatter.toString());
        }
        if (parametersType == this.noParamsType) {
            return null;
        }
        return parametersType;
    }

    private <T extends INTERFACE, P extends PARAMS> @NonNull Class<P> inferParameterType(Class<T> implementationType, int typeArgumentIndex) {
        AtomicReference foundType = new AtomicReference();
        HashMap collectedTypes = new HashMap();
        Types.walkTypeHierarchy(implementationType, type -> {
            for (Type genericInterface : type.getGenericInterfaces()) {
                if (!this.collectTypeParameters(genericInterface, foundType, collectedTypes, typeArgumentIndex)) continue;
                return Types.TypeVisitResult.TERMINATE;
            }
            Type genericSuperclass = type.getGenericSuperclass();
            if (this.collectTypeParameters(genericSuperclass, foundType, collectedTypes, typeArgumentIndex)) {
                return Types.TypeVisitResult.TERMINATE;
            }
            return Types.TypeVisitResult.CONTINUE;
        });
        Type type2 = this.unwrapTypeVariable((Type)foundType.get());
        return type2 instanceof Class ? (Class)Cast.uncheckedNonnullCast((Object)type2) : (type2 instanceof ParameterizedType ? (Class)Cast.uncheckedNonnullCast((Object)((ParameterizedType)type2).getRawType()) : (Class)Cast.uncheckedNonnullCast(this.paramsType));
    }

    private boolean collectTypeParameters(Type type, AtomicReference<Type> foundType, Map<Type, Type> collectedTypeParameters, int typeArgumentIndex) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType().equals(this.interfaceType)) {
                Type parameter = parameterizedType.getActualTypeArguments()[typeArgumentIndex];
                foundType.set(collectedTypeParameters.getOrDefault(parameter, parameter));
                return true;
            }
            Type[] actualTypes = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = ((Class)parameterizedType.getRawType()).getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Type firstActualInTypeChain = collectedTypeParameters.getOrDefault(actualTypes[i], actualTypes[i]);
                collectedTypeParameters.put(typeParameters[i], firstActualInTypeChain);
            }
        }
        return false;
    }

    private Type unwrapTypeVariable(Type type) {
        if (type instanceof TypeVariable) {
            Type nextType;
            ArrayDeque<Type> queue = new ArrayDeque<Type>();
            queue.add(type);
            while ((nextType = (Type)queue.poll()) != null) {
                for (Type bound : ((TypeVariable)nextType).getBounds()) {
                    if (bound instanceof TypeVariable) {
                        queue.add(bound);
                        continue;
                    }
                    if (!DefaultTypeParameterInspection.isAssignableFromType(this.paramsType, bound)) continue;
                    return bound;
                }
            }
        }
        return type;
    }

    private static boolean isAssignableFromType(Class<?> clazz, Type type) {
        return type instanceof Class && clazz.isAssignableFrom((Class)type) || type instanceof ParameterizedType && clazz.isAssignableFrom((Class)((ParameterizedType)type).getRawType());
    }
}

