/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import org.gradle.internal.collect.PersistentArray;
import org.gradle.internal.collect.PersistentArraySmall;
import org.gradle.internal.collect.PersistentArrayTrie;
import org.gradle.internal.collect.SingletonIterator;

final class PersistentArray1<T>
implements PersistentArray<T> {
    private final T value;

    public PersistentArray1(T value) {
        this.value = value;
    }

    @Override
    public PersistentArray<T> plus(T value) {
        return new PersistentArraySmall(new Object[]{this.value, value});
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(T value) {
        return Objects.equals(value, this.value);
    }

    @Override
    public T get(int index) {
        if (index != 0) {
            throw PersistentArrayTrie.indexOutOfBounds(index);
        }
        return this.value;
    }

    @Override
    public T getLast() {
        return this.value;
    }

    @Override
    public Iterator<T> iterator() {
        return new SingletonIterator<T>(this.value);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        action.accept(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PersistentArray1) {
            return ((PersistentArray1)obj).value.equals(this.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "[" + this.value + "]";
    }
}

