/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import org.gradle.internal.collect.ChampNode;
import org.gradle.internal.collect.HashCollisionNode;

final class ChampLookup {
    ChampLookup() {
    }

    static <K> boolean containsKey(ChampNode<K> node, K key, int payload) {
        return ChampLookup.lookup(node, key, payload, Boolean.FALSE, (content, index) -> Boolean.TRUE) == Boolean.TRUE;
    }

    static <K, V> V lookup(ChampNode<K> trie, K key, int payload, V defaultValue, LookupResult<V> result) {
        block4: {
            int index;
            Object node;
            int shift = 0;
            int hash = key.hashCode();
            while (true) {
                int mask;
                int bit;
                int dataMap;
                if (((dataMap = trie.dataMap) & (bit = 1 << (mask = ChampNode.mask(hash, shift)))) == bit) {
                    Object[] content = trie.content;
                    int dataIndex = ChampNode.index(dataMap, mask, bit) << payload;
                    Object data = content[dataIndex];
                    if (data == key || data.equals(key)) {
                        return result.apply(content, dataIndex);
                    }
                    break block4;
                }
                int nodeMap = trie.nodeMap;
                if ((nodeMap & bit) != bit) break block4;
                Object[] content = trie.content;
                int nodeIndex = ChampNode.nodeIndex(content, nodeMap, mask, bit);
                node = content[nodeIndex];
                if (!(node instanceof ChampNode)) break;
                trie = (ChampNode)node;
                shift += 5;
            }
            HashCollisionNode collision = (HashCollisionNode)node;
            if (collision.hash == hash && (index = collision.indexOf(key, payload)) >= 0) {
                return result.apply(collision.content, index);
            }
        }
        return defaultValue;
    }

    @FunctionalInterface
    static interface LookupResult<V> {
        public V apply(Object[] var1, int var2);
    }
}

