/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report.generic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputEntry;
import org.gradle.api.internal.tasks.testing.results.serializable.OutputRanges;
import org.gradle.api.internal.tasks.testing.results.serializable.SerializableTestResult;
import org.gradle.api.tasks.testing.TestMetadataEvent;
import org.gradle.api.tasks.testing.TestResult;

public abstract class PerRootInfo {
    private final long id;

    private PerRootInfo(long id) {
        this.id = id;
    }

    public abstract List<SerializableTestResult> getResults();

    public long getId() {
        return this.id;
    }

    public abstract List<OutputEntry> getOutputEntries();

    public abstract List<String> getChildren();

    public abstract int getTotalLeafCount();

    public abstract int getFailedLeafCount();

    public abstract int getSkippedLeafCount();

    public abstract Iterable<TestMetadataEvent> getMetadatas();

    private static final class MultiResultContainer
    extends PerRootInfo {
        private final List<SerializableTestResult> result;
        private final List<OutputEntry> outputEntries;
        private final ImmutableList<String> children;
        private final int totalLeafCount;
        private final int failedLeafCount;
        private final int skippedLeafCount;

        private MultiResultContainer(long id, List<SerializableTestResult> result, List<OutputEntry> outputEntries, ImmutableList<String> children, int totalLeafCount, int failedLeafCount, int skippedLeafCount) {
            super(id);
            this.result = result;
            this.outputEntries = outputEntries;
            this.children = children;
            this.totalLeafCount = totalLeafCount;
            this.failedLeafCount = failedLeafCount;
            this.skippedLeafCount = skippedLeafCount;
        }

        @Override
        public List<SerializableTestResult> getResults() {
            return this.result;
        }

        @Override
        public List<OutputEntry> getOutputEntries() {
            return this.outputEntries;
        }

        @Override
        public List<String> getChildren() {
            return this.children;
        }

        @Override
        public int getTotalLeafCount() {
            return this.totalLeafCount;
        }

        @Override
        public int getFailedLeafCount() {
            return this.failedLeafCount;
        }

        @Override
        public int getSkippedLeafCount() {
            return this.skippedLeafCount;
        }

        @Override
        public Iterable<TestMetadataEvent> getMetadatas() {
            return Iterables.concat((Iterable)Iterables.transform(this.getResults(), SerializableTestResult::getMetadatas));
        }
    }

    private static final class SingleResultContainer
    extends PerRootInfo {
        private final SerializableTestResult result;
        private final OutputRanges outputRanges;
        private final ImmutableList<String> children;
        private final int totalLeafCount;
        private final int failedLeafCount;
        private final int skippedLeafCount;

        private SingleResultContainer(long id, SerializableTestResult result, OutputRanges outputRanges, ImmutableList<String> children, int totalLeafCount, int failedLeafCount, int skippedLeafCount) {
            super(id);
            this.result = result;
            this.outputRanges = outputRanges;
            this.children = children;
            this.totalLeafCount = totalLeafCount;
            this.failedLeafCount = failedLeafCount;
            this.skippedLeafCount = skippedLeafCount;
        }

        @Override
        public List<SerializableTestResult> getResults() {
            return Collections.singletonList(this.result);
        }

        @Override
        public List<OutputEntry> getOutputEntries() {
            return Collections.singletonList(new OutputEntry(this.getId(), this.outputRanges));
        }

        @Override
        public List<String> getChildren() {
            return this.children;
        }

        @Override
        public int getTotalLeafCount() {
            return this.totalLeafCount;
        }

        @Override
        public int getFailedLeafCount() {
            return this.failedLeafCount;
        }

        @Override
        public int getSkippedLeafCount() {
            return this.skippedLeafCount;
        }

        @Override
        public Iterable<TestMetadataEvent> getMetadatas() {
            return this.result.getMetadatas();
        }
    }

    private static final class SingleResultLeaf
    extends PerRootInfo {
        private final SerializableTestResult result;
        private final OutputRanges outputRanges;

        private SingleResultLeaf(long id, SerializableTestResult result, OutputRanges outputRanges) {
            super(id);
            this.result = result;
            this.outputRanges = outputRanges;
        }

        @Override
        public List<SerializableTestResult> getResults() {
            return Collections.singletonList(this.result);
        }

        @Override
        public List<OutputEntry> getOutputEntries() {
            return Collections.singletonList(new OutputEntry(this.getId(), this.outputRanges));
        }

        @Override
        public List<String> getChildren() {
            return Collections.emptyList();
        }

        @Override
        public int getTotalLeafCount() {
            return 1;
        }

        @Override
        public int getFailedLeafCount() {
            return this.result.getResultType() == TestResult.ResultType.FAILURE ? 1 : 0;
        }

        @Override
        public int getSkippedLeafCount() {
            return this.result.getResultType() == TestResult.ResultType.SKIPPED ? 1 : 0;
        }

        @Override
        public Iterable<TestMetadataEvent> getMetadatas() {
            return this.result.getMetadatas();
        }
    }

    public static final class Builder {
        private final long id;
        private final List<SerializableTestResult> results;
        private final List<OutputEntry> outputEntries;
        private final List<String> children;
        private final BitSet childIsLeaf;
        private int totalLeafCount;
        private int failedLeafCount;
        private int skippedLeafCount;

        public Builder(long id, SerializableTestResult result, OutputRanges ranges, List<String> childNames, BitSet childIsLeaf, int totalLeafCount, int failedLeafCount, int skippedLeafCount) {
            this.id = id;
            this.results = new ArrayList<SerializableTestResult>(Collections.singletonList(result));
            this.outputEntries = new ArrayList<OutputEntry>(Collections.singletonList(new OutputEntry(id, ranges)));
            this.children = new ArrayList<String>(childNames);
            this.childIsLeaf = childIsLeaf;
            this.totalLeafCount = totalLeafCount;
            this.failedLeafCount = failedLeafCount;
            this.skippedLeafCount = skippedLeafCount;
        }

        public String getName() {
            return this.results.get(0).getName();
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public int getTotalLeafCount() {
            return this.totalLeafCount;
        }

        public int getFailedLeafCount() {
            return this.failedLeafCount;
        }

        public int getSkippedLeafCount() {
            return this.skippedLeafCount;
        }

        public void merge(Builder otherBuilder) {
            ImmutableSet knownChildren = ImmutableSet.copyOf(this.children);
            List<String> strings = otherBuilder.children;
            for (int i = 0; i < strings.size(); ++i) {
                String newChild = strings.get(i);
                boolean newChildIsLeaf = otherBuilder.childIsLeaf.get(i);
                if (!newChildIsLeaf && knownChildren.contains(newChild) && this.isExistingNonLeafChild(newChild)) continue;
                this.children.add(newChild);
                if (!newChildIsLeaf) continue;
                this.childIsLeaf.set(this.children.size() - 1);
            }
            this.totalLeafCount += otherBuilder.totalLeafCount;
            this.failedLeafCount += otherBuilder.failedLeafCount;
            this.skippedLeafCount += otherBuilder.skippedLeafCount;
            if (!otherBuilder.getName().equals(this.getName())) {
                throw new IllegalArgumentException("Cannot merge PerRootInfo.Builder with different names: " + this.getName() + " and " + otherBuilder.getName());
            }
            this.results.addAll(otherBuilder.results);
            this.outputEntries.addAll(otherBuilder.outputEntries);
        }

        private boolean isExistingNonLeafChild(String child) {
            boolean anyNonLeaf = false;
            for (int j = 0; j < this.children.size(); ++j) {
                if (!this.children.get(j).equals(child) || this.childIsLeaf.get(j)) continue;
                anyNonLeaf = true;
                break;
            }
            return anyNonLeaf;
        }

        public PerRootInfo build() {
            if (this.isLeaf()) {
                if (this.results.size() > 1) {
                    throw new IllegalStateException("Cannot build a leaf PerRootInfo with multiple results");
                }
                if (this.totalLeafCount != 1 || this.failedLeafCount > 1 || this.skippedLeafCount > 1) {
                    throw new IllegalStateException("Inconsistent leaf counts for leaf PerRootInfo: total=" + this.totalLeafCount + ", failed=" + this.failedLeafCount + ", skipped=" + this.skippedLeafCount);
                }
                return new SingleResultLeaf(this.id, this.results.get(0), this.outputEntries.get(0).getOutputRanges());
            }
            if (this.results.size() == 1) {
                return new SingleResultContainer(this.id, this.results.get(0), this.outputEntries.get(0).getOutputRanges(), ImmutableList.copyOf(this.children), this.totalLeafCount, this.failedLeafCount, this.skippedLeafCount);
            }
            return new MultiResultContainer(this.id, (List)ImmutableList.copyOf(this.results), (List)ImmutableList.copyOf(this.outputEntries), ImmutableList.copyOf(this.children), this.totalLeafCount, this.failedLeafCount, this.skippedLeafCount);
        }
    }
}

