/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.internal.instrumentation.api.jvmbytecode.JvmBytecodeCallInterceptor;
import org.gradle.internal.lazy.Lazy;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface JvmBytecodeInterceptorFactoryProvider {
    public static final JvmBytecodeInterceptorFactoryProvider DEFAULT = new ClassLoaderSourceJvmBytecodeInterceptorFactoryProvider(JvmBytecodeInterceptorFactoryProvider.class.getClassLoader());

    public List<JvmBytecodeCallInterceptor.Factory> getInterceptorFactories();

    default public JvmBytecodeInterceptorFactoryProvider plus(JvmBytecodeInterceptorFactoryProvider other) {
        return new CompositeJvmBytecodeInterceptorFactoryProvider(this, other);
    }

    @NullMarked
    public static class CompositeJvmBytecodeInterceptorFactoryProvider
    implements JvmBytecodeInterceptorFactoryProvider {
        private final JvmBytecodeInterceptorFactoryProvider first;
        private final JvmBytecodeInterceptorFactoryProvider second;

        public CompositeJvmBytecodeInterceptorFactoryProvider(JvmBytecodeInterceptorFactoryProvider first, JvmBytecodeInterceptorFactoryProvider second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public List<JvmBytecodeCallInterceptor.Factory> getInterceptorFactories() {
            return ImmutableList.copyOf(Stream.of(this.first.getInterceptorFactories(), this.second.getInterceptorFactories()).flatMap(Collection::stream).collect(Collectors.toMap(interceptor -> interceptor.getClass().getName(), p -> p, (p, q) -> p, LinkedHashMap::new)).values());
        }
    }

    @NullMarked
    public static class ClassLoaderSourceJvmBytecodeInterceptorFactoryProvider
    implements JvmBytecodeInterceptorFactoryProvider {
        private final Lazy<List<JvmBytecodeCallInterceptor.Factory>> factories = Lazy.locking().of(() -> ClassLoaderSourceJvmBytecodeInterceptorFactoryProvider.loadFactories(classLoader, forPackage));

        public ClassLoaderSourceJvmBytecodeInterceptorFactoryProvider(ClassLoader classLoader) {
            this(classLoader, "");
        }

        @VisibleForTesting
        public ClassLoaderSourceJvmBytecodeInterceptorFactoryProvider(ClassLoader classLoader, String forPackage) {
        }

        private static List<JvmBytecodeCallInterceptor.Factory> loadFactories(ClassLoader classLoader, String forPackage) {
            ImmutableList.Builder factories = ImmutableList.builder();
            for (JvmBytecodeCallInterceptor.Factory factory : ServiceLoader.load(JvmBytecodeCallInterceptor.Factory.class, classLoader)) {
                if (!factory.getClass().getPackage().getName().startsWith(forPackage)) continue;
                factories.add((Object)factory);
            }
            return factories.build();
        }

        @Override
        public List<JvmBytecodeCallInterceptor.Factory> getInterceptorFactories() {
            return (List)this.factories.get();
        }
    }
}

