/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.properties.GradlePropertiesController;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsState;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutFactory;

public class GradlePropertiesHandlingSettingsLoader
implements SettingsLoader {
    private final SettingsLoader delegate;
    private final BuildLayoutFactory buildLayoutFactory;
    private final GradlePropertiesController gradlePropertiesController;

    public GradlePropertiesHandlingSettingsLoader(SettingsLoader delegate, BuildLayoutFactory buildLayoutFactory, GradlePropertiesController gradlePropertiesController) {
        this.delegate = delegate;
        this.buildLayoutFactory = buildLayoutFactory;
        this.gradlePropertiesController = gradlePropertiesController;
    }

    @Override
    public SettingsState findAndLoadSettings(GradleInternal gradle) {
        BuildLayout settingsLocation = this.buildLayoutFactory.getLayoutFor(gradle.getStartParameter().toBuildLayoutConfiguration());
        BuildIdentifier buildId = gradle.getOwner().getBuildIdentifier();
        this.gradlePropertiesController.loadGradleProperties(buildId, settingsLocation.getSettingsDir(), true);
        return this.delegate.findAndLoadSettings(gradle);
    }
}

