/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.gradle.internal.collect.PersistentMap;
import org.gradle.internal.collect.PersistentSet0;
import org.gradle.internal.collect.PersistentSet1;
import org.gradle.internal.collect.PersistentSetCollector;
import org.gradle.internal.collect.Preconditions;
import org.jspecify.annotations.Nullable;

public interface PersistentSet<K>
extends Iterable<K> {
    public static <K> PersistentSet<K> of() {
        return PersistentSet0.INSTANCE;
    }

    public static <K> PersistentSet<K> of(K key) {
        Preconditions.keyCannotBeNull(key);
        return new PersistentSet1<K>(key);
    }

    public static <K> PersistentSet<K> of(K ... keys) {
        PersistentSet<K> copy = PersistentSet.of();
        for (K key : keys) {
            copy = copy.plus(key);
        }
        return copy;
    }

    public static <K> PersistentSet<K> copyOf(Iterable<K> keys) {
        if (keys instanceof PersistentSet) {
            return (PersistentSet)keys;
        }
        PersistentSet<K> copy = PersistentSet.of();
        for (K key : keys) {
            copy = copy.plus(key);
        }
        return copy;
    }

    public static <K> Collector<K, Object, PersistentSet<K>> toPersistentSet() {
        return PersistentSetCollector.INSTANCE;
    }

    public PersistentSet<K> plus(K var1);

    public PersistentSet<K> minus(K var1);

    public PersistentSet<K> minusAll(Iterable<K> var1);

    public boolean contains(K var1);

    public int size();

    public boolean isEmpty();

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public <S extends K> PersistentSet<K> union(PersistentSet<S> var1);

    public PersistentSet<K> intersect(PersistentSet<K> var1);

    public PersistentSet<K> except(PersistentSet<K> var1);

    public PersistentSet<K> filter(Predicate<? super K> var1);

    public <R> PersistentSet<R> map(Function<? super K, ? extends R> var1);

    public <R> PersistentSet<R> flatMap(Function<? super K, PersistentSet<R>> var1);

    public <G> PersistentMap<G, PersistentSet<K>> groupBy(Function<? super K, ? extends @Nullable G> var1);

    public boolean anyMatch(Predicate<? super K> var1);

    public boolean noneMatch(Predicate<? super K> var1);

    default public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            Class<?> newType = a.getClass();
            a = newType == Object[].class ? new Object[size] : (Object[])Array.newInstance(newType.getComponentType(), size);
        }
        Iterator iterator = this.iterator();
        for (int i = size - 1; i >= 0; --i) {
            a[i] = iterator.next();
        }
        return a;
    }
}

