/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.gradle.internal.collect.PersistentArray;
import org.gradle.internal.collect.PersistentMap;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.service.AnnotatedServiceLifecycleHandler;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.ContainsServices;
import org.gradle.internal.service.InjectUtil;
import org.gradle.internal.service.PrivateService;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.RelevantMethods;
import org.gradle.internal.service.ScopedServiceRegistry;
import org.gradle.internal.service.Service;
import org.gradle.internal.service.ServiceAccess;
import org.gradle.internal.service.ServiceAccessScope;
import org.gradle.internal.service.ServiceAccessToken;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceMethod;
import org.gradle.internal.service.ServiceProvider;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationAction;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceValidationException;
import org.gradle.internal.service.TypeStringFormatter;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.util.internal.CollectionUtils;
import org.jspecify.annotations.Nullable;

public class DefaultServiceRegistry
implements CloseableServiceRegistry,
ContainsServices {
    private static final ServiceRegistry[] NO_PARENTS = new ServiceRegistry[0];
    private static final Service[] NO_DEPENDENTS = new Service[0];
    private static final Object[] NO_PARAMS = new Object[0];
    private final ClassInspector inspector;
    private final OwnServices ownServices;
    private final ServiceProvider allServices;
    private final @Nullable ServiceProvider parentServices;
    private final @Nullable String displayName;
    private final ServiceProvider thisAsServiceProvider;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);

    private static void assertAllowedImplementation(Class<? extends DefaultServiceRegistry> impl) {
        if (impl != ScopedServiceRegistry.class && impl != DefaultServiceRegistry.class) {
            throw new IllegalArgumentException(String.format("Inheriting from %s is not allowed. Use ServiceRegistryBuilder instead.", DefaultServiceRegistry.class.getSimpleName()));
        }
    }

    public DefaultServiceRegistry() {
        this((String)null, NO_PARENTS);
    }

    public DefaultServiceRegistry(String displayName) {
        this(displayName, NO_PARENTS);
    }

    public DefaultServiceRegistry(ServiceRegistry ... parents) {
        this((String)null, parents);
    }

    public DefaultServiceRegistry(@Nullable String displayName, ServiceRegistry ... parents) {
        DefaultServiceRegistry.assertAllowedImplementation(this.getClass());
        this.displayName = displayName;
        this.ownServices = new OwnServices();
        if (parents.length == 0) {
            this.parentServices = null;
            this.allServices = this.ownServices;
            this.inspector = new ClassInspector();
        } else {
            this.parentServices = DefaultServiceRegistry.setupParentServices(parents);
            this.allServices = new CompositeServiceProvider(new ServiceProvider[]{this.ownServices, this.parentServices});
            this.inspector = parents[0] instanceof DefaultServiceRegistry ? ((DefaultServiceRegistry)parents[0]).inspector : new ClassInspector();
        }
        this.thisAsServiceProvider = this.allServices;
    }

    private static ServiceProvider setupParentServices(ServiceRegistry[] parents) {
        ServiceProvider parentServices;
        if (parents.length == 1) {
            parentServices = DefaultServiceRegistry.toParentServices(parents[0]);
        } else {
            ServiceProvider[] parentServiceProviders = new ServiceProvider[parents.length];
            for (int i = 0; i < parents.length; ++i) {
                parentServiceProviders[i] = DefaultServiceRegistry.toParentServices(parents[i]);
            }
            parentServices = new CompositeServiceProvider(parentServiceProviders);
        }
        return parentServices;
    }

    @Override
    public ServiceProvider asProvider() {
        return this.thisAsServiceProvider;
    }

    private static ServiceProvider toParentServices(ServiceRegistry serviceRegistry) {
        if (serviceRegistry instanceof ContainsServices) {
            return new ParentServices(((ContainsServices)serviceRegistry).asProvider());
        }
        throw new IllegalArgumentException(String.format("Service registry %s cannot be used as a parent for another service registry.", serviceRegistry));
    }

    public static ServiceRegistry create(ServiceRegistrationProvider ... providers) {
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        for (ServiceRegistrationProvider provider : providers) {
            registry.addProvider(provider);
        }
        return registry;
    }

    private String getDisplayName() {
        return this.displayName == null ? this.getClass().getSimpleName() : this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private void findProviderMethods(ServiceRegistrationProvider target, ServiceAccessToken token) {
        Class<?> type = target.getClass();
        RelevantMethods methods = RelevantMethods.getMethods(type);
        for (ServiceMethod method : methods.decorators) {
            if (this.parentServices == null) {
                throw new ServiceLookupException(String.format("Cannot use decorator method %s.%s() when no parent registry is provided.", type.getSimpleName(), method.getName()));
            }
            this.ownServices.add(new FactoryMethodService(this, DefaultServiceRegistry.determineAccessScope(method, token), token, target, method));
        }
        for (ServiceMethod method : methods.factories) {
            this.ownServices.add(new FactoryMethodService(this, DefaultServiceRegistry.determineAccessScope(method, token), token, target, method));
        }
        for (ServiceMethod method : methods.configurers) {
            this.applyConfigureMethod(token, method, target);
        }
    }

    private static ServiceAccessScope determineAccessScope(ServiceMethod method, ServiceAccessToken token) {
        PrivateService privateService = method.getMethod().getAnnotation(PrivateService.class);
        return privateService != null ? ServiceAccess.getPrivateScope(token) : ServiceAccess.getPublicScope();
    }

    private void applyConfigureMethod(ServiceAccessToken token, ServiceMethod method, Object target) {
        Object[] params = new Object[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Type paramType = method.getParameterTypes()[i];
            if (paramType.equals(ServiceRegistration.class)) {
                params[i] = this.newRegistration(token);
                continue;
            }
            Service paramProvider = DefaultServiceRegistry.find(paramType, token, this.allServices);
            if (paramProvider == null) {
                throw new ServiceLookupException(String.format("Cannot configure services using %s.%s() as required service of type %s is not available.", method.getOwner().getSimpleName(), method.getName(), DefaultServiceRegistry.format(paramType)));
            }
            params[i] = paramProvider.get();
        }
        try {
            method.invoke(target, params);
        }
        catch (Exception e) {
            throw new ServiceLookupException(String.format("Could not configure services using %s.%s().", method.getOwner().getSimpleName(), method.getName()), (Throwable)e);
        }
    }

    public void register(ServiceRegistrationAction action) {
        this.assertMutable();
        ServiceAccessToken token = ServiceAccess.createToken(DefaultServiceRegistry.format(action.getClass()));
        action.registerServices(this.newRegistration(token));
    }

    private void assertMutable() {
        if (this.state.get() != State.INIT) {
            throw new IllegalStateException("Cannot add services to service registry " + this + " as it is no longer mutable");
        }
    }

    private ServiceRegistration newRegistration(final ServiceAccessToken token) {
        return new ServiceRegistration(){

            public <T> void add(Class<T> serviceType, T serviceInstance) {
                DefaultServiceRegistry.this.add(ServiceAccess.getPublicScope(), serviceType, serviceInstance);
            }

            public void add(Class<?> serviceType) {
                DefaultServiceRegistry.this.ownServices.add(new ConstructorService(DefaultServiceRegistry.this, ServiceAccess.getPublicScope(), token, (Class)serviceType));
            }

            public <T> void add(Class<? super T> serviceType, Class<T> implementationType) {
                DefaultServiceRegistry.this.ownServices.add(new ConstructorService(DefaultServiceRegistry.this, ServiceAccess.getPublicScope(), token, serviceType, implementationType));
            }

            public <T> void add(Class<? super T> serviceType1, Class<? super T> serviceType2, Class<T> implementationType) {
                DefaultServiceRegistry.this.ownServices.add(new ConstructorService(DefaultServiceRegistry.this, ServiceAccess.getPublicScope(), token, Arrays.asList(serviceType1, serviceType2), implementationType));
            }

            public void addProvider(ServiceRegistrationProvider provider) {
                DefaultServiceRegistry.this.addProvider(provider);
            }
        };
    }

    public <T> DefaultServiceRegistry add(Class<? extends T> serviceType, T serviceInstance) {
        this.add(ServiceAccess.getPublicScope(), serviceType, serviceInstance);
        return this;
    }

    public DefaultServiceRegistry add(Object serviceInstance) {
        return this.add(serviceInstance.getClass(), serviceInstance);
    }

    private <T> void add(ServiceAccessScope accessScope, Class<? extends T> serviceType, T serviceInstance) {
        this.assertMutable();
        this.ownServices.add(new FixedInstanceService(this, accessScope, serviceType, serviceInstance));
    }

    public DefaultServiceRegistry addProvider(ServiceRegistrationProvider provider) {
        this.assertMutable();
        ServiceAccessToken token = ServiceAccess.createToken(DefaultServiceRegistry.format(provider.getClass()));
        this.findProviderMethods(provider, token);
        return this;
    }

    public void close() {
        this.noLongerMutable();
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            CompositeStoppable.stoppable((Object[])new Object[]{this.allServices}).stop();
        }
    }

    private void serviceRequested() {
        this.noLongerMutable();
        if (this.state.get() == State.CLOSED) {
            throw new IllegalStateException(String.format("%s has been closed.", this.getDisplayName()));
        }
    }

    private void noLongerMutable() {
        this.state.compareAndSet(State.INIT, State.STARTED);
    }

    public boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    public <T> T get(Class<T> serviceType) throws UnknownServiceException, ServiceLookupException {
        return serviceType.cast(this.get((Type)serviceType));
    }

    public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
        Object instance = this.find(serviceType);
        if (instance == null) {
            throw new UnknownServiceException(serviceType, String.format("No service of type %s available in %s.", DefaultServiceRegistry.format(serviceType), this.getDisplayName()));
        }
        return instance;
    }

    public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
        throw new UnknownServiceException(serviceType, String.format("No service of type %s annotated with @%s available in %s.", DefaultServiceRegistry.format(serviceType), annotatedWith.getSimpleName(), this.getDisplayName()));
    }

    public @Nullable Object find(Type serviceType) throws ServiceLookupException {
        DefaultServiceRegistry.assertValidServiceType(DefaultServiceRegistry.unwrap(serviceType));
        Service provider = this.getService(serviceType);
        return provider == null ? null : provider.get();
    }

    private @Nullable Service getService(Type serviceType) {
        this.serviceRequested();
        return DefaultServiceRegistry.find(serviceType, null, this.allServices);
    }

    public <T> List<T> getAll(Class<T> serviceType) throws ServiceLookupException {
        DefaultServiceRegistry.assertValidServiceType(serviceType);
        ArrayList services = new ArrayList();
        this.serviceRequested();
        this.allServices.getAll(serviceType, null, new InstanceUnpackingVisitor(serviceType, services));
        return services;
    }

    private static Class<?> unwrap(Type type) {
        WildcardType wildcardType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof WildcardType && (wildcardType = (WildcardType)type).getUpperBounds()[0] instanceof Class && wildcardType.getLowerBounds().length == 0) {
            return (Class)wildcardType.getUpperBounds()[0];
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return (Class)parameterizedType.getRawType();
    }

    private static void validateImplementationForServiceTypes(List<? extends Type> serviceTypes, Type implementationType) {
        Class<?> implementationClass = DefaultServiceRegistry.unwrap(implementationType);
        for (Type type : serviceTypes) {
            Class<?> serviceClass = DefaultServiceRegistry.unwrap(type);
            if (serviceClass.isAssignableFrom(implementationClass)) continue;
            throw new ServiceValidationException(String.format("Cannot register implementation '%s' for service '%s', because it does not implement it", implementationClass.getSimpleName(), serviceClass.getSimpleName()));
        }
    }

    private static @Nullable Service find(Type serviceType, @Nullable ServiceAccessToken token, ServiceProvider serviceProvider) {
        ParameterizedType parameterizedType;
        Type rawType;
        if (serviceType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)serviceType).getRawType()) instanceof Class) {
            if (((Class)rawType).isAssignableFrom(List.class)) {
                Type typeArg = parameterizedType.getActualTypeArguments()[0];
                return DefaultServiceRegistry.getCollectionService(typeArg, token, serviceProvider);
            }
            DefaultServiceRegistry.assertValidServiceType((Class)rawType);
            return serviceProvider.getService(serviceType, token);
        }
        if (serviceType instanceof Class) {
            DefaultServiceRegistry.assertValidServiceType((Class)serviceType);
            return serviceProvider.getService(serviceType, token);
        }
        throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(serviceType)));
    }

    private static Service getCollectionService(Type elementType, @Nullable ServiceAccessToken token, ServiceProvider serviceProvider) {
        WildcardType wildcardType;
        if (elementType instanceof Class) {
            Class elementClass = (Class)elementType;
            return DefaultServiceRegistry.getCollectionService(elementClass, token, serviceProvider);
        }
        if (elementType instanceof WildcardType && (wildcardType = (WildcardType)elementType).getUpperBounds()[0] instanceof Class && wildcardType.getLowerBounds().length == 0) {
            Class elementClass = (Class)wildcardType.getUpperBounds()[0];
            return DefaultServiceRegistry.getCollectionService(elementClass, token, serviceProvider);
        }
        throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(elementType)));
    }

    private static Service getCollectionService(Class<?> elementClass, @Nullable ServiceAccessToken token, ServiceProvider serviceProvider) {
        DefaultServiceRegistry.assertValidServiceType(elementClass);
        ArrayList<Service> providers = new ArrayList<Service>();
        serviceProvider.getAll(elementClass, token, new CollectingVisitor(providers));
        ArrayList<Object> services = new ArrayList<Object>(providers.size());
        for (Service service : providers) {
            services.add(service.get());
        }
        return new CollectionService(elementClass, services, providers);
    }

    private static boolean isAssignableFromAnyType(Class<?> targetType, List<Class<?>> candidateTypes) {
        for (Class<?> candidate : candidateTypes) {
            if (!targetType.isAssignableFrom(candidate)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqualToAnyType(Type targetType, List<? extends Type> candidateTypes) {
        for (Type type : candidateTypes) {
            if (!targetType.equals(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSatisfiedByAny(Type expected, List<? extends Type> candidates) {
        for (Type type : candidates) {
            if (!DefaultServiceRegistry.isSatisfiedBy(expected, type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSatisfiedBy(Type expected, Type actual) {
        if (expected.equals(actual)) {
            return true;
        }
        if (expected instanceof Class) {
            return DefaultServiceRegistry.isSatisfiedBy((Class)expected, actual);
        }
        if (expected instanceof ParameterizedType) {
            return DefaultServiceRegistry.isSatisfiedBy((ParameterizedType)expected, actual);
        }
        return false;
    }

    private static boolean isSatisfiedBy(Class<?> expectedClass, Type actual) {
        if (actual instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actual;
            if (parameterizedType.getRawType() instanceof Class) {
                return expectedClass.isAssignableFrom((Class)parameterizedType.getRawType());
            }
        } else if (actual instanceof Class) {
            Class other = (Class)actual;
            return expectedClass.isAssignableFrom(other);
        }
        return false;
    }

    private static boolean isSatisfiedBy(ParameterizedType expectedParameterizedType, Type actual) {
        Type expectedRawType = expectedParameterizedType.getRawType();
        if (actual instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actual;
            if (!DefaultServiceRegistry.isSatisfiedBy(expectedRawType, parameterizedType.getRawType())) {
                return false;
            }
            Type[] expectedTypeArguments = expectedParameterizedType.getActualTypeArguments();
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                Type type = parameterizedType.getActualTypeArguments()[i];
                if (DefaultServiceRegistry.isSatisfiedBy(expectedTypeArguments[i], type)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void assertValidServiceType(Class<?> serviceClass) {
        if (serviceClass.isArray()) {
            throw new ServiceValidationException("Locating services with array type is not supported.");
        }
        if (serviceClass.isAnnotation()) {
            throw new ServiceValidationException("Locating services with annotation type is not supported.");
        }
        if (serviceClass == Object.class) {
            throw new ServiceValidationException("Locating services with type Object is not supported.");
        }
    }

    private static String format(Type type) {
        return TypeStringFormatter.format(type);
    }

    private static String format(String qualifier, List<? extends Type> types) {
        if (types.size() == 1) {
            return qualifier + " " + DefaultServiceRegistry.format(types);
        }
        return qualifier + "s " + DefaultServiceRegistry.format(types);
    }

    private static String format(List<? extends Type> types) {
        if (types.size() == 1) {
            return TypeStringFormatter.format(types.get(0));
        }
        return CollectionUtils.join((String)", ", types, TypeStringFormatter::format);
    }

    private static class ClassInspector {
        private final ConcurrentMap<Class<?>, ClassDetails> classes = new ConcurrentHashMap();

        private ClassInspector() {
        }

        boolean hasAnnotation(Class<?> type, Class<? extends Annotation> annotationType) {
            return this.getDetailsForClass(type).hasAnnotation(annotationType);
        }

        Set<Class<?>> getHierarchy(Class<?> type) {
            return this.getDetailsForClass(type).types;
        }

        private ClassDetails getDetailsForClass(Class<?> type) {
            ClassDetails newDetails;
            ClassDetails classDetails = (ClassDetails)this.classes.get(type);
            if (classDetails == null && (classDetails = this.classes.putIfAbsent(type, newDetails = new ClassDetails(type))) == null) {
                classDetails = newDetails;
            }
            return classDetails;
        }

        private static class ClassDetails {
            private final Set<Class<?>> types = new HashSet();
            private final ConcurrentMap<Class<? extends Annotation>, Boolean> annotations = new ConcurrentHashMap<Class<? extends Annotation>, Boolean>();

            public ClassDetails(Class<?> type) {
                this.collectTypes(type, this.types);
            }

            private void collectTypes(@Nullable Class<?> type, Set<Class<?>> types) {
                if (type == null || !types.add(type)) {
                    return;
                }
                this.collectTypes(type.getSuperclass(), types);
                for (Class<?> serviceInterface : type.getInterfaces()) {
                    this.collectTypes(serviceInterface, types);
                }
            }

            public boolean hasAnnotation(Class<? extends Annotation> annotationType) {
                Boolean present = (Boolean)this.annotations.get(annotationType);
                if (present == null) {
                    present = this.locateAnnotation(annotationType);
                    this.annotations.putIfAbsent(annotationType, present);
                }
                return present;
            }

            private boolean locateAnnotation(Class<? extends Annotation> annotation) {
                for (Class<?> type : this.types) {
                    if (type.getAnnotation(annotation) == null) continue;
                    return true;
                }
                return false;
            }
        }
    }

    private class OwnServices
    implements ServiceProvider {
        private final CompositeStoppable stoppable = CompositeStoppable.stoppable((Object[])new Object[0]);
        private final AtomicReference<ServicesSnapshot> services;

        public OwnServices() {
            ThisAsService thisServiceRegistry = new ThisAsService(ServiceAccess.getPublicScope());
            this.services = new AtomicReference<ServicesSnapshot>(ServicesSnapshot.of(PersistentMap.of(ServiceRegistry.class, (Object)PersistentArray.of((Object)thisServiceRegistry))));
        }

        @Override
        public @Nullable Service getService(Type type, @Nullable ServiceAccessToken token) {
            PersistentArray<ServiceProvider> serviceProviders = this.getProviders(DefaultServiceRegistry.unwrap(type));
            if (serviceProviders.isEmpty()) {
                return null;
            }
            if (serviceProviders.size() == 1) {
                return ((ServiceProvider)serviceProviders.get(0)).getService(type, token);
            }
            ArrayList<Service> services = new ArrayList<Service>(serviceProviders.size());
            for (Object serviceProvider : serviceProviders) {
                Service service = serviceProvider.getService(type, token);
                if (service == null) continue;
                services.add(service);
            }
            if (services.isEmpty()) {
                return null;
            }
            if (services.size() == 1) {
                return (Service)services.get(0);
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (Service candidate : services) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple services of type %s available in %s:", DefaultServiceRegistry.format(type), DefaultServiceRegistry.this.getDisplayName());
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        private PersistentArray<ServiceProvider> getProviders(Class<?> type) {
            PersistentMap<Class<?>, PersistentArray<ServiceProvider>> providersByType = this.services.get().providersByType;
            return (PersistentArray)providersByType.getOrDefault(type, (Object)PersistentArray.of());
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, @Nullable ServiceAccessToken token, ServiceProvider.Visitor visitor) {
            for (ServiceProvider serviceProvider : this.getProviders(serviceType)) {
                visitor = serviceProvider.getAll(serviceType, token, visitor);
            }
            return visitor;
        }

        public void stop() {
            this.stoppable.stop();
        }

        public void add(SingletonService serviceProvider) {
            DefaultServiceRegistry.this.assertMutable();
            this.stoppable.add((Stoppable)serviceProvider);
            ServicesSnapshot snapshot = this.services.updateAndGet(it -> it.addService(serviceProvider, DefaultServiceRegistry.this.inspector));
            for (AnnotatedServiceLifecycleHandler annotationHandler : snapshot.lifecycleHandlers) {
                this.notifyAnnotationHandler(annotationHandler, serviceProvider);
            }
        }

        public void instanceRealized(List<Class<?>> declaredServiceTypes, Supplier<String> displayName, Object instance) {
            if (instance instanceof AnnotatedServiceLifecycleHandler && !DefaultServiceRegistry.isAssignableFromAnyType(AnnotatedServiceLifecycleHandler.class, declaredServiceTypes)) {
                throw new IllegalStateException(String.format("%s implements %s but is not declared as a service of this type. This service is declared as having %s.", displayName.get(), AnnotatedServiceLifecycleHandler.class.getSimpleName(), DefaultServiceRegistry.format("type", declaredServiceTypes)));
            }
            if (instance instanceof AnnotatedServiceLifecycleHandler) {
                this.annotationHandlerCreated((AnnotatedServiceLifecycleHandler)instance);
            }
            PersistentArray<AnnotatedServiceLifecycleHandler> lifecycleHandlers = this.services.get().lifecycleHandlers;
            for (AnnotatedServiceLifecycleHandler lifecycleHandler : lifecycleHandlers) {
                for (Class annotation : lifecycleHandler.getAnnotations()) {
                    boolean implementationHasAnnotation = DefaultServiceRegistry.this.inspector.hasAnnotation(instance.getClass(), annotation);
                    boolean declaredWithAnnotation = this.anyTypeHasAnnotation(annotation, declaredServiceTypes);
                    if (!implementationHasAnnotation || declaredWithAnnotation) continue;
                    throw new IllegalStateException(String.format("%s is annotated with @%s but is not declared as a service with this annotation. This service is declared as having %s.", displayName.get(), DefaultServiceRegistry.format(annotation), DefaultServiceRegistry.format("type", declaredServiceTypes)));
                }
            }
        }

        void annotationHandlerCreated(AnnotatedServiceLifecycleHandler annotationHandler) {
            ServicesSnapshot snapshot = this.services.updateAndGet(it -> it.addLifecycleHandler(annotationHandler));
            ServiceList list = snapshot.services;
            while (list != null) {
                this.notifyAnnotationHandler(annotationHandler, list.service);
                list = list.next;
            }
        }

        private void notifyAnnotationHandler(AnnotatedServiceLifecycleHandler annotationHandler, SingletonService candidate) {
            if (annotationHandler.getImplicitAnnotation() != null) {
                annotationHandler.whenRegistered(annotationHandler.getImplicitAnnotation(), (AnnotatedServiceLifecycleHandler.Registration)new RegistrationWrapper(candidate));
            } else {
                List<Class<?>> declaredServiceTypes = candidate.getDeclaredServiceTypes();
                for (Class annotation : annotationHandler.getAnnotations()) {
                    if (!this.anyTypeHasAnnotation(annotation, declaredServiceTypes)) continue;
                    annotationHandler.whenRegistered(annotation, (AnnotatedServiceLifecycleHandler.Registration)new RegistrationWrapper(candidate));
                }
            }
        }

        private boolean anyTypeHasAnnotation(Class<? extends Annotation> annotation, List<Class<?>> types) {
            for (Class<?> type : types) {
                if (!DefaultServiceRegistry.this.inspector.hasAnnotation(type, annotation)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return DefaultServiceRegistry.this.getDisplayName();
        }
    }

    private static enum State {
        INIT,
        STARTED,
        CLOSED;

    }

    private static class CompositeServiceProvider
    implements ServiceProvider {
        private final ServiceProvider[] serviceProviders;

        private CompositeServiceProvider(ServiceProvider ... serviceProviders) {
            this.serviceProviders = serviceProviders;
        }

        @Override
        public @Nullable Service getService(Type serviceType, @Nullable ServiceAccessToken token) {
            for (ServiceProvider serviceProvider : this.serviceProviders) {
                Service service = serviceProvider.getService(serviceType, token);
                if (service == null) continue;
                return service;
            }
            return null;
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, @Nullable ServiceAccessToken token, ServiceProvider.Visitor visitor) {
            for (ServiceProvider serviceProvider : this.serviceProviders) {
                visitor = serviceProvider.getAll(serviceType, token, visitor);
            }
            return visitor;
        }

        public void stop() {
            try {
                CompositeStoppable.stoppable(Arrays.asList(this.serviceProviders)).stop();
            }
            finally {
                Arrays.fill(this.serviceProviders, null);
            }
        }

        public String toString() {
            return Arrays.toString(this.serviceProviders);
        }
    }

    private static class ParentServices
    implements ServiceProvider {
        private final ServiceProvider parent;

        private ParentServices(ServiceProvider parent) {
            this.parent = parent;
        }

        @Override
        public @Nullable Service getService(Type serviceType, @Nullable ServiceAccessToken token) {
            return this.parent.getService(serviceType, token);
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, @Nullable ServiceAccessToken token, ServiceProvider.Visitor visitor) {
            return this.parent.getAll(serviceType, token, visitor);
        }

        public void stop() {
        }

        public String toString() {
            return this.parent.toString();
        }
    }

    private static class FactoryMethodService
    extends FactoryService {
        private @Nullable ServiceMethod method;
        private @Nullable Object target;

        public FactoryMethodService(DefaultServiceRegistry owner, ServiceAccessScope accessScope, ServiceAccessToken token, Object target, ServiceMethod method) {
            this(owner, accessScope, token, FactoryMethodService.serviceTypesOf(method), target, method);
        }

        private FactoryMethodService(DefaultServiceRegistry owner, ServiceAccessScope accessScope, ServiceAccessToken token, List<? extends Type> serviceTypes, Object target, ServiceMethod method) {
            super(owner, accessScope, token, serviceTypes);
            DefaultServiceRegistry.validateImplementationForServiceTypes(serviceTypes, method.getServiceType());
            this.target = target;
            this.method = method;
        }

        private static List<? extends Type> serviceTypesOf(ServiceMethod method) {
            Class[] explicitServiceTypes = method.getMethod().getAnnotation(Provides.class).value();
            return explicitServiceTypes.length == 0 ? Collections.singletonList(method.getServiceType()) : Arrays.asList(explicitServiceTypes);
        }

        @Override
        public String getDisplayName() {
            if (this.method == null) {
                return super.getDisplayName();
            }
            return DefaultServiceRegistry.format("Service", this.serviceTypes) + " via " + DefaultServiceRegistry.format(this.method.getOwner()) + "." + this.method.getName() + "()";
        }

        @Override
        protected Type[] getParameterTypes() {
            return this.getMethod().getParameterTypes();
        }

        private ServiceMethod getMethod() {
            ServiceMethod method = this.method;
            if (method == null) {
                throw new IllegalStateException("Method is no longer available for the instance of " + DefaultServiceRegistry.format("service", this.serviceTypes));
            }
            return method;
        }

        @Override
        protected String getFactoryDisplayName() {
            return String.format("method %s.%s()", DefaultServiceRegistry.format(this.getMethod().getOwner()), this.getMethod().getName());
        }

        @Override
        protected Object invokeMethod(Object[] params) {
            Object result;
            if (this.target == null) {
                throw new IllegalStateException("The target of the factory method has been discarded after the first service creation attempt");
            }
            ServiceMethod method = this.getMethod();
            try {
                result = method.invoke(this.target, params);
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of %s using %s.%s().", DefaultServiceRegistry.format("type", this.serviceTypes), method.getOwner().getSimpleName(), method.getName()), (Throwable)e);
            }
            if (result == null) {
                throw new ServiceCreationException(String.format("Could not create service of %s using %s.%s() as this method returned null.", DefaultServiceRegistry.format("type", this.serviceTypes), method.getOwner().getSimpleName(), method.getName()));
            }
            return result;
        }

        @Override
        protected Object createServiceInstance() {
            Object result = super.createServiceInstance();
            this.target = null;
            this.method = null;
            return result;
        }
    }

    private static abstract class SingletonService
    extends ManagedObjectServiceProvider {
        protected final ServiceAccessScope accessScope;
        protected final List<? extends Type> serviceTypes;
        private final List<Class<?>> serviceTypesAsClasses;
        BindState state = BindState.UNBOUND;

        SingletonService(DefaultServiceRegistry owner, ServiceAccessScope accessScope, List<? extends Type> serviceTypes) {
            super(owner);
            if (serviceTypes.isEmpty()) {
                throw new IllegalArgumentException("Expected at least one declared service type");
            }
            this.accessScope = accessScope;
            this.serviceTypes = serviceTypes;
            this.serviceTypesAsClasses = CollectionUtils.collect(serviceTypes, x$0 -> DefaultServiceRegistry.unwrap(x$0));
        }

        @Override
        List<Class<?>> getDeclaredServiceTypes() {
            return this.serviceTypesAsClasses;
        }

        @Override
        public String getDisplayName() {
            return DefaultServiceRegistry.format("Service", this.serviceTypes);
        }

        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public Object get() {
            return this.getInstance();
        }

        private Object getPreparedInstance() {
            return this.prepare().get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Service prepare() {
            if (this.state == BindState.BOUND) {
                return this;
            }
            SingletonService singletonService = this;
            synchronized (singletonService) {
                if (this.state == BindState.BINDING) {
                    throw new ServiceValidationException("Cycle in dependencies of " + this.getDisplayName() + " detected");
                }
                if (this.state == BindState.UNBOUND) {
                    this.state = BindState.BINDING;
                    try {
                        this.bind();
                        this.state = BindState.BOUND;
                    }
                    catch (RuntimeException e) {
                        this.state = BindState.UNBOUND;
                        throw e;
                    }
                }
                return this;
            }
        }

        protected void bind() {
        }

        @Override
        public @Nullable Service getService(Type serviceType, @Nullable ServiceAccessToken token) {
            if (!this.accessScope.contains(token)) {
                return null;
            }
            if (!DefaultServiceRegistry.isSatisfiedByAny(serviceType, this.serviceTypes)) {
                return null;
            }
            return this.prepare();
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, @Nullable ServiceAccessToken token, ServiceProvider.Visitor visitor) {
            if (!this.accessScope.contains(token)) {
                return visitor;
            }
            if (DefaultServiceRegistry.isAssignableFromAnyType(serviceType, this.serviceTypesAsClasses)) {
                visitor.visit(this.prepare());
            }
            return visitor;
        }

        private static enum BindState {
            UNBOUND,
            BINDING,
            BOUND;

        }
    }

    private static class FixedInstanceService
    extends SingletonService {
        public FixedInstanceService(DefaultServiceRegistry owner, ServiceAccessScope accessScope, Class<?> serviceType, Object serviceInstance) {
            super(owner, accessScope, Collections.singletonList(serviceType));
            this.setInstance(serviceInstance);
        }

        private String getDisplayNameImpl(Object serviceInstance) {
            return DefaultServiceRegistry.format("Service", this.serviceTypes) + " with implementation " + DefaultServiceRegistry.format(serviceInstance.getClass());
        }

        @Override
        protected void instanceRealized(Object instance) {
            this.owner.ownServices.instanceRealized(this.getDeclaredServiceTypes(), () -> this.getDisplayNameImpl(instance), instance);
        }

        @Override
        public String getDisplayName() {
            return this.getDisplayNameImpl(this.getInstance());
        }

        @Override
        protected Object createServiceInstance() {
            throw new UnsupportedOperationException();
        }
    }

    private static class InstanceUnpackingVisitor<T>
    implements ServiceProvider.Visitor {
        private final Class<T> serviceType;
        private final List<T> delegate;

        private InstanceUnpackingVisitor(Class<T> serviceType, List<T> delegate) {
            this.serviceType = serviceType;
            this.delegate = delegate;
        }

        @Override
        public void visit(Service service) {
            T instance = this.serviceType.cast(service.get());
            if (!this.delegate.contains(instance)) {
                this.delegate.add(instance);
            }
        }
    }

    private static class CollectingVisitor
    implements ServiceProvider.Visitor {
        private final List<Service> delegate;

        private CollectingVisitor(List<Service> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void visit(Service service) {
            if (!this.delegate.contains(service)) {
                this.delegate.add(service);
            }
        }
    }

    private static class CollectionService
    implements Service {
        private final Type typeArg;
        private final List<Object> services;
        private final List<Service> providers;

        public CollectionService(Type typeArg, List<Object> services, List<Service> providers) {
            this.typeArg = typeArg;
            this.services = services;
            this.providers = providers;
        }

        @Override
        public String getDisplayName() {
            return "services with type " + this.typeArg;
        }

        @Override
        public Object get() {
            return this.services;
        }

        @Override
        public void requiredBy(ServiceProvider serviceProvider) {
            for (Service service : this.providers) {
                service.requiredBy(serviceProvider);
            }
        }
    }

    private static class ServiceList {
        final SingletonService service;
        final @Nullable ServiceList next;

        ServiceList(SingletonService head, @Nullable ServiceList next) {
            this.service = head;
            this.next = next;
        }
    }

    private static class ServicesSnapshot {
        final @Nullable ServiceList services;
        final PersistentArray<AnnotatedServiceLifecycleHandler> lifecycleHandlers;
        final PersistentMap<Class<?>, PersistentArray<ServiceProvider>> providersByType;

        public static ServicesSnapshot of(PersistentMap<Class<?>, PersistentArray<ServiceProvider>> providersByType) {
            return new ServicesSnapshot(null, (PersistentArray<AnnotatedServiceLifecycleHandler>)PersistentArray.of(), providersByType);
        }

        private ServicesSnapshot(@Nullable ServiceList services, PersistentArray<AnnotatedServiceLifecycleHandler> lifecycleHandlers, PersistentMap<Class<?>, PersistentArray<ServiceProvider>> providersByType) {
            this.services = services;
            this.lifecycleHandlers = lifecycleHandlers;
            this.providersByType = providersByType;
        }

        ServicesSnapshot addService(SingletonService service, ClassInspector inspector) {
            return new ServicesSnapshot(new ServiceList(service, this.services), this.lifecycleHandlers, ServicesSnapshot.collectProvidersForClassHierarchyOf(service, inspector, this.providersByType));
        }

        ServicesSnapshot addLifecycleHandler(AnnotatedServiceLifecycleHandler lifecycleHandler) {
            return new ServicesSnapshot(this.services, (PersistentArray<AnnotatedServiceLifecycleHandler>)this.lifecycleHandlers.plus((Object)lifecycleHandler), this.providersByType);
        }

        private static PersistentMap<Class<?>, PersistentArray<ServiceProvider>> collectProvidersForClassHierarchyOf(SingletonService serviceProvider, ClassInspector inspector, PersistentMap<Class<?>, PersistentArray<ServiceProvider>> providersByType) {
            PersistentArray newProviders = PersistentArray.of((Object)serviceProvider);
            for (Class<?> serviceType : serviceProvider.getDeclaredServiceTypes()) {
                for (Class<?> type : inspector.getHierarchy(serviceType)) {
                    if (type.equals(Object.class)) continue;
                    if (type.equals(ServiceRegistry.class)) {
                        throw new IllegalArgumentException("Cannot define a service of type ServiceRegistry: " + serviceProvider);
                    }
                    providersByType = providersByType.modify(type, (key, providers) -> {
                        if (providers == null) {
                            return newProviders;
                        }
                        return providers.contains((Object)serviceProvider) ? providers : providers.plus((Object)serviceProvider);
                    });
                }
            }
            return providersByType;
        }
    }

    private class ThisAsService
    implements ServiceProvider,
    Service {
        private final ServiceAccessScope accessScope;

        private ThisAsService(ServiceAccessScope accessScope) {
            this.accessScope = accessScope;
        }

        @Override
        public @Nullable Service getService(Type serviceType, @Nullable ServiceAccessToken token) {
            if (!this.accessScope.contains(token)) {
                return null;
            }
            if (serviceType.equals(ServiceRegistry.class)) {
                return this;
            }
            return null;
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, @Nullable ServiceAccessToken token, ServiceProvider.Visitor visitor) {
            if (!this.accessScope.contains(token)) {
                return visitor;
            }
            if (serviceType.equals(ServiceRegistry.class)) {
                visitor.visit(this);
            }
            return visitor;
        }

        public void stop() {
        }

        @Override
        public String getDisplayName() {
            return "ServiceRegistry " + DefaultServiceRegistry.this.getDisplayName();
        }

        @Override
        public Object get() {
            return DefaultServiceRegistry.this;
        }

        @Override
        public void requiredBy(ServiceProvider serviceProvider) {
        }
    }

    private static class ConstructorService
    extends FactoryService {
        private @Nullable Constructor<?> constructor;

        private ConstructorService(DefaultServiceRegistry owner, ServiceAccessScope accessScope, ServiceAccessToken token, Class<?> serviceType) {
            this(owner, accessScope, token, serviceType, serviceType);
        }

        private ConstructorService(DefaultServiceRegistry owner, ServiceAccessScope accessScope, ServiceAccessToken token, Class<?> serviceType, Class<?> implementationType) {
            this(owner, accessScope, token, Collections.singletonList(serviceType), implementationType);
        }

        private ConstructorService(DefaultServiceRegistry owner, ServiceAccessScope accessScope, ServiceAccessToken token, List<? extends Type> serviceTypes, Class<?> implementationType) {
            super(owner, accessScope, token, serviceTypes);
            if (implementationType.isInterface()) {
                throw new ServiceValidationException(String.format("Cannot register an interface (%s) for construction.", implementationType.getCanonicalName()));
            }
            if (Modifier.isAbstract(implementationType.getModifiers())) {
                throw new ServiceValidationException(String.format("Cannot register an abstract type (%s) for construction.", implementationType.getCanonicalName()));
            }
            DefaultServiceRegistry.validateImplementationForServiceTypes(serviceTypes, implementationType);
            Constructor<?> match = InjectUtil.selectConstructor(implementationType);
            if (InjectUtil.isPackagePrivate(match.getModifiers()) || Modifier.isPrivate(match.getModifiers())) {
                match.setAccessible(true);
            }
            this.constructor = match;
        }

        @Override
        protected Type[] getParameterTypes() {
            return this.getConstructor().getGenericParameterTypes();
        }

        @Override
        protected Object createServiceInstance() {
            Object result = super.createServiceInstance();
            this.constructor = null;
            return result;
        }

        @Override
        public String getDisplayName() {
            if (this.constructor == null) {
                return super.getDisplayName();
            }
            return DefaultServiceRegistry.format("Service", this.serviceTypes) + " via " + DefaultServiceRegistry.format(this.getConstructor().getDeclaringClass()) + " constructor";
        }

        @Override
        protected String getFactoryDisplayName() {
            return String.format("%s constructor", DefaultServiceRegistry.format(this.getConstructor().getDeclaringClass()));
        }

        @Override
        protected Object invokeMethod(Object[] params) {
            try {
                return this.getConstructor().newInstance(params);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw new ServiceCreationException(String.format("Could not create service of %s.", DefaultServiceRegistry.format("type", this.serviceTypes)), cause != null ? cause : e);
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of %s.", DefaultServiceRegistry.format("type", this.serviceTypes)), (Throwable)e);
            }
        }

        private Constructor<?> getConstructor() {
            Constructor<?> constructor = this.constructor;
            if (constructor == null) {
                throw new IllegalStateException("Constructor is no longer available for the instance of " + DefaultServiceRegistry.format("service", this.serviceTypes));
            }
            return constructor;
        }
    }

    private static abstract class FactoryService
    extends SingletonService {
        private final ServiceAccessToken accessToken;
        private Service @Nullable [] paramServices;
        private @Nullable Service decorates;

        protected FactoryService(DefaultServiceRegistry owner, ServiceAccessScope accessScope, ServiceAccessToken accessToken, List<? extends Type> serviceTypes) {
            super(owner, accessScope, serviceTypes);
            this.accessToken = accessToken;
        }

        protected abstract Type[] getParameterTypes();

        protected abstract String getFactoryDisplayName();

        @Override
        protected void bind() {
            Type[] parameterTypes = this.getParameterTypes();
            if (parameterTypes.length == 0) {
                this.paramServices = NO_DEPENDENTS;
                return;
            }
            this.paramServices = new Service[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Service paramProvider;
                Type paramType = parameterTypes[i];
                if (DefaultServiceRegistry.isEqualToAnyType(paramType, this.serviceTypes)) {
                    ServiceProvider parentServices = this.owner.parentServices;
                    if (parentServices == null) {
                        throw new ServiceCreationException(String.format("Cannot create service of %s using %s as not parent registry is available to look up required service of type %s for parameter #%s.", DefaultServiceRegistry.format("type", this.serviceTypes), this.getFactoryDisplayName(), DefaultServiceRegistry.format(paramType), i + 1));
                    }
                    Service paramProvider2 = DefaultServiceRegistry.find(paramType, this.accessToken, parentServices);
                    if (paramProvider2 == null) {
                        throw new ServiceCreationException(String.format("Cannot create service of %s using %s as required service of type %s for parameter #%s is not available in parent registries.", DefaultServiceRegistry.format("type", this.serviceTypes), this.getFactoryDisplayName(), DefaultServiceRegistry.format(paramType), i + 1));
                    }
                    this.paramServices[i] = paramProvider2;
                    this.decorates = paramProvider2;
                    continue;
                }
                try {
                    paramProvider = DefaultServiceRegistry.find(paramType, this.accessToken, this.owner.allServices);
                }
                catch (ServiceLookupException e) {
                    throw new ServiceCreationException(String.format("Cannot create service of %s using %s as there is a problem with parameter #%s of type %s.", DefaultServiceRegistry.format("type", this.serviceTypes), this.getFactoryDisplayName(), i + 1, DefaultServiceRegistry.format(paramType)), (Throwable)e);
                }
                if (paramProvider == null) {
                    throw new ServiceCreationException(String.format("Cannot create service of %s using %s as required service of type %s for parameter #%s is not available.", DefaultServiceRegistry.format("type", this.serviceTypes), this.getFactoryDisplayName(), DefaultServiceRegistry.format(paramType), i + 1));
                }
                this.paramServices[i] = paramProvider;
                paramProvider.requiredBy(this);
            }
        }

        @Override
        protected Object createServiceInstance() {
            Object[] params = this.assembleParameters();
            Object result = this.invokeMethod(params);
            this.paramServices = null;
            return result;
        }

        private Object[] assembleParameters() {
            if (this.paramServices == null) {
                throw new IllegalStateException(String.format("Factory %s is not bound or the instance has been created already", this.getFactoryDisplayName()));
            }
            if (this.paramServices == NO_DEPENDENTS) {
                return NO_PARAMS;
            }
            Object[] params = new Object[this.paramServices.length];
            for (int i = 0; i < this.paramServices.length; ++i) {
                Service paramProvider = this.paramServices[i];
                params[i] = paramProvider.get();
            }
            return params;
        }

        @Override
        public ServiceProvider.Visitor getAll(Class<?> serviceType, @Nullable ServiceAccessToken token, final ServiceProvider.Visitor visitor) {
            super.getAll(serviceType, token, visitor);
            if (this.decorates == null) {
                return visitor;
            }
            return new ServiceProvider.Visitor(){

                @Override
                public void visit(Service service) {
                    if (service != decorates) {
                        visitor.visit(service);
                    }
                }
            };
        }

        protected abstract Object invokeMethod(Object[] var1);
    }

    private static abstract class ManagedObjectServiceProvider
    implements ServiceProvider,
    Service {
        protected final DefaultServiceRegistry owner;
        private final Queue<ServiceProvider> dependents = new ConcurrentLinkedQueue<ServiceProvider>();
        private volatile @Nullable Object instance;

        protected ManagedObjectServiceProvider(DefaultServiceRegistry owner) {
            this.owner = owner;
        }

        abstract List<Class<?>> getDeclaredServiceTypes();

        protected void instanceRealized(Object instance) {
            this.owner.ownServices.instanceRealized(this.getDeclaredServiceTypes(), this::getDisplayName, instance);
        }

        protected void setInstance(Object instance) {
            this.instanceRealized(instance);
            this.instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Object getInstance() {
            Object result = this.instance;
            if (result == null) {
                ManagedObjectServiceProvider managedObjectServiceProvider = this;
                synchronized (managedObjectServiceProvider) {
                    result = this.instance;
                    if (result == null) {
                        result = this.createServiceInstance();
                        this.setInstance(result);
                    }
                }
            }
            return result;
        }

        protected abstract Object createServiceInstance();

        @Override
        public final void requiredBy(ServiceProvider serviceProvider) {
            if (this.fromSameRegistry(serviceProvider)) {
                this.dependents.add(serviceProvider);
            }
        }

        private boolean fromSameRegistry(ServiceProvider serviceProvider) {
            return serviceProvider instanceof ManagedObjectServiceProvider && ((ManagedObjectServiceProvider)serviceProvider).owner == this.owner;
        }

        public final synchronized void stop() {
            try {
                Object theInstance = this.instance;
                if (theInstance != null) {
                    CompositeStoppable.stoppable(this.dependents).add(theInstance).stop();
                }
            }
            finally {
                this.dependents.clear();
                this.instance = null;
            }
        }
    }

    private class RegistrationWrapper
    implements AnnotatedServiceLifecycleHandler.Registration {
        private final SingletonService serviceProvider;

        public RegistrationWrapper(SingletonService serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public List<Class<?>> getDeclaredTypes() {
            return this.serviceProvider.getDeclaredServiceTypes();
        }

        public Object getInstance() {
            DefaultServiceRegistry.this.serviceRequested();
            return this.serviceProvider.getPreparedInstance();
        }
    }
}

