/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import java.io.File;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.kotlin.dsl.execution.KotlinMetadataVersionExtractor;
import org.gradle.kotlin.dsl.internal.relocated.kotlin.metadata.internal.metadata.deserialization.MetadataVersion;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/gradle/kotlin/dsl/execution/ClasspathElementChecker;", "", "classpathWalker", "Lorg/gradle/internal/classpath/ClasspathWalker;", "extractor", "Lorg/gradle/kotlin/dsl/execution/KotlinMetadataVersionExtractor;", "<init>", "(Lorg/gradle/internal/classpath/ClasspathWalker;Lorg/gradle/kotlin/dsl/execution/KotlinMetadataVersionExtractor;)V", "getClasspathWalker", "()Lorg/gradle/internal/classpath/ClasspathWalker;", "getExtractor", "()Lorg/gradle/kotlin/dsl/execution/KotlinMetadataVersionExtractor;", "isCompatible", "", "file", "Ljava/io/File;", "kotlin-dsl"})
final class ClasspathElementChecker {
    @NotNull
    private final ClasspathWalker classpathWalker;
    @NotNull
    private final KotlinMetadataVersionExtractor extractor;

    public ClasspathElementChecker(@NotNull ClasspathWalker classpathWalker, @NotNull KotlinMetadataVersionExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)classpathWalker, (String)"classpathWalker");
        Intrinsics.checkNotNullParameter((Object)((Object)extractor), (String)"extractor");
        this.classpathWalker = classpathWalker;
        this.extractor = extractor;
    }

    @NotNull
    public final ClasspathWalker getClasspathWalker() {
        return this.classpathWalker;
    }

    @NotNull
    public final KotlinMetadataVersionExtractor getExtractor() {
        return this.extractor;
    }

    public final boolean isCompatible(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        HashSet<String> seenPaths = new HashSet<String>();
        Ref.BooleanRef incompatibilityFound = new Ref.BooleanRef();
        this.classpathWalker.visit(file, new ClasspathEntryVisitor(incompatibilityFound, seenPaths, this){
            final /* synthetic */ Ref.BooleanRef $incompatibilityFound;
            final /* synthetic */ HashSet<String> $seenPaths;
            final /* synthetic */ ClasspathElementChecker this$0;
            {
                this.$incompatibilityFound = $incompatibilityFound;
                this.$seenPaths = $seenPaths;
                this.this$0 = $receiver;
            }

            public final void visit(ClasspathEntryVisitor.Entry entry) {
                if (!this.$incompatibilityFound.element) {
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null)) {
                        String string2 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        String path = StringsKt.substringBeforeLast((String)string2, (char)'/', (String)"");
                        if (this.$seenPaths.add(path)) {
                            ClassReader classReader = new ClassReader(entry.getContent());
                            classReader.accept((ClassVisitor)this.this$0.getExtractor().reset(), 7);
                            if (this.this$0.getExtractor().getVersion() != null) {
                                int[] nArray = this.this$0.getExtractor().getVersion();
                                Intrinsics.checkNotNull((Object)nArray);
                                MetadataVersion metadataVersion = new MetadataVersion(nArray, false);
                                boolean compatible = metadataVersion.isCompatibleWithCurrentCompilerVersion();
                                if (!compatible) {
                                    this.$incompatibilityFound.element = true;
                                }
                            }
                        }
                    }
                }
            }
        });
        return !incompatibilityFound.element;
    }
}

