/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal;

import org.gradle.internal.UncheckedException;

public class GeneratedSubclasses {

    private GeneratedSubclasses() {
    }

    public static Class<?> unpack(Class<?> type) {
        if (isGeneratedType(type)) {
            return unpackOrFail(type);
        }
        return type;
    }

    public static boolean isGeneratedType(Class<?> type) {
        return GeneratedSubclass.class.isAssignableFrom(type);
    }

    public static Class<?> unpackOrFail(Class<?> type) {
        try {
            return (Class<?>) type.getMethod("generatedFrom").invoke(null);
        } catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    public static Class<?> unpackType(Object object) {
        if (object instanceof GeneratedSubclass) {
            return ((GeneratedSubclass) object).publicType();
        }
        return object.getClass();
    }
}
