/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree.control;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.internal.buildtree.BuildActionModelRequirements;
import org.gradle.internal.buildtree.BuildModelParameters;
import org.gradle.internal.buildtree.BuildModelParametersFactory;
import org.gradle.internal.buildtree.control.BuildModelParametersProvider;
import org.gradle.util.internal.IncubationLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gradle/internal/buildtree/control/DefaultBuildModelParametersFactory;", "Lorg/gradle/internal/buildtree/BuildModelParametersFactory;", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "parametersForRootBuildTree", "Lorg/gradle/internal/buildtree/BuildModelParameters;", "requirements", "Lorg/gradle/internal/buildtree/BuildActionModelRequirements;", "internalOptions", "Lorg/gradle/internal/buildoption/InternalOptions;", "parametersForNestedBuildTree", "configuration-cache"})
public final class DefaultBuildModelParametersFactory
implements BuildModelParametersFactory {
    private final Logger logger = Logging.getLogger(DefaultBuildModelParametersFactory.class);

    @NotNull
    public BuildModelParameters parametersForRootBuildTree(@NotNull BuildActionModelRequirements requirements, @NotNull InternalOptions internalOptions) {
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter((Object)internalOptions, (String)"internalOptions");
        BuildModelParameters modelParameters = BuildModelParametersProvider.parameters(requirements, internalOptions);
        this.logger.info("Operational build model parameters: {}", (Object)modelParameters.toDisplayMap());
        String string = modelParameters.getConfigurationCacheDisabledReason();
        if (string != null) {
            String reason = string;
            boolean bl = false;
            Object[] objectArray = new Object[]{requirements.getActionDisplayName().getCapitalizedDisplayName(), reason};
            this.logger.lifecycle("{} as configuration cache cannot be reused {}", objectArray);
        }
        if (modelParameters.isIsolatedProjects()) {
            IncubationLogger.incubatingFeatureUsed((String)"Isolated Projects");
        } else {
            if (modelParameters.isConfigurationCacheParallelStore()) {
                IncubationLogger.incubatingFeatureUsed((String)"Parallel Configuration Cache");
            }
            if (modelParameters.isConfigureOnDemand()) {
                IncubationLogger.incubatingFeatureUsed((String)"Configuration on demand");
            }
        }
        return modelParameters;
    }

    @NotNull
    public BuildModelParameters parametersForNestedBuildTree(@NotNull BuildActionModelRequirements requirements) {
        Intrinsics.checkNotNullParameter((Object)requirements, (String)"requirements");
        StartParameterInternal startParameterInternal = requirements.getStartParameter();
        Intrinsics.checkNotNullExpressionValue((Object)startParameterInternal, (String)"getStartParameter(...)");
        return BuildModelParametersProvider.parametersForNestedBuildTree(startParameterInternal);
    }
}

