/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.options;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.buildoption.DefaultInternalOptions;
import org.gradle.internal.buildoption.InternalOption;
import org.gradle.internal.buildoption.InternalOptions;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.Nullable;

public class InternalOptionsFactory {
    public static InternalOptions createInternalOptions(StartParameterInternal startParameter, File rootBuildDir) {
        HashMap<String, String> properties = new HashMap<String, String>();
        InternalOptionsFactory.putAllProperties(properties, startParameter.getGradleHomeDir());
        InternalOptionsFactory.putAllProperties(properties, rootBuildDir);
        InternalOptionsFactory.putAllProperties(properties, startParameter.getGradleUserHomeDir());
        properties.putAll(startParameter.getSystemPropertiesArgs());
        Map<String, String> internalProperties = InternalOptionsFactory.filterInternalOptions(properties);
        return new DefaultInternalOptions(internalProperties);
    }

    private static Map<String, String> filterInternalOptions(Map<String, String> map) {
        return map.entrySet().stream().filter(entry -> InternalOption.isInternalOption((String)((String)entry.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static void putAllProperties(Map<String, String> properties, @Nullable File dir) {
        if (dir == null) {
            return;
        }
        File propertiesFile = new File(dir, "gradle.properties");
        if (propertiesFile.isFile()) {
            Map readProperties = (Map)Cast.uncheckedNonnullCast((Object)GUtil.loadProperties((File)propertiesFile));
            properties.putAll(readProperties);
        }
    }
}

